// GenAlg.h - interface for CGenAlg, CChromozome, CEdgeInfo
//

#ifndef __GENETICALGORITHM_H__
#define __GENETICALGORITHM_H__

#include "CEPNobj.h"

class CEdgeInfo;
/////////////////////////////////////////////////////////////////////////////
// CChromozome
class CChromozome
{
public:
	CChromozome();
	CChromozome(CChromozome& chromozome);
	virtual ~CChromozome();

private:
	enum { GRID_SPAN=60 };
	
	bool	m_modified; // modification after mutation
	int		m_nGenes; // number of genes in chromosome=pair of x and y
	int		m_grid_size; // size of graph area, number of places for nodes, always a square
	int		m_grid_span; // minimal distance between nodes
	int		m_grid_diagonal;
	DWORD*	m_genes; // genes - position x and y of nodes, 2*m_nGenes
	BYTE*	m_occupation; // array of nodes occupation in grid

public:
	DWORD	m_nFitness;

public:
//	void Apply(const CTypedPtrArray<CObArray,CPNCase*>& cases,int nCases); // for DEBUG only
	void Init(int nGenes,int grid_size);
	void Generate();
	void Mutate_Swap();
	void Mutate_Move();
	void Mutate_SmallMove();
	void Cross(CChromozome& parent_2,CChromozome& child_1,CChromozome& child_2);
	DWORD ComputeFitness(const CArray<CEdgeInfo,CEdgeInfo&>& edges,int nEdges,int& intersections,int weight_intersections,int weight_edgelength,int weight_objdistance_min,int weight_objdistance_max);

	bool  IsModified()				{ return m_modified; }
	DWORD GetGene_x(int gene_pos)	{ return m_genes[gene_pos*2]; }
	DWORD GetGene_y(int gene_pos)	{ return m_genes[gene_pos*2+1]; }

public:
	CChromozome& operator=(const CChromozome& chromozome);
};

/////////////////////////////////////////////////////////////////////////////
// CEdgeInfo
class CEdgeInfo
{
/*
public:
	CEdgeInfo();
	CEdgeInfo(CEdgeInfo& edge_info);*/

public:
	int		m_from,m_to; // index into array of genes in chromosome
	int		m_x,m_y,m_u,m_v; // line coeficients
	int		m_x_to,m_y_to;
	CRect	m_rect; // bounding rectangle

public:
	int  GetLength();
	bool Intersect(CEdgeInfo& edge_info,bool recurse=false);
//	bool IntersectCase(CPoint& case_point);
	void ApplyChromozome(CChromozome& chromozome);
};

class CDlgSmoothCaseGraph;
/////////////////////////////////////////////////////////////////////////////
// CGenAlg
class CGenAlg
{
friend CDlgSmoothCaseGraph;

public:
	CGenAlg();

private:
	int	m_nEdges; // number of edges
	int	m_nGrid_size;
	int	m_nChromozome_len;
	int	m_nPopulation; // number of chromosomes in population
	int	m_nGenerations; // number of generations
	int m_nIntersections; // number of intersections in best chromosome
	int m_best_chromozome; // index of best chromosome
	DWORD m_best_fitness; // fitness of best chromosome
	int m_prob_mutate_move;
	int m_prob_mutate_swap;
	int m_prob_mutate_smallmove;
	int m_prob_cross;
	int	m_population_orig; // index to population array marking the original population
	int	m_population_new; // index to population array marking the new population
	int	m_weight_intersections;
	int	m_weight_edgelength;
	int	m_weight_objdistance_min;
	int	m_weight_objdistance_max;

	CArray<CEdgeInfo,CEdgeInfo&>		m_edges;
	CArray<CChromozome,CChromozome&>	m_population;

private:
	int  FindCaseIndex(const CTypedPtrArray<CObArray,CPNCase*>& cases,int nCases,const CPNElement* pElement);
	void EvaluatePopulation();
	bool RandomPass(int value);
	CChromozome TournamentSelect();

public:
	void DeleteContents();
	void SetInfo(int grid_size);
	void PreparePopulation();
	int  StepGeneration();
	int  GetBestIntersections()	{ return m_nIntersections; }
	DWORD  GetBestFitness()		{ return m_best_fitness; }
	void Init(const CTypedPtrArray<CObArray,CPNStep*>& steps,int nSteps,const CTypedPtrArray<CObArray,CPNCase*>& cases,int nCases);
	void ApplyBestChromozome(CTypedPtrArray<CObArray,CPNCase*>& cases,int nCases);

	int	GetGridSize()	{ return m_nGrid_size; }
};

#endif
