////////////////////////////////////////////////////////////////
// MSDN Magazine -- August 2004
// If this code works, it was written by Paul DiLascia.
// If not, I don't know who wrote it.
// Compiles with Visual Studio .NET 2003 on Windows XP. Tab size=3.
//
#include "StdAfx.h"
#include "LockBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CLockBar::CLockBar() : m_pBar(NULL), m_bLocked(TRUE)
{
}

CLockBar::~CLockBar()
{
}

void CLockBar::SetLocked(BOOL bLocked)
{
	m_bLocked = bLocked;
/*	CFrameWnd* pFrame = m_pBar->GetParentFrame();
	ASSERT(pFrame);

	m_bLocked = bLocked;
	DWORD dwStyle = m_pBar->GetBarStyle();
	if (bLocked) {
		pFrame->DockControlBar(m_pBar); 	// dock if not already
		dwStyle &= ~CBRS_GRIPPER;			// turn off gripper
	} else {
		dwStyle |= CBRS_GRIPPER;
	}
	m_pBar->SetBarStyle(dwStyle);
	pFrame->RecalcLayout();					// make frame recalc toolbar sizes
	*/
}

//////////////////
// Trap messages sent to control bar.
//
LRESULT CLockBar::WindowProc(UINT msg, WPARAM wp, LPARAM lp)
{
	if ((msg==WM_LBUTTONDOWN || msg==WM_LBUTTONDBLCLK) && m_bLocked) {
		// Got click or double-click and toolbar is locked: if mouse in "dead
		// zone" then ignore the message--don't pass to control bar
		//
		CPoint pt(lp);
		if (m_pBar->OnToolHitTest(pt, NULL) == -1)
			return 0; // return without handling: bypass control bar dragging!
	}
	// pass unhandled messages subclassed window--this is important!
	return CSubclassWnd::WindowProc(msg, wp, lp);
}

