////////////////////////////////////////////////////////////////
// MSDN Magazine -- August 2004
// If this code works, it was written by Paul DiLascia.
// If not, I don't know who wrote it.
// Compiles with Visual Studio .NET 2003 on Windows XP. Tab size=3.
//
#include "Subclass.h"

//////////////////
// Plug-in class to support locking toolbars. To use: instantiate one of
// these for each toolbar you want to be able to lock. From your
// InitInstance call:
//
//		m_lock.Install(&m_wndToolbar);
//
// Then call m_lock.SetLocked(TRUE/FALSE) to lock/unlock the toolbar.
//
class CLockBar : public CSubclassWnd
{
protected:
	CToolBar* m_pBar;		// toolbar I am locking
	BOOL m_bLocked;		// whether locked or not

public:
	CLockBar();
	~CLockBar();

	// Call this to install the lock
	BOOL Install(CToolBar* pBar) {
		ASSERT(pBar && m_pBar==NULL);
		m_pBar = pBar;
		return HookWindow(pBar);
	}

	// Get/set locked state
	BOOL GetLocked() { 
		return m_bLocked;
	}
	void SetLocked(BOOL bLocked);

	// message trap for msgs sent to toolbar
	virtual LRESULT WindowProc(UINT msg, WPARAM wp, LPARAM lp);	
};	
