// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "CESim.h"

#include "MainFrm.h"
#include "CESimDoc.h"
#include "CESimNetDesignView.h"
#include "CESimOccurrenceNetView.h"
#include "CESimCaseGraphView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame
IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_PROPERTIES, OnViewProperties)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PROPERTIES, OnUpdateViewProperties)
	ON_COMMAND(ID_VIEW_OUTPUT, OnViewOutput)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OUTPUT, OnUpdateViewOutput)
	ON_WM_SIZE()
	ON_COMMAND(ID_OUTPUTWINDOW_HIDE, OnOutputwindowHide)
	ON_COMMAND(ID_OUTPUTWINDOW_RESETCONTENT, OnOutputwindowResetcontent)
	ON_UPDATE_COMMAND_UI(ID_OUTPUTWINDOW_RESETCONTENT, OnUpdateOutputwindowResetcontent)
	ON_WM_GETMINMAXINFO()
	ON_COMMAND(ID_VIEW_STATUS_BAR, OnViewStatusBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STATUS_BAR, OnUpdateViewStatusBar)
	ON_COMMAND(ID_VIEW_FULLSCREEN, OnViewFullscreen)
	ON_COMMAND(ID_LEAVE_FULLSCREEN, OnLeaveFullscreen)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FULLSCREEN, OnUpdateViewFullscreen)
	ON_COMMAND(ID_VIEWCASEGRAPH, OnViewcasegraph)
	ON_UPDATE_COMMAND_UI(ID_VIEWCASEGRAPH, OnUpdateViewcasegraph)
	ON_COMMAND(ID_VIEWOCCURRENCENET, OnViewoccurrencenet)
	ON_UPDATE_COMMAND_UI(ID_VIEWOCCURRENCENET, OnUpdateViewoccurrencenet)
	ON_COMMAND(ID_NETDESIGN_SHOWNETDESIGN, OnViewnetdesign)
	ON_UPDATE_COMMAND_UI(ID_NETDESIGN_SHOWNETDESIGN, OnUpdateViewnetdesign)
	ON_UPDATE_COMMAND_UI(ID_VIEWSIMSYSTEM, OnUpdateViewsimsystem)
	ON_UPDATE_COMMAND_UI(ID_CASEGRAPH_EXPORTTOEMF, OnUpdateCasegraphExporttoemf)
	ON_UPDATE_COMMAND_UI(ID_OCCURRENCENET_EXPORTTOEMF, OnUpdateOccurrencenetExporttoemf)
	ON_COMMAND(ID_VIEWSIMSYSTEM, OnViewnetdesign)
	//}}AFX_MSG_MAP
	ON_MESSAGE(APP_MSG_UPDATE_VIEW,OnUpdateView)
	ON_MESSAGE(APP_MSG_SIMULATION_SPEED,OnSimulationSpeed)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_MOUSE_POS,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction
CMainFrame::CMainFrame()
{
	m_output_bar_docked=false;
	m_full_screen=false;
	m_pNetDesignView=NULL;
	m_pCaseGraphView=NULL;
	m_pOccurrenceNetView=NULL;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this, 0, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED) ||
//		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_GRIPPER| CBRS_SIZE_FIXED) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndObjBar.CreateEx(this, 0, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED,CRect(0, 0, 0, 0),IDR_TOOLS) ||
		!m_wndObjBar.LoadToolBar(IDR_TOOLS))
	{
		TRACE0("Failed to create objectbar\n");
		return -1;      // fail to create
	}

	if (!m_wndViewBar.CreateEx(this, 0, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_FIXED,CRect(0, 0, 0, 0),IDR_TOOLS) ||
		!m_wndViewBar.LoadToolBar(IDR_VIEWS))
	{
		TRACE0("Failed to create objectbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	if (!m_wndFSBar.CreateEx(this, 0, WS_CHILD | CBRS_TOP | CBRS_TOOLTIPS
		| CBRS_FLOATING | CBRS_SIZE_FIXED,CRect(0,0,0,0),IDR_FULLSCREEN) ||
		!m_wndFSBar.LoadToolBar(IDR_FULLSCREEN))
	{
		TRACE0("Failed to create fullscreen bar\n");
		return -1;      // fail to create
	}
	m_wndFSBar.SetWindowText("Full Screen");
	m_wndFSBar.EnableDocking(0);

	EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBar.SetWindowText("Standard");
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);
	m_wndToolBarLock.Install(&m_wndToolBar);

	m_wndObjBar.SetWindowText("Tools");
	m_wndObjBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndObjBar.SetButtonStyle(0,TBBS_CHECKBOX);
	m_wndObjBar.SetButtonStyle(1,TBBS_CHECKBOX);
	m_wndObjBar.SetButtonStyle(2,TBBS_CHECKBOX);
	m_wndObjBar.SetButtonStyle(3,TBBS_CHECKBOX);
	m_wndObjBar.SetButtonStyle(4,TBBS_CHECKBOX);
	m_wndObjBar.SetButtonStyle(5,TBBS_CHECKBOX);
	m_wndObjBar.SetButtonStyle(6,TBBS_CHECKBOX);
	DockControlBarLeftOf(&m_wndObjBar,&m_wndToolBar);
	m_wndObjBarLock.Install(&m_wndObjBar);

	m_wndViewBar.SetWindowText("Controls");
	m_wndViewBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndViewBar.SetButtonStyle(3,TBBS_CHECKBOX);
	m_wndViewBar.SetButtonStyle(4,TBBS_CHECKBOX);
	m_wndViewBar.SetButtonStyle(5,TBBS_CHECKBOX);
	DockControlBarLeftOf(&m_wndViewBar,&m_wndObjBar);
	m_wndViewBarLock.Install(&m_wndViewBar);

	if(!m_output_bar.Create(this,IDD_OUTPUT,WS_CHILD|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_FIXED,IDD_OUTPUT))
	{
		TRACE0("Failed to create CDlgOutputBar\n");
	}	
	m_output_bar.SetWindowText("Output");
	m_output_bar.EnableDocking(CBRS_ALIGN_BOTTOM);
	// 
	g_output_tab_sel=0;
	g_output_bar_hwnd=m_output_bar.GetSafeHwnd();
	g_output_list[0]=m_output_bar.GetOutputList(0);
	g_output_list[1]=m_output_bar.GetOutputList(1);
	g_output_list[2]=m_output_bar.GetOutputList(2);
	g_output_list[3]=m_output_bar.GetOutputList(3);
	g_output_list[4]=m_output_bar.GetOutputList(4);

	if(!m_properties_condition_bar.Create(this,IDD_PROPERTIES_CONDITION,CBRS_NOALIGN|WS_CHILD|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_FIXED,IDD_PROPERTIES_CONDITION))
	{
		TRACE0("Failed to create CDlgPropertiesConditionBar\n");
	}	
	m_properties_condition_bar.SetWindowText("Properties - Condition");
	m_properties_condition_bar.EnableDocking(0);

	if(!m_properties_event_bar.Create(this,IDD_PROPERTIES_EVENT,CBRS_NOALIGN|WS_CHILD|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_FIXED,IDD_PROPERTIES_EVENT))
	{
		TRACE0("Failed to create CDlgPropertiesEventBar\n");
	}	
	m_properties_event_bar.SetWindowText("Properties - Event");
	m_properties_event_bar.EnableDocking(0);

	if(!m_properties_polygon_bar.Create(this,IDD_PROPERTIES_POLYGON,CBRS_NOALIGN|WS_CHILD|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_FIXED,IDD_PROPERTIES_POLYGON))
	{
		TRACE0("Failed to create CDlgPropertiesPolygonBar\n");
	}	
	m_properties_polygon_bar.SetWindowText("Properties - Polygon");
	m_properties_polygon_bar.EnableDocking(0);

	if(!m_properties_label_bar.Create(this,IDD_PROPERTIES_LABEL,CBRS_NOALIGN|WS_CHILD|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_FIXED,IDD_PROPERTIES_LABEL))
	{
		TRACE0("Failed to create CDlgPropertiesLabelBar\n");
	}	
	m_properties_label_bar.SetWindowText("Properties - Label");
	m_properties_label_bar.EnableDocking(0);

	if(!m_properties_simulation_bar.Create(this,IDD_PROPERTIES_SIMULATION,CBRS_NOALIGN|WS_CHILD|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_FIXED,IDD_PROPERTIES_SIMULATION))
	{
		TRACE0("Failed to create CDlgPropertiesSimulationBar\n");
	}	
	m_properties_simulation_bar.SetWindowText("Properties - Simulation");
	m_properties_simulation_bar.EnableDocking(0);

	CenterWindow();
	RecalcLayout();

	FloatControlBar(&m_wndFSBar,CPoint(10,10));

	CRect rect; // for right resizing output bar
	m_wndStatusBar.GetClientRect(&rect);
	m_output_bar.SetStatusBarHeight(rect.Height());

	CRect win_rect;
	GetWindowRect(win_rect);
	CRect bar_rect;
	m_wndToolBar.GetWindowRect(bar_rect);
	m_float_position=CPoint(GetSystemMetrics(SM_CXSCREEN)-235-GetSystemMetrics(SM_CXVSCROLL),bar_rect.bottom-win_rect.top);
	m_properties_bar=NULL;

	return 0;
}

void CMainFrame::DockControlBarLeftOf(CToolBar* Bar,CToolBar* LeftOf)
{
	CRect rect;
	DWORD dw;
	UINT n;

	// get MFC to adjust the dimensions of all docked ToolBars
	// so that GetWindowRect will be accurate
	RecalcLayout();
	LeftOf->GetWindowRect(&rect);
	rect.OffsetRect(1,0);
	dw=LeftOf->GetBarStyle();
	n=0;
	n=(dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
	n=(dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
	n=(dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
	n=(dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

	DockControlBar(Bar,n,&rect);
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	AfxGetApp()->m_nCmdShow=SW_MAXIMIZE;

	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics
#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnViewProperties()
{
	if(m_properties_bar!=NULL)
	{
		if(m_properties_bar->IsWindowVisible())
		{	// hide it
			ShowControlBar(m_properties_bar,FALSE,FALSE);
			m_properties_bar->ShowWindow(SW_HIDE);
		}
		else
		{	// show it
			m_properties_bar->ShowWindow(SW_SHOW);
			ShowControlBar(m_properties_bar,TRUE,FALSE);
		}
	}
}

void CMainFrame::OnUpdateViewProperties(CCmdUI* pCmdUI) 
{
	bool check=0;
	if(m_properties_bar!=NULL)check=m_properties_bar->IsWindowVisible()? 1 : 0;
	pCmdUI->SetCheck(check);
}

void CMainFrame::OnViewOutput() 
{
	if(!m_output_bar_docked)DockControlBar(&m_output_bar,AFX_IDW_DOCKBAR_BOTTOM);
	if(m_output_bar.IsWindowVisible() && m_output_bar_docked)
	{	// hide it
		ShowControlBar(&m_output_bar,FALSE,FALSE);
		m_output_bar.ShowWindow(SW_HIDE);
	}
	else
	{	// show it
		m_output_bar.ShowWindow(SW_SHOW);
		ShowControlBar(&m_output_bar,TRUE,FALSE);
		m_output_bar.MoveWindow(0,0,m_output_bar.UpdateSize().cx,m_output_bar.UpdateSize().cy);
	}
	m_output_bar_docked=true;
}

void CMainFrame::OnUpdateViewOutput(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((m_output_bar_docked && m_output_bar.IsWindowVisible())? 1 : 0);
}

void CMainFrame::UpdatePropertiesDlg()
{
	if(m_properties_bar!=NULL)m_properties_bar->Update();
}

void CMainFrame::ShowPropertiesDlg(int dlgtype,CPNElement* pElement)
{
	switch(dlgtype)
	{
	case PROPDLG_POLYGON:
	{	// show polygon properties
		m_properties_polygon_bar.SetNetElement(pElement);
		if(m_properties_bar!=&m_properties_polygon_bar)
		{
			if(m_properties_bar!=NULL)m_float_position=m_properties_bar->GetFloatPosition();
			FloatControlBar(&m_properties_polygon_bar,m_float_position);
			ShowControlBar(&m_properties_polygon_bar,TRUE,FALSE);
			if(m_properties_bar!=NULL)
			{
				m_properties_bar->SetNetElement(NULL);
				ShowControlBar(m_properties_bar,FALSE,FALSE);
			}
			m_properties_bar=&m_properties_polygon_bar;
		}
		break;
	}
	case PROPDLG_LABEL:
	{	// show label properties
		m_properties_label_bar.SetNetElement(pElement);
		if(m_properties_bar!=&m_properties_label_bar)
		{
			if(m_properties_bar!=NULL)m_float_position=m_properties_bar->GetFloatPosition();
			FloatControlBar(&m_properties_label_bar,m_float_position);
			ShowControlBar(&m_properties_label_bar,TRUE,FALSE);
			if(m_properties_bar!=NULL)
			{
				m_properties_bar->SetNetElement(NULL);
				ShowControlBar(m_properties_bar,FALSE,FALSE);
			}
			m_properties_bar=&m_properties_label_bar;
		}
		break;
	}
	case PROPDLG_COND:
	{	// show condition properties
		m_properties_condition_bar.SetNetElement(pElement);
		if(m_properties_bar!=&m_properties_condition_bar)
		{
			if(m_properties_bar!=NULL)m_float_position=m_properties_bar->GetFloatPosition();
			FloatControlBar(&m_properties_condition_bar,m_float_position);
			ShowControlBar(&m_properties_condition_bar,TRUE,FALSE);
			if(m_properties_bar!=NULL)
			{
				m_properties_bar->SetNetElement(NULL);
				ShowControlBar(m_properties_bar,FALSE,FALSE);
			}
			m_properties_bar=&m_properties_condition_bar;
		}
		break;
	}
	case PROPDLG_EVNT:
	{	// show event properties
		m_properties_event_bar.SetNetElement(pElement);
		if(m_properties_bar!=&m_properties_event_bar)
		{
			if(m_properties_bar!=NULL)m_float_position=m_properties_bar->GetFloatPosition();
			FloatControlBar(&m_properties_event_bar,m_float_position);
			ShowControlBar(&m_properties_event_bar,TRUE,FALSE);
			if(m_properties_bar!=NULL)
			{
				m_properties_bar->SetNetElement(NULL);
				ShowControlBar(m_properties_bar,FALSE,FALSE);
			}
			m_properties_bar=&m_properties_event_bar;
		}
		break;
	}
/*	case PROPDLG_DESKTOP:
	{	// show desktop
		m_properties_desktop_bar.SetNetElement(pElement);
		if(m_properties_bar!=&m_properties_desktop_bar)
		{
			FloatControlBar(&m_properties_desktop_bar,m_properties_bar->GetFloatPosition());
			ShowControlBar(&m_properties_desktop_bar,TRUE,FALSE);
			m_properties_bar->SetNetElement(NULL);
			ShowControlBar(m_properties_bar,FALSE,FALSE);
			m_properties_bar=&m_properties_desktop_bar;
		}
		break;
	}*/
	case PROPDLG_SIMULATION:
	{	// show simulation properties
		if((m_pNetDesignView!=NULL) && (GetActiveView()!=m_pNetDesignView))
		{
			ShowPropertiesDlg(PROPDLG_HIDE);
			return;
		}
		m_properties_simulation_bar.SetNetElement(pElement);
		if(m_properties_bar!=&m_properties_simulation_bar)
		{
			if(m_properties_bar!=NULL)m_float_position=m_properties_bar->GetFloatPosition();
			FloatControlBar(&m_properties_simulation_bar,m_float_position);
			ShowControlBar(&m_properties_simulation_bar,TRUE,FALSE);
			if(m_properties_bar!=NULL)
			{
				m_properties_bar->SetNetElement(NULL);
				ShowControlBar(m_properties_bar,FALSE,FALSE);
			}
			m_properties_bar=&m_properties_simulation_bar;
		}
		break;
	}
	case PROPDLG_HIDE:
	{	// hide properties
		if(m_properties_bar!=NULL)
		{
			m_properties_bar->SetNetElement(NULL);
			m_float_position=m_properties_bar->GetFloatPosition();
			ShowControlBar(m_properties_bar,FALSE,FALSE);
			m_properties_bar=NULL;
		}
		break;
	}
	default:
		ASSERT(FALSE);
	break;
	}
}

void CMainFrame::ShowMousePos(CPoint pos)
{	// mouse moved
	CString text;
	text.Format("P %d, %d",pos.x,pos.y);
	m_wndStatusBar.SetPaneText(1,text);
}

LRESULT CMainFrame::OnUpdateView(WPARAM wparam,LPARAM lparam)
{
	GetActiveView()->PostMessage(APP_MSG_UPDATE_VIEW,wparam,lparam);
/*	CCESimNetDesignView* pView=dynamic_cast<CCESimNetDesignView*>(GetActiveView());
	if(pView)pView->UpdateView(wparam);

	CESimCaseGraphView* pView=dynamic_cast<CESimCaseGraphView*>(GetActiveView());
	if(pView)pView->UpdateView(wparam);

	CESimCaseGraphView* pView=dynamic_cast<CESimCaseGraphView*>(GetActiveView());
	if(pView)pView->UpdateView(wparam);*/
	return 0;
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	if(m_output_bar_docked)
	{
		CSize size=m_output_bar.UpdateSize();
		m_output_bar.MoveWindow(0,0,size.cx,size.cy);
	}
}

void CMainFrame::OnOutputwindowHide() 
{
	ShowControlBar(&m_output_bar,FALSE,FALSE);
	m_output_bar.ShowWindow(SW_HIDE);
}

void CMainFrame::OutputwindowResetcontent(int list)
{
	m_output_bar.Resetcontent(list);
}

void CMainFrame::Reset()
{	
	if(m_pNetDesignView!=NULL)
	{
		CView* pActiveView=GetActiveView();
		if(pActiveView!=m_pNetDesignView)OnViewnetdesign();
	}
	if(m_output_bar_docked)
	{
		_OutputSelectList(0);
		// reset all output lists
		m_output_bar.OnOutputwindowResetcontent();
		m_output_bar.Resetcontent(3);
		m_output_bar.Resetcontent(4);
	}
}

void CMainFrame::OnOutputwindowResetcontent() 
{	// reset only actal output list
	m_output_bar.OnOutputwindowResetcontent(false);
}

void CMainFrame::OnUpdateOutputwindowResetcontent(CCmdUI* pCmdUI) 
{
	m_output_bar.OnUpdateOutputwindowResetcontent(pCmdUI);
}

void CMainFrame::ShowOutputBar()
{	// show and prepare output window
	if(!m_output_bar_docked)DockControlBar(&m_output_bar,AFX_IDW_DOCKBAR_BOTTOM);
	m_output_bar_docked=true;
	m_output_bar.OnOutputwindowResetcontent();
	m_output_bar.ShowOutputListBox();
	m_output_bar.ShowWindow(SW_SHOW);
	ShowControlBar(&m_output_bar,TRUE,FALSE);
	m_output_bar.MoveWindow(0,0,m_output_bar.UpdateSize().cx,m_output_bar.UpdateSize().cy);
}

void CMainFrame::HideOutputBar()
{	// hideoutput window
	if(m_output_bar_docked)
	{
		ShowControlBar(&m_output_bar,FALSE,FALSE);
		m_output_bar.ShowWindow(SW_HIDE);
	}
}

LRESULT CMainFrame::OnSimulationSpeed(WPARAM wparam,LPARAM lparam)
{
	::PostMessage(GetActiveView()->GetSafeHwnd(),APP_MSG_SIMULATION_SPEED,wparam,lparam);
	return 0;
}

void CMainFrame::EnableSimulationButtons(bool btn_reset,bool btn_start,bool btn_stop,bool btn_step)
{
	m_properties_simulation_bar.EnableSimulationButtons(btn_reset,btn_start,btn_stop,btn_step);
}

void CMainFrame::OnViewStatusBar() 
{
	if(m_wndStatusBar.IsWindowVisible())
	{	// hide
		m_wndStatusBar.ShowWindow(SW_HIDE);
		m_output_bar.SetStatusBarHeight(0);
	}
	else
	{	// show
		m_wndStatusBar.ShowWindow(SW_SHOW);
		CRect rect;
		m_wndStatusBar.GetClientRect(&rect);
		m_output_bar.SetStatusBarHeight(rect.Height());
	}
	RecalcLayout();
	if(m_output_bar_docked)
	{
		CSize size=m_output_bar.UpdateSize(); // for resizing
		m_output_bar.MoveWindow(0,0,size.cx,size.cy);
	}
}

void CMainFrame::OnUpdateViewStatusBar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_wndStatusBar.IsWindowVisible());
}

void CMainFrame::OnViewFullscreen() 
{
	if(!m_full_screen)
	{
		// need to hide all bars
		m_wndToolBar.ShowWindow(SW_HIDE);
		m_wndObjBar.ShowWindow(SW_HIDE);
		m_wndViewBar.ShowWindow(SW_HIDE);
		m_fs_sb_visible=m_wndStatusBar.ShowWindow(SW_HIDE);

		// save old placement
		GetWindowPlacement(&m_window_placement);
		m_window_placement.length=sizeof WINDOWPLACEMENT;

		CRect desktop_rect;
		::GetWindowRect(::GetDesktopWindow(),&desktop_rect);
		// adjust rect to new size of window
		::AdjustWindowRectEx(&desktop_rect,GetStyle(),TRUE,GetExStyle());
		m_full_screen_rect=desktop_rect;

		ShowControlBar(&m_wndFSBar,TRUE,FALSE);

		// enter full screen
		m_full_screen=true;
	    WINDOWPLACEMENT window_placement;
		window_placement=m_window_placement;
		window_placement.showCmd= SW_SHOWNORMAL;
		window_placement.rcNormalPosition=desktop_rect;
		SetWindowPlacement(&window_placement);

		if(m_output_bar_docked)
		{	// inform output bar about change
			CSize size=m_output_bar.UpdateSize(); // for resizing
			m_output_bar.MoveWindow(0,0,size.cx,size.cy);
			m_output_bar.SetStatusBarHeight(0);
		}
	}
}

void CMainFrame::OnLeaveFullscreen() 
{
	if(m_full_screen)
	{
		m_full_screen=false;
		m_wndToolBar.ShowWindow(SW_SHOW);
		m_wndViewBar.ShowWindow(SW_SHOW);
		m_wndObjBar.ShowWindow(SW_SHOW);
		if(m_fs_sb_visible)m_wndStatusBar.ShowWindow(SW_SHOW);
		ShowControlBar(&m_wndFSBar,FALSE,FALSE);

		SetWindowPlacement(&m_window_placement);

		if(m_output_bar_docked)
		{	// inform output bar about change
			CRect rect;
			m_wndStatusBar.GetClientRect(&rect);
			m_output_bar.SetStatusBarHeight(rect.Height());
		}
	}
}

void CMainFrame::OnUpdateViewFullscreen(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_full_screen);
}

void CMainFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
	if(m_full_screen)
	{
		lpMMI->ptMaxSize.y=m_full_screen_rect.Height();
		lpMMI->ptMaxTrackSize.y=lpMMI->ptMaxSize.y;
		lpMMI->ptMaxSize.x=m_full_screen_rect.Width();
		lpMMI->ptMaxTrackSize.x=lpMMI->ptMaxSize.x;
	}
}

bool CMainFrame::IsViewActive(int nView)
{
	switch(nView)
	{
	case VIEW_NETDESIGN:
		return ((m_pNetDesignView==NULL) || (GetActiveView()==m_pNetDesignView));
	case VIEW_CASEGRAPH:
		return (GetActiveView()==m_pCaseGraphView);
	case VIEW_OCCURENCEGRAPH:
		return (GetActiveView()==m_pOccurrenceNetView);
	default:
		ASSERT(FALSE);
	}
	return false;
}

void CMainFrame::SwitchToView(int nView)
{
	bool create=false;
	CView* pSwitchToView=NULL;
	CView* pActiveView=GetActiveView();
	if(m_pNetDesignView==NULL)m_pNetDesignView=pActiveView; // inicialization
	switch(nView)
	{
	case VIEW_NETDESIGN:
		pSwitchToView=m_pNetDesignView;
		break;
	case VIEW_CASEGRAPH:
		if(m_pCaseGraphView==NULL)
		{
			create=true;
			m_pCaseGraphView=(CView*) new CCESimCaseGraphView;
		}
		pSwitchToView=m_pCaseGraphView;
		break;
	case VIEW_OCCURENCEGRAPH:
		if(m_pOccurrenceNetView==NULL)
		{
			create=true;
			m_pOccurrenceNetView=(CView*) new CCESimOccurrenceNetView;
		}
		pSwitchToView=m_pOccurrenceNetView;
		break;
	default:
		ASSERT(FALSE);
		break;
	}
	if(create)
	{
		CCreateContext context;
		context.m_pCurrentDoc=pActiveView->GetDocument();
		pSwitchToView->Create(NULL,NULL,WS_BORDER,CFrameWnd::rectDefault,this,nView,&context);
		pSwitchToView->OnInitialUpdate();
	}
	SetActiveView(pSwitchToView);
	pSwitchToView->ShowWindow(SW_SHOW);
	pActiveView->ShowWindow(SW_HIDE);
	pActiveView->SetDlgCtrlID(1);
	pSwitchToView->SetDlgCtrlID(AFX_IDW_PANE_FIRST);
//	pSwitchToView->PostMessage();
	RecalcLayout();
	if(m_output_bar_docked)
	{
		CSize size=m_output_bar.UpdateSize(); // for resizing
		m_output_bar.MoveWindow(0,0,size.cx,size.cy);
	}
}

void CMainFrame::OnViewcasegraph() 
{
	if(!IsViewActive(VIEW_CASEGRAPH))
	{
		GetActiveView()->SendMessage(WM_COMMAND,IDC_BTN_SIM_STOP,NULL);
		SwitchToView(VIEW_CASEGRAPH);
		((CCESimCaseGraphView*)m_pCaseGraphView)->SwitchedTo();
	}
}

void CMainFrame::OnUpdateViewcasegraph(CCmdUI* pCmdUI) 
{
//	bool enable;
//	enable=((CCESimDoc*)GetActiveView()->GetDocument())->CaseGraph_CanShow();
//	pCmdUI->Enable(enable && (GetActiveView()!=m_pCaseGraphView));
	pCmdUI->Enable(((CCESimDoc*)GetActiveView()->GetDocument())->CaseGraph_CanShow());
	pCmdUI->SetCheck(IsViewActive(VIEW_CASEGRAPH) ? 1 : 0);
}

void CMainFrame::OnViewoccurrencenet() 
{
	if(!IsViewActive(VIEW_OCCURENCEGRAPH))
	{
		GetActiveView()->SendMessage(WM_COMMAND,IDC_BTN_SIM_STOP,NULL);
		SwitchToView(VIEW_OCCURENCEGRAPH);
		((CCESimOccurrenceNetView*)m_pOccurrenceNetView)->SwitchedTo();
	}
}

void CMainFrame::OnUpdateViewoccurrencenet(CCmdUI* pCmdUI) 
{
//	bool enable;
//	enable=((CCESimDoc*)GetActiveView()->GetDocument())->OccurrenceNet_CanShow();
//	pCmdUI->Enable(enable && (GetActiveView()!=m_pOccurrenceNetView));
	pCmdUI->Enable(((CCESimDoc*)GetActiveView()->GetDocument())->OccurrenceNet_CanShow());
	pCmdUI->SetCheck(IsViewActive(VIEW_OCCURENCEGRAPH) ? 1 : 0);
}

void CMainFrame::OnViewnetdesign() 
{
	if(!IsViewActive(VIEW_NETDESIGN))
	{
		SwitchToView(VIEW_NETDESIGN);
		((CCESimNetDesignView*)m_pNetDesignView)->SwitchedTo();
	}
}

void CMainFrame::OnUpdateViewnetdesign(CCmdUI* pCmdUI) 
{
//	bool enable=false;
//	enable=GetActiveView()!=m_pNetDesignView;
//	if(m_pNetDesignView==NULL)enable=false;
//	pCmdUI->Enable(enable);
	pCmdUI->Enable(true);
	pCmdUI->SetCheck(IsViewActive(VIEW_NETDESIGN) ? 1 : 0);
}

void CMainFrame::OnUpdateViewsimsystem(CCmdUI* pCmdUI) 
{
//	bool enable;
//	enable=((CCESimDoc*)GetActiveView()->GetDocument())->IsSimulationMode();
//	if(m_pNetDesignView==NULL)enable=false;
//	pCmdUI->Enable(enable && (GetActiveView()!=m_pNetDesignView));
	pCmdUI->Enable(((CCESimDoc*)GetActiveView()->GetDocument())->IsSimulationMode());
	pCmdUI->SetCheck(IsViewActive(VIEW_NETDESIGN) ? 1 : 0);
}

void CMainFrame::OnUpdateCasegraphExporttoemf(CCmdUI* pCmdUI) 
{
	bool enable;
	enable=((CCESimDoc*)GetActiveView()->GetDocument())->CaseGraph_CanShow();
	if(GetActiveView()!=m_pCaseGraphView)enable=false;
	pCmdUI->Enable(enable);
}

void CMainFrame::OnUpdateOccurrencenetExporttoemf(CCmdUI* pCmdUI) 
{
	bool enable;
	enable=((CCESimDoc*)GetActiveView()->GetDocument())->OccurrenceNet_CanShow();
	if(GetActiveView()!=m_pOccurrenceNetView)enable=false;
	pCmdUI->Enable(enable);
}
