// MainFrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////
#if !defined(AFX_MAINFRM_H__C365CA6A_AB6C_48CE_84B6_1CC42DCFA272__INCLUDED_)
#define AFX_MAINFRM_H__C365CA6A_AB6C_48CE_84B6_1CC42DCFA272__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "LockBar.h"
#include "DlgOutputBar.h"
#include "DlgPropertiesConditionBar.h"
#include "DlgPropertiesEventBar.h"
#include "DlgPropertiesLabelBar.h"
#include "DlgPropertiesPolygonBar.h"
#include "DlgPropertiesSimulationBar.h"

class CMainFrame : public CFrameWnd
{
protected: // create from serialization only
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

public:
	enum { PROPDLG_POLYGON, PROPDLG_LABEL, PROPDLG_COND, PROPDLG_EVNT, PROPDLG_HIDE, PROPDLG_SIMULATION };

private:
	enum { VIEW_NETDESIGN, VIEW_CASEGRAPH, VIEW_OCCURENCEGRAPH };

	CDlgPropertiesConditionBar	m_properties_condition_bar;
	CDlgPropertiesEventBar		m_properties_event_bar;
	CDlgPropertiesPolygonBar	m_properties_polygon_bar;
	CDlgPropertiesLabelBar		m_properties_label_bar;
	CDlgPropertiesSimulationBar	m_properties_simulation_bar;
	CDlgPropertiesBar*			m_properties_bar; // actually visible property dialog bar
	CDlgOutputBar				m_output_bar;
	CView* m_pNetDesignView;
	CView* m_pCaseGraphView;
	CView* m_pOccurrenceNetView;
	CPoint m_float_position;

	bool	m_output_bar_docked;
	bool	m_full_screen;
	CRect	m_full_screen_rect;
	BOOL	m_fs_sb_visible; // state of status bar when entering full screen
    WINDOWPLACEMENT m_window_placement;

private:
	void SwitchToView(int nView);
	bool IsViewActive(int nView);

public:
	void ShowPropertiesDlg(int dlgtype,CPNElement* pElement=NULL);
	void UpdatePropertiesDlg();
	void ShowMousePos(CPoint pos);
	void ShowOutputBar();
	void HideOutputBar();
	void EnableSimulationButtons(bool btn_reset,bool btn_start,bool btn_stop,bool btn_step);
	void Reset();
	void OutputwindowResetcontent(int list);

public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;
	CToolBar    m_wndObjBar;
	CToolBar    m_wndViewBar;
	CToolBar    m_wndFSBar;

	// toolbar lock
	CLockBar	m_wndToolBarLock;
	CLockBar	m_wndObjBarLock;
	CLockBar	m_wndViewBarLock;

protected:
	void DockControlBarLeftOf(CToolBar* Bar,CToolBar* LeftOf);

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnViewProperties();
	afx_msg void OnUpdateViewProperties(CCmdUI* pCmdUI);
	afx_msg void OnViewOutput();
	afx_msg void OnUpdateViewOutput(CCmdUI* pCmdUI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnOutputwindowHide();
	afx_msg void OnOutputwindowResetcontent();
	afx_msg void OnUpdateOutputwindowResetcontent(CCmdUI* pCmdUI);
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnViewStatusBar();
	afx_msg void OnUpdateViewStatusBar(CCmdUI* pCmdUI);
	afx_msg void OnViewFullscreen();
	afx_msg void OnLeaveFullscreen();
	afx_msg void OnUpdateViewFullscreen(CCmdUI* pCmdUI);
	afx_msg void OnViewcasegraph();
	afx_msg void OnUpdateViewcasegraph(CCmdUI* pCmdUI);
	afx_msg void OnViewoccurrencenet();
	afx_msg void OnUpdateViewoccurrencenet(CCmdUI* pCmdUI);
	afx_msg void OnViewnetdesign();
	afx_msg void OnUpdateViewnetdesign(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewsimsystem(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCasegraphExporttoemf(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOccurrencenetExporttoemf(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg LRESULT OnUpdateView(WPARAM wparam,LPARAM lparam);
	afx_msg LRESULT OnSimulationSpeed(WPARAM wparam,LPARAM lparam);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINFRM_H__C365CA6A_AB6C_48CE_84B6_1CC42DCFA272__INCLUDED_)
