
// OccurenceNet.cpp - implementation for COccurrenceNet
//

#include "stdafx.h"
#include "OccurrenceNet.h"
#include "CESim.h"
#include "MainFrm.h"

////////////////////////////////////////////////////////////////////////////
// COccurrenceNet
IMPLEMENT_SERIAL(COccurrenceNet,CObject,1|VERSIONABLE_SCHEMA)

COccurrenceNet::COccurrenceNet()
{
	m_legend_correspond=false;
	m_last_element_pos=NULL;
	m_column=0;
	m_row_max=0;
	m_type_place=true;
	m_window_size.cx=100;
	m_window_size.cy=100;
}

void COccurrenceNet::Serialize(CArchive& ar)
{	// save and load
	ASSERT_VALID(this);

	CObject::Serialize(ar);
	if(ar.IsStoring())
	{
		ar << m_column;
		ar << m_row_max;
		ar << m_window_size;
	}
	else
	{
		ar >> m_column;
		ar >> m_row_max;
		ar >> m_window_size;
	}
	m_element_list.Serialize(ar);
	m_user_element_list.Serialize(ar);
}

void COccurrenceNet::SetWindowSize(CSize window_size)
{
	CSize min_window_size;
	// compute minimal window size
	CRect window_rect,tmp_rect;
	window_rect.SetRectEmpty();
	tmp_rect.SetRectEmpty();
	CPNElement* pElement;
	POSITION pos=m_user_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_user_element_list.GetNext(pos);
		window_rect.UnionRect(tmp_rect,pElement->GetRect());
		tmp_rect=window_rect;
	}
	min_window_size.cx=window_rect.right;
	min_window_size.cy=window_rect.bottom;
	if(min_window_size.cx<100)min_window_size.cx=100;
	if(min_window_size.cy<100)min_window_size.cy=100;
	if(min_window_size.cx<NET_ORG_X+NET_SPACE_X*(m_column+1))min_window_size.cx=NET_ORG_X+NET_SPACE_X*(m_column+1);
	if(min_window_size.cy<NET_ORG_Y+NET_SPACE_Y*(m_row_max+1))min_window_size.cy=NET_ORG_Y+NET_SPACE_Y*(m_row_max+1);
	// set window size
	if(window_size.cx<min_window_size.cx)window_size.cx=min_window_size.cx;
	if(window_size.cy<min_window_size.cy)window_size.cy=min_window_size.cy;
	m_window_size=window_size;
}

void COccurrenceNet::DeleteContents()
{
	m_window_size.cx=100;
	m_window_size.cy=100;
	m_column=0;
	m_row_max=0;
	m_type_place=true;
	m_last_element_pos=NULL;
	POSITION pos;
	pos=m_element_list.GetHeadPosition();
	while(pos!=NULL)delete m_element_list.GetNext(pos);
	m_element_list.RemoveAll();
	pos=m_user_element_list.GetHeadPosition();
	while(pos!=NULL)delete m_user_element_list.GetNext(pos);
	m_user_element_list.RemoveAll();
}

void COccurrenceNet::Init(CPNElementList& element_list)
{	// initialize maps for net elements names
	int nEvents=1;
	int nConditions=1;
	CPNEvent* pEvent;
	CPNElement* pElement;
	CPNCondition* pCondition;
	m_map_places.RemoveAll();
	m_map_occurrences.RemoveAll();
	POSITION pos=element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=element_list.GetNext(pos);
		pEvent=dynamic_cast<CPNEvent*>(pElement);
		if(pEvent)
		{
			m_map_occurrences.SetAt(pEvent,nEvents);
			nEvents++;
			continue;
		}
		pCondition=dynamic_cast<CPNCondition*>(pElement);
		if(pCondition)
		{
			m_map_places.SetAt(pCondition,nConditions);
			nConditions++;
		}
	}
}

void COccurrenceNet::Draw(CDC* pDC)
{
	CPNElement* pElement;
	POSITION pos=m_user_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_user_element_list.GetNext(pos);
		pElement->Draw(pDC);
	}
	pos=m_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetNext(pos);
		pElement->Draw(pDC);
	}
}

void COccurrenceNet::AddInitialCase(CSetConditions& case_set)
{
	AddCase(case_set);
	m_last_element_pos=m_element_list.GetHeadPosition();
}

void COccurrenceNet::AddCase(CSetConditions& case_set)
{
	CPNPlace* pPlace;
	CPNCondition* pCondition;
	case_set.InitIteration();
	pCondition=case_set.NextIteration();
	while(pCondition!=NULL)
	{
		if(FindPlace(pCondition)==NULL)
		{
			pPlace=new CPNPlace(pCondition);
			m_element_list.AddTail(pPlace);
		}
		pCondition=case_set.NextIteration();
	}
	m_legend_correspond=false;
}

void COccurrenceNet::AddStep(CPNElementList& step_list,CSetConditions& act_case)
{
	CPNEdge* pEdge;
	CPNEvent* pEvent;
	CPNElement* pElement;
	CPNPlace* pFromPlace;
	CPNOccurrence* pOccurrence;
	CSetConditions case_set;
	CPNCondition* pCondition;
	POSITION pos=step_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=step_list.GetNext(pos);
		pEvent=dynamic_cast<CPNEvent*>(pElement);
		// insert new reflection event
		pOccurrence=new CPNOccurrence(pEvent);
		m_element_list.AddTail(pOccurrence);
		// add edges from preset
		case_set=pEvent->GetPreSet();
		case_set.InitIteration();
		pCondition=case_set.NextIteration();
		while(pCondition!=NULL)
		{
			pFromPlace=FindPlace(pCondition);
			pFromPlace->SetOccurrenced();
			pOccurrence->AddConnectionTo();
			pEdge=new CPNEdge(pFromPlace,pOccurrence,true);
			m_element_list.AddTail(pEdge);
			pCondition=case_set.NextIteration();
		}
	}
	AddCase(act_case);
	CPNPlace* pToPlace;
	pos=step_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=step_list.GetNext(pos);
		pEvent=dynamic_cast<CPNEvent*>(pElement);
		pOccurrence=FindOccurrence(pEvent);
		// add edges from postset
		case_set=pEvent->GetPostSet();
		case_set.InitIteration();
		pCondition=case_set.NextIteration();
		while(pCondition!=NULL)
		{
			pToPlace=FindPlace(pCondition);
			pOccurrence->AddConnectionFrom();
			pEdge=new CPNEdge(pOccurrence,pToPlace,true);
			m_element_list.AddTail(pEdge);
			pCondition=case_set.NextIteration();
		}
	}
	m_legend_correspond=false;
}

CPNPlace* COccurrenceNet::FindPlace(CPNCondition* pCondition)
{	// finds reflection place of pCondition
	CPNPlace* pPlace;
	CPNElement* pElement;
	POSITION pos=m_element_list.GetTailPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetPrev(pos);
		pPlace=dynamic_cast<CPNPlace*>(pElement);
		if(pPlace)
		{
			if(pPlace->IsReflection(pCondition))return pPlace;
		}
	}
	return NULL;
}

CPNOccurrence* COccurrenceNet::FindOccurrence(CPNEvent* pEvent)
{	// finds reflection place of pEvent
	CPNElement* pElement;
	CPNOccurrence* pOccurence;
	POSITION pos=m_element_list.GetTailPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetPrev(pos);
		pOccurence=dynamic_cast<CPNOccurrence*>(pElement);
		if(pOccurence)
		{
			if(pOccurence->IsReflection(pEvent))return pOccurence;
		}
	}
	return NULL;
}

CString COccurrenceNet::GetPlaceName(CPNCondition* pCondition)
{
	CString str;
	WORD condition;
	m_map_places.Lookup(pCondition,condition);
	str.Format("b%d",condition);
	return str;
}

CString COccurrenceNet::GetOccurrenceName(CPNEvent* pEvent)
{
	CString str;
	WORD event;
	m_map_occurrences.Lookup(pEvent,event);
	str.Format("e%d",event);
	return str;
}

CSize COccurrenceNet::PlaceElements(CDC* pDC)
{
	CPNEdge* pEdge;
	CPNElement* pTo;
	CPNPlace* pPlace;
	CPNElement* pFrom;
	CPNElement* pElement;
	CPNOccurrence* pOccurrence;
	int	row=0;
	CPoint point;
	POSITION last_element_pos=m_last_element_pos;
	POSITION pos=m_last_element_pos;
	while(pos!=NULL)
	{
		m_last_element_pos=pos;
		pElement=m_element_list.GetNext(pos);
		pOccurrence=dynamic_cast<CPNOccurrence*>(pElement);
		if(pOccurrence)
		{
			if(m_type_place)
			{
				m_type_place=false;
				m_column++;
				row=0;
			}
			point.x=NET_ORG_X+NET_SPACE_X*m_column;
			point.y=NET_ORG_Y+NET_SPACE_Y*row;
			pOccurrence->MoveTo(point);
			pOccurrence->SetText(GetOccurrenceName(pOccurrence->GetReflectionEvent()),pDC);
			row++;
			if(row>m_row_max)m_row_max=row;
			continue;
		}
		pPlace=dynamic_cast<CPNPlace*>(pElement);
		if(pPlace)
		{
			if(!m_type_place)
			{
				m_type_place=true;
				m_column++;
				row=0;
			}
			point.x=NET_ORG_X+NET_SPACE_X*m_column;
			point.y=NET_ORG_Y+NET_SPACE_Y*row;
			pPlace->MoveTo(point);
			pPlace->SetText(GetPlaceName(pPlace->GetReflectionCondition()),pDC);
			row++;
			if(row>m_row_max)m_row_max=row;
		}
		pEdge=dynamic_cast<CPNEdge*>(pElement);
		if(pEdge)
		{
			bool move=true;
			pTo=pEdge->GetTo();
			pFrom=pEdge->GetFrom();
			pOccurrence=dynamic_cast<CPNOccurrence*>(pTo);
			if(pOccurrence) // pokud hrana smeruje na udalost s vice hranami, nebude se zarovnavat
				move=!pOccurrence->IsMultiConnectionTo();
			pOccurrence=dynamic_cast<CPNOccurrence*>(pFrom);
			if(pOccurrence) // 
				move=!pOccurrence->IsMultiConnectionFrom();
			if(move)
			{	// 
				CPoint from=pFrom->GetPosition();
				CPoint to=pTo->GetPosition();
				if(from.y!=to.y)
				{	// objekty se zarovnaji aby byly na stejne urovni
					from.x=to.x;
					CPNElement* pAux;
					pAux=ElementAt(from);
					if(pAux!=NULL)pAux->MoveTo(to);
					pTo->MoveTo(from);
				}
			}
//			pEdge->FirstRecalculate();
		}
	}
	pos=last_element_pos;
	while(pos!=NULL)
	{
		pElement=m_element_list.GetNext(pos);
		pEdge=dynamic_cast<CPNEdge*>(pElement);
		if(pEdge)pEdge->FirstRecalculate();
	}
	m_window_size.cx=NET_ORG_X+NET_SPACE_X*(m_column+1);
	m_window_size.cy=NET_ORG_Y+NET_SPACE_Y*(m_row_max+1);
	return m_window_size;
}

void COccurrenceNet::AddElement(CPNElement* pElement)
{
	m_user_element_list.AddTail(pElement);
}

CPNElement* COccurrenceNet::ElementAt(const CPoint& point)
{
	// return bottom element on point
	CPNElement* pElement;
	POSITION pos=m_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetNext(pos);
		if(pElement->HitTest(point))return pElement;
	}
	// return top element on point
	pos=m_user_element_list.GetTailPosition();
	while(pos!=NULL)
	{
		pElement=m_user_element_list.GetPrev(pos);
		if(pElement->HitTest(point))return pElement;
	}
	return NULL;
}

CRect COccurrenceNet::RecalculateEdges(const CPNElement* pDragged_element/*=NULL*/)
{	// recalculate intersections with elements and edges
	CPNEdge* pEdge;
	CPNElement* pElement;
	CRect invalid_rect,edge_rect;
	invalid_rect.SetRectEmpty();
	CRect tmp_rect,oldrect;
	tmp_rect.SetRectEmpty();
	POSITION pos=m_element_list.GetTailPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetPrev(pos);
		pEdge=dynamic_cast<CPNEdge*>(pElement);
		if(pEdge)
		{
			edge_rect=pEdge->GetRect();
			if(pEdge->Recalculate(pDragged_element))
			{
				invalid_rect.UnionRect(tmp_rect,edge_rect);
				tmp_rect=invalid_rect;
				invalid_rect.UnionRect(tmp_rect,pEdge->GetRect());
				tmp_rect=invalid_rect;
			}
		}
	}
	return invalid_rect;
}

void COccurrenceNet::WriteOutLegend(CPNElementList& element_list)
{
/*	if(m_legend_correspond)return;
	m_legend_correspond=true;
	CString out_str;
	CPNPlace* pPlace;
	CPNElement* pElement;
	CPNOccurrence* pOccurrence;
	ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->OutputwindowResetcontent(OUTPUT_OCCURRENCENET);
	_AddOutputListString(OUTPUT_OCCURRENCENET,"Names of places...");
	POSITION pos=m_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetNext(pos);
		pPlace=dynamic_cast<CPNPlace*>(pElement);
		if(pPlace)
		{
			out_str=pPlace->GetText();
			out_str+=": ";
			out_str+=pPlace->GetConditionName();
			_AddOutputListString(OUTPUT_OCCURRENCENET,out_str);
		}
	}
	_AddOutputListString(OUTPUT_OCCURRENCENET,"");
	_AddOutputListString(OUTPUT_OCCURRENCENET,"Names of occurrences...");
	pos=m_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetNext(pos);
		pOccurrence=dynamic_cast<CPNOccurrence*>(pElement);
		if(pOccurrence)
		{
			out_str=pOccurrence->GetText();
			out_str+=": ";
			out_str+=pOccurrence->GetEventName();
			_AddOutputListString(OUTPUT_OCCURRENCENET,out_str);
		}
	}*/
	if(m_legend_correspond)return;
	m_legend_correspond=true;
	CString out_str;
	CPNLabel* pLabel;
	CPNEvent* pEvent;
	int nConditions=1;
	CPNElement* pElement;
	CPNCondition* pCondition;
	ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->OutputwindowResetcontent(OUTPUT_OCCURRENCENET);
	_AddOutputListString(OUTPUT_OCCURRENCENET,"Names of places...");
	POSITION pos=element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=element_list.GetNext(pos);
		pCondition=dynamic_cast<CPNCondition*>(pElement);
		if(pCondition)
		{
			pLabel=pCondition->GetLabel();
			if(pLabel)
			{
				out_str.Format("b%d: ",nConditions);
				out_str+=pLabel->GetText();
				_AddOutputListString(OUTPUT_OCCURRENCENET,out_str);
				nConditions++;
			}
		}
	}
	_AddOutputListString(OUTPUT_OCCURRENCENET,"");
	_AddOutputListString(OUTPUT_OCCURRENCENET,"Names of occurrences...");
	int nEvents=1;
	pos=element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=element_list.GetNext(pos);
		pEvent=dynamic_cast<CPNEvent*>(pElement);
		if(pEvent)
		{
			pLabel=pEvent->GetLabel();
			if(pLabel)
			{
				out_str.Format("e%d: ",nEvents);
				out_str+=pLabel->GetText();
				_AddOutputListString(OUTPUT_OCCURRENCENET,out_str);
				nEvents++;
			}
		}
	}
}

void COccurrenceNet::ExportToXml(CString& filename)
{
	CStdioFile file;
	if(file.Open(filename,CFile::modeCreate|CFile::modeWrite|CFile::typeText))	
	{
		POSITION pos;
		CPNEdge* pEdge;
		CPNPlace* pPlace;
		CPNElement* pElement;
		CPNOccurrence* pOccurrence;
		file.WriteString("<?xml version=\"1.0\" encoding=\"windows-1250\"?>\n");
		file.WriteString("<occurrencenet>\n");
		pos=m_element_list.GetHeadPosition();
		while(pos!=NULL)
		{
			pElement=m_element_list.GetNext(pos);
			pPlace=dynamic_cast<CPNPlace*>(pElement);
			if(pPlace)
			{
				file.WriteString("  <place name=\"");
				file.WriteString(pPlace->GetText());
				file.WriteString("\">");
				file.WriteString(pPlace->GetConditionName());
				file.WriteString("</place>\n");
			}
		}
		pos=m_element_list.GetHeadPosition();
		while(pos!=NULL)
		{
			pElement=m_element_list.GetNext(pos);
			pOccurrence=dynamic_cast<CPNOccurrence*>(pElement);
			if(pOccurrence)
			{
				file.WriteString("  <occurrence name=\"");
				file.WriteString(pOccurrence->GetText());
				file.WriteString("\">");
				file.WriteString(pOccurrence->GetEventName());
				file.WriteString("</occurrence>\n");
			}
		}
		CString label;
		pos=m_element_list.GetHeadPosition();
		while(pos!=NULL)
		{
			pElement=m_element_list.GetNext(pos);
			pEdge=dynamic_cast<CPNEdge*>(pElement);
			if(pEdge)
			{
				file.WriteString("  <edge>\n");
				file.WriteString("    <from>");
				file.WriteString(GetSafeLabel(pEdge->GetFrom()));
				file.WriteString("</from>\n");
				file.WriteString("    <to>");
				file.WriteString(GetSafeLabel(pEdge->GetTo()));
				file.WriteString("</to>\n");
				file.WriteString("  </edge>\n");
			}
		}
		file.WriteString("</occurrencenet>\n");
		file.Close();
	}
}

CRect COccurrenceNet::SelectElements(CRect& rect,CPNElementList& selected_elements)
{	// select elements with in rect
	CRect invalid_rect;
	CRect tmp_rect;
	tmp_rect.SetRectEmpty();
	CRect rect_element;
	CPNElement* pElement;
	POSITION pos=m_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_element_list.GetNext(pos);
		rect_element=pElement->GetRect();
		if( (rect_element.left>rect.left) && (rect_element.top>rect.top) &&
			(rect_element.right<rect.right) && (rect_element.bottom<rect.bottom))
		{
			pElement->Select();
			selected_elements.AddTail(pElement);
			invalid_rect.UnionRect(tmp_rect,rect_element);
			tmp_rect=invalid_rect;
		}
	}
	pos=m_user_element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=m_user_element_list.GetNext(pos);
		rect_element=pElement->GetRect();
		if( (rect_element.left>rect.left) && (rect_element.top>rect.top) &&
			(rect_element.right<rect.right) && (rect_element.bottom<rect.bottom))
		{
			pElement->Select();
			selected_elements.AddTail(pElement);
			invalid_rect.UnionRect(tmp_rect,rect_element);
			tmp_rect=invalid_rect;
		}
	}
	return invalid_rect;
}

CRect COccurrenceNet::PlaceSelectedElements(bool place_back,CPNElementList& selected_elements)
{	// place elements to back or front of all selected elements
	CRect invalid_rect,tmp_rect;
	tmp_rect.SetRectEmpty();
	invalid_rect.SetRectEmpty();
	POSITION sel_pos=selected_elements.GetHeadPosition();
	CPNElement* pElement;
	while(sel_pos!=NULL)
	{
		pElement=selected_elements.GetNext(sel_pos);
		// 
		POSITION el_pos=m_user_element_list.Find(pElement);
		if(el_pos!=NULL)
		{
			m_user_element_list.RemoveAt(el_pos);
			if(place_back)
				m_user_element_list.AddHead(pElement);
			else
				m_user_element_list.AddTail(pElement);
		}
		invalid_rect.UnionRect(tmp_rect,pElement->GetRect());
		tmp_rect=invalid_rect;
	}
	return invalid_rect;
}

void COccurrenceNet::PrintLegend(CDC* pDC,int textheight,CPNElementList& element_list)
{
	CString out_str;
	CPNLabel* pLabel;
	CPNEvent* pEvent;
	int nConditions=1;
	CPNElement* pElement;
	CPNCondition* pCondition;
	CPoint point(720,-740);
	pDC->TextOut(point.x,point.y,"Names of conditions:");
	point.y-=textheight;
	POSITION pos=element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=element_list.GetNext(pos);
		pCondition=dynamic_cast<CPNCondition*>(pElement);
		if(pCondition)
		{
			pLabel=pCondition->GetLabel();
			if(pLabel)
			{
				out_str.Format("b%d: ",nConditions);
				out_str+=pLabel->GetText();
				pDC->TextOut(point.x,point.y,out_str);
				point.y-=textheight;
				nConditions++;
			}
		}
	}
	point.y-=textheight;
	pDC->TextOut(point.x,point.y,"Names of events:");
	point.y-=textheight;
	int nEvents=1;
	pos=element_list.GetHeadPosition();
	while(pos!=NULL)
	{
		pElement=element_list.GetNext(pos);
		pEvent=dynamic_cast<CPNEvent*>(pElement);
		if(pEvent)
		{
			pLabel=pEvent->GetLabel();
			if(pLabel)
			{
				out_str.Format("b%d: ",nEvents);
				out_str+=pLabel->GetText();
				pDC->TextOut(point.x,point.y,out_str);
				point.y-=textheight;
				nEvents++;
			}
		}
	}
}

CString COccurrenceNet::GetSafeLabel(CPNElement* pElement)
{

	//PREDELAT

	CPNPlace* pPlace;
	CPNOccurrence* pOccurrence;
	pOccurrence=dynamic_cast<CPNOccurrence*>(pElement);
	if(pOccurrence)return pOccurrence->GetText();
	pPlace=dynamic_cast<CPNPlace*>(pElement);
	if(pPlace)return pPlace->GetText();
	return "";
}
