// OccurrenceNet.h - interface for COccurrenceNet
//

#ifndef __OCCURRENCENET_H__
#define __OCCURRENCENET_H__

#include "CEPNobj.h"

/////////////////////////////////////////////////////////////////////////////
// COccurrenceNet
class COccurrenceNet : public CObject
{
friend class CCESimDoc;

public:
	COccurrenceNet();
	virtual void Serialize(CArchive& ar);

	DECLARE_SERIAL(COccurrenceNet);

private:
	enum { NET_ORG_X=80, NET_ORG_Y=80, NET_SPACE_X=50, NET_SPACE_Y=50 };

	int			m_column;
	int			m_row_max;
	bool		m_type_place;
	bool		m_legend_correspond;
	POSITION	m_last_element_pos;

	CSize			m_window_size;
	CMapPtrToWord	m_map_places;
	CMapPtrToWord	m_map_occurrences;
	CTypedPtrList<CObList,CPNElement*>	m_element_list; // occurrence net elements
	CTypedPtrList<CObList,CPNElement*>	m_user_element_list; // user added elements

private:
	CPNPlace*		FindPlace(CPNCondition* pCondition);
	CPNOccurrence*	FindOccurrence(CPNEvent* pEvent);
	void			AddCase(CSetConditions& case_set);
	CString			GetPlaceName(CPNCondition* pCondition);
	CString			GetOccurrenceName(CPNEvent* pEvent);
	CString			GetSafeLabel(CPNElement* pElement);

public:
	void Draw(CDC* pDC);
	void PrintLegend(CDC* pDC,int textheight,CPNElementList& element_list);
	void DeleteContents();
	void Init(CPNElementList& element_list);
	void SetWindowSize(CSize window_size);
	CSize GetWindowSize()							{ return m_window_size; }
	void AddInitialCase(CSetConditions& case_set);
	void AddStep(CPNElementList& step_list,CSetConditions& act_case);
	void AddElement(CPNElement* pElement);
	void WriteOutLegend(CPNElementList& element_list);
	void ExportToXml(CString& filename);
	CPNElement* ElementAt(const CPoint& point);
	CRect PlaceSelectedElements(bool place_back,CPNElementList& selected_elements);
	CSize PlaceElements(CDC* pDC);
	CRect RecalculateEdges(const CPNElement* pDragged_element=NULL);
	CRect SelectElements(CRect& rect,CPNElementList& selected_elements);
};

#endif
