/*
  Error handler 
  Copyright (C) 2007 Jaroslav Skarvada <skarvada@fit.vutbr.cz>  
  
  This program is free software: you can redistribute it and/or modify  
  it under the terms of the GNU General Public License as published by  
  the Free Software Foundation, either version 3 of the License, or  
  (at your option) any later version.  
  
  This program is distributed in the hope that it will be useful,  
  but WITHOUT ANY WARRANTY; without even the implied warranty of  
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
  GNU General Public License for more details.  
 
  You should have received a copy of the GNU General Public License  
  along with this program.  If not, see <http://www.gnu.org/licenses/>.  
*/

#ifndef istring
#include <string>
#define istring
#endif

#ifndef ierror
#include "error.h"
#define ierror
#endif

using namespace std;

// error reporter
string
GetErrStr (int err)
{
  switch (err)
    {
    case (e_ok):
      return string ("OK");
    case (e_invparam):
      return string ("ERROR: Invalid command line parameter(s)");
    case (e_fopen):
      return string ("ERROR: Unable to open file(s)");
    case (e_fcreate):
      return string ("ERROR: Unable to create file");
    case (e_fwrite):
      return string ("ERROR: Unable to write to file");
    case (e_fformat):
      return string ("ERROR: Invalid file format");
    case (e_fsinconsist):
      return string ("ERROR: Files content inconsistent");
    case (e_nocirc):
      return string ("ERROR: There is no circuit in file");
    case (e_noin):
      return string ("ERROR: There are no input gates in file");
    case (e_noout):
      return string ("ERROR: There are no output gates in file");
    case (e_nocon):
      return string ("ERROR: There are no connections in file");
    case (e_noreg):
      return string ("ERROR: There are no registers in file");
    case (e_invelidx):
      return
	string
	("ERROR: Invalid element IDX in file (IDX must be greater than 0)");
    case (e_invgateidx):
      return
	string
	("ERROR: Invalid gate IDX in file (IDX must be greater than 0)");
    case (e_incomplete):
      return string ("ERROR: Unable read all sets, the model is incomplete");
    default:
      return string ("ERROR: Unknown error encountered");
    }
}
