/*
  Ruzicka's formal model support routines - header file
  Copyright (C) 2007 Jaroslav Skarvada <skarvada@fit.vutbr.cz>  
  
  This program is free software: you can redistribute it and/or modify  
  it under the terms of the GNU General Public License as published by  
  the Free Software Foundation, either version 3 of the License, or  
  (at your option) any later version.  
  
  This program is distributed in the hope that it will be useful,  
  but WITHOUT ANY WARRANTY; without even the implied warranty of  
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
  GNU General Public License for more details.  
 
  You should have received a copy of the GNU General Public License  
  along with this program.  If not, see <http://www.gnu.org/licenses/>.  
*/

#ifndef imap
#include <map>
#define imap
#endif

#ifndef iset
#include <set>
#define iset
#endif

#ifndef ivector
#include <vector>
#define ivector
#endif

#ifndef istring
#include <string>
#define istring
#endif

#ifndef iiostream
#include <iostream>
#define iiostream
#endif

#ifndef isetup
#include "setup.h"
#define isetup
#endif

#ifndef iruzcore
#include "ruzcore.h"
#define iruzcore
#endif

#ifndef izboril
#include "zboril.h"
#define izboril
#endif

// some aliases
#define disp_hrtor disp_hrtir
#define disp_hrtrv disp_hrtdr
#define disp_tir disp_tdr
#define disp_trv disp_tdr
#define disp_tor disp_tdr
#define addTORs addTDRs

using namespace std;

typedef map < tid, int > tscore;	// type score
typedef set < string > texc;	// type set of exclusion
// control gate names and conditions for I-path
typedef map < string, string > tmset;

// conditions for I-path from gate <from> to gate <to>
typedef struct
{
  string from;
  string to;
  tmset mset;
} tms;

// all I-paths per element
typedef vector < tms > tmsv;

// element struct
typedef struct
{
  bool isreg;			// true if it is register
  bool isinv;			// true if it is inverter
  tmsv msv;			// all I-paths per element
} tels;

// all elements and their structs
typedef map < string, tels > tvhc;

// class for penalty counter, used during I-path search
// hack for Dijkstra to be able to found all ROs
class tpenalty
{
private:
  tscore penalty;
public:
  void clear(void);
  int get(tid id);
  void set(tid id, int pen);
}; 

// class unit under analysis
class truua:public tuua
{
private:
  telset aux;
  tscore SCORE;			// score for SCAN computing
  tpenalty penalty;             // penalty for I-path search

  // Unit Under Analysis (UUA) files consistency checker
  terr check_uuaconsist (fstream & fprv, fstream & fbrn, fstream & fspj,
			 fstream & fspi);

  // exclude file "*.exc" consistency checker
  bool check_exc (string name);

  // gets first end of M-path
  bool getMend (tvhc::iterator & it_vhc, string ins, string & outs);

  // finds all M-path
  terr findM (fstream & fbrn, tvhc::iterator & it, int offs, int inn,
	      int inoutn, int outn);

  // reads connection
  bool read_con (fstream & fspj, fstream & fspi, int from);

  // reads circuit
  terr read_circ (fstream & fprv, fstream & fbrn, fstream & fspj,
		  fstream & fspi, int &nprv, int &nbrn);

  // reads element
  terr read_element (fstream & fprv, fstream & fbrn, fstream & fspj,
		     fstream & fspi, int &nprv, int &nbrn);

  // find smallest delta
  void get_smallest_delta (tid from, telset & gates, tid & to, int &dist);

  // gets PSI for element <reg>, filter it with <filter> and return
  // results in <gates>
  void get_psi (int reg, telset & filter, telset & gates);

  // check M-path conditions
  bool check_Mcond (int first, int second, string cond);

  // checks if M-path is edge free (i.e. no register on path)
  bool check_Medgefree_path (tpair & pair);

  // checks if in pairset <p> exists pair with given criteria
  bool exists_pair (tid f, telset & s, tpairset & p);

  // tests if given gate <gate> exists as target (second) gate in M
  bool gate_issecond_inM (tid gate);

  // tests if given gate <gate> exist as source (first) gate in M
  bool gate_isfirst_inM (tid gate);

  // creates union <UNION> from parts <PARTS>  
  // (for example good for All Test DRivers set creation)  
  void make_union (tidsetmap & PARTS, telset & UNION);

  // computes difference of two sets
  telset get_diffset (telset & S1, telset & S2);

  // gets maximal score
  int get_maxscore (void);

  // makes given TDRs controllable
  void addTDRs (tid el, tidsetmap & LTIR, telset & LCTDR);

  // converts gate name <gn> of element <el> to corresponding id <tid>
  tid gn2id (tid el, string gn);

  // tries to substitute gate name included as part of <str> to corresponding 
  // gate id of element <el> and returns result in <string>
  string subst_mset (tid el, string str);

  // computes score for decision which registers add to scan, 
  // can be overrided by user
  void virtual makeSCORE (void);

  // returns true if PORT belongs to invertor
  bool is_invertor (tid port);

  // returns true if in RO exists pair PAIR with sequence SEQ
  bool exists_ro(tpair pair, tsequence seq);
public:
    tidmap IPSI;		// inverse psi
  telset ATDR, ATRV, ATIR, ATOR;
  telset CTR, OBS, NOBS, NCTR, CTDR, OTRV;
  texc exc;			// excluded gates list
  tvhc vhc;			// M-modes description
  string fname, foname, fid, fdate;	// file names and dates

  // virtualization of destructor for clear code
    virtual ~ truua ()
  {
  };

  // clears all sets
  void clear (void);

  // parser of "*.vhc" file, parses file <fname> to <vhc> and gets number
  // of parsed elements in <fels>, return value is error code
  terr parsevhc (string fname, int &fels);

  // parser of "*.exc" files, parses file <fname> to <exc> and returns error code
  terr parseexc (string fname);

  // loads whole Unit Under Analysis (UUA) from zboril files
  terr LoadUUA (string fprvname, string fbrnname, string fspjname,
		string fspiname, int &nprv, int &nbrn);

  // loads whole Unit Under Analysis (UUA) from Verilog
  terr LoadUUAv (string fveriname, int &nprv, int &nbrn);

  // finds all I-paths
  void findI (ostream & f);

  // finds TDR registers for all input gates
  void findTDR (void);

  // find all TRVs for all output gates
  void findTRV (void);

  // finds all TIRs for all TDRs
  void findTIR (void);

  // find all TORs for all TRVs
  void findTOR (void);

  // simple testability check
  tid check_testable (void);

  // creates set of all controllable TIRs
  void makeCTR (void);

  // creates set of all observable TOR
  void makeOBS (void);

  // creates set of all controllable TDRs
  void makeCTDR (telset & LATDR, tidsetmap & LTIR, telset & LCTR,
		 telset & LCTDR);

  // computes MI set
  void makeMI (void);

  // computes scan set
  void makeSCAN (void);
};
