/*
  Miscellaneous utilities - header file
  Copyright (C) 2007 Jaroslav Skarvada <skarvada@fit.vutbr.cz>  
  
  This program is free software: you can redistribute it and/or modify  
  it under the terms of the GNU General Public License as published by  
  the Free Software Foundation, either version 3 of the License, or  
  (at your option) any later version.  
  
  This program is distributed in the hope that it will be useful,  
  but WITHOUT ANY WARRANTY; without even the implied warranty of  
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
  GNU General Public License for more details.  
 
  You should have received a copy of the GNU General Public License  
  along with this program.  If not, see <http://www.gnu.org/licenses/>.  
*/

#ifndef istring
#include <string>
#define istring
#endif

#ifndef iset
#include <set>
#define iset
#endif

#ifndef itimeb
#include <sys/timeb.h>
#define itimeb
#endif

using namespace std;

typedef set < char >tcharset;

// tests filename <fname> for existence
bool exists_file (string fname);

// returns upstring of string <str>
string upstring (string str1);

// try to skip token <tok> in stream <f>
// returns true if skipped, false otherwise
bool skip_token (fstream & f, char *tok);

// try to skip comment starting with <comment_str> and ending
// with EOLN in stream <f> returns true if skipped, false otherwise
bool skip_comment (fstream & f, char *comment_str);

// try to skip line in stream <f> returns true if skipped, false otherwise
bool skip_line (fstream & f);

// scan for line starting with string <line> in stream <f>
// returns true if found, false otherwise
bool find_line (fstream & f, char *line);

// reads string in double quotes of max length <len> to <str> from stream <f>
// returns true if OK, false otherwise
bool get_str (fstream & f, char *str, int len);

// gets single quoted char from stream <f> to <chr>
// returns true if OK, false otherwise
bool get_qchar (fstream & f, char &chr);

// gets one char from stream <f> to <tok>
// returns true if OK, false otherwise
bool get_tok (fstream & f, char &tok);

// gets string of max length <len> from stream <f> to <str> delimited
// with <delim>
// returns true if OK, false otherwise
bool get_data (fstream & f, char *str, int len, char delim);

// gets string of max length <len> from stream <f> to <str> delimited
// with any character from <delim>
// returns true if OK, false otherwise
bool get_data2 (fstream & f, char *str, int len, tcharset delim);

// gets time delta, current time from <t1>, returns seconds in <tds> and
// milliseconds in <tdms>
void get_tdelta (timeb t1, int &tds, int &tdms);

// displays time delta seconds <tds> and milliseconds <tdms> to stream <f>
void disp_tdelta (ostream & f, int tds, int tdms);
