/*
  Zboril's format support routines - header file
  RTL parts display utility 
  Copyright (C) 2007 Jaroslav Skarvada <skarvada@fit.vutbr.cz>  
  
  This program is free software: you can redistribute it and/or modify  
  it under the terms of the GNU General Public License as published by  
  the Free Software Foundation, either version 3 of the License, or  
  (at your option) any later version.  
  
  This program is distributed in the hope that it will be useful,  
  but WITHOUT ANY WARRANTY; without even the implied warranty of  
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
  GNU General Public License for more details.  
 
  You should have received a copy of the GNU General Public License  
  along with this program.  If not, see <http://www.gnu.org/licenses/>.  
*/

#ifndef istring
#include <string>
#define istring
#endif

#ifndef ifstream
#include <fstream>
#define ifstream
#endif

// Zboril's structures sizes
#define brana_size 41
#define spoj_size 34
#define spi_size 4

using namespace std;

#define TYP_IN 0
#define TYP_INOUT 1
#define TYP_OUT 2
#define TYP_UNKNOWN 3

// Zboril's structures type aliases
typedef int longint;
typedef unsigned char byte;
typedef unsigned short word;
typedef bool boolean;

// Zboril's structure for element <*.prv>
typedef struct
{
  longint cislo;		// IDX of element
  char jmeno[21];		// name of element
  char typ[21];			// type of element
  char tzhat[6];		// unused
  byte pvst;			// number of input gates
  byte pvsvy;			// number of input/output gates
  byte pvyst;			// number of output gates
  longint iprv;			// IDX of first gate
  word pvrt;			// unused
  longint ivrt;			// unused
  word pvyrt;			// unused
  longint ivyrt;		// unused
} tprvek;

// Zboril's structure for gate <*.brn>
typedef struct
{
  longint cislo;		// IDX of gate
  char jmeno[21];		// name of gate
  byte typ;			// type of gate
  longint iprvku;		// IDX of element owning gate
  byte sspoje;			// connection width
  longint ispoje;		// IDX of connection
  word pvtv_po;			// unused
  longint ivtv_po;		// unused
} tbrana;

// Zboril's structure for connection
typedef struct
{
  longint cislo;		// IDX of connection
  char jmeno[21];		// name of connection
  byte podkud;			// num of in gates connected
  byte podkam;			// num of in/out gates connect.
  byte pkam;			// num of out gates connected
  longint iprv;			// IDX to SPI
  byte sspoje;			// connection width
  boolean prprbr;		// attribute for primary gate
} tspoj;

// Zboril's structure for SPI
typedef longint tspi;

// Pascal string to STL string converter
string passtr2stl (char passtr[]);

// reads structure <prvek> from <f>
void read_prvek (fstream & f, tprvek & prvek);

// reads structure <brana> from <f>
void read_brana (fstream & f, tbrana & brana);

// reads structure <spoj> from <f>
void read_spoj (fstream & f, tspoj & spoj);

// reads structure <spi> from <f>
void read_spi (fstream & f, tspi & spi);


// STL string to Pascal string converter
char *stlstr2pas(string stlstr, char passtr[]);

// write structure <prvek> to <f>, return status (0 = OK, otherwise error)
int write_prvek(fstream &f, tprvek &prvek);

// write structure <brana> to <f>, return status (0 = OK, otherwise error)
int write_brana(fstream &f, tbrana &brana);

// write structure <spoj> to <f>, return status (0 = OK, otherwise error)
int write_spoj(fstream &f, tspoj &spoj);

// write structure <spi> to <f>, return status (0 = OK, otherwise error)
int write_spi(fstream &f, tspi &spi);
