
#ifndef __RUN_ACTIONS_H
#define __RUN_ACTIONS_H

/*
 * definition of functions describing runtime actions
 */

void ra_flow_end(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_return(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_cmd_block_begin(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_cmd_block_end(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_false_jmp(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_true_jmp(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_jmp(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_local_cross_jmp(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_cmd_return(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_exp_end(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_this_var(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_param_var(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_local_var(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_global_var(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_this_call(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_global_call(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_s_element(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_s_method_call(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_new_object(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_this(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_thread(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_new_char_array(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_new_int_array(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_new_double_array(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_new_array(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_array_element(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);
void ra_const(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);

/*
 * access to function callers 
 */

extern void(*script_ra_callers[])(ui_array_s &code,unsigned &code_idx,unsigned a_thread_idx,script_parser_s &_this);

#endif
