
#include "p.script_parser.h"


@begin
   header "script_parser.h";
@end

/*
 * methods of generated structures
 */

// -- value_location_s --
@begin
   methods "value_location_s";
@end

// -- location_array_s --
@begin
   methods "location_array_s";
@end

// -- value_location_pool_s --
@begin
   methods "value_location_pool_s";
@end

/*
 * release value described by description at index position
 */

void value_location_pool_s::free_value(unsigned a_idx)
{
   value_location_s &location = location_array[a_idx];

   if (location.ui_first < c_value_type_STRUCT_BASE) {
      assert(location.ui_first != 0);

      if (location.ui_first >= c_value_type_STRING) {
	 switch(location.ui_first) {
	 case c_value_type_STRING:
	    IM_ACCESS_STRING_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(location.ulli_second));
	    break;
	 case c_value_type_LOCAL_IMG:
	    local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second));
	    break;
	 case c_value_type_CHAR_ARRAY:
	    IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_INT_ARRAY:
	    IM_ACCESS_INT_ARRAY_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_DOUBLE_ARRAY:
	    IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_OBJ_ARRAY:
	    obj_array_clear(IM_ACCESS_OBJ_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_MUTEX:
	    ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.mutex_remove(IM_ACCESS_MUTEX_SRC(location.ulli_second));
	    break;
	 case c_value_type_CONDITION:
	    ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.condition_remove(IM_ACCESS_COND_SRC(location.ulli_second));
	    break;
	 default:
	    assert(0);
	 }
      }
   }
   else {
      struct_clear(IM_ACCESS_STRUCT_PTR(location.ulli_second));
   }

   remove(a_idx);
}

/*
 * release value described by description at index position,
 * elements of arrays and structures are not released by array or structure but by this function
 */

void value_location_pool_s::final_free_value(unsigned a_idx)
{

//#define FINAL_FREE_VALUE_DEBUG_OUTPUT

   value_location_s &location = location_array[a_idx];

   if (location.ui_first < c_value_type_STRUCT_BASE) {
      assert(location.ui_first != 0);

      if (location.ui_first >= c_value_type_STRING) {
	 switch (location.ui_first) {
	 case c_value_type_STRING:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_STRING\n");
#endif
	    IM_ACCESS_STRING_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(location.ulli_second));
	    break;
	 case c_value_type_LOCAL_IMG:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_LOCAL_IMG\n");
#endif
	    local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second));
	    break;
	 case c_value_type_CHAR_ARRAY:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_CHAR_ARRAY\n");
#endif
	    IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_INT_ARRAY:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_INT_ARRAY\n");
#endif
	    IM_ACCESS_INT_ARRAY_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_DOUBLE_ARRAY:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_DOUBLE_ARRAY\n");
#endif
	    IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_OBJ_ARRAY:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_OBJ_ARRAY\n");
#endif
	    IM_ACCESS_OBJ_ARRAY_PTR(location.ulli_second)->clear();
	    cfree(IM_ACCESS_OBJ_ARRAY_PTR(location.ulli_second));
	    break;
	 case c_value_type_MUTEX:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_MUTEX\n");
#endif
	    ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.mutex_remove(IM_ACCESS_MUTEX_SRC(location.ulli_second));
	    break;
	 case c_value_type_CONDITION:
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
	    printf("ff_CONDITION\n");
#endif
	    ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.condition_remove(IM_ACCESS_COND_SRC(location.ulli_second));
	    break;
	 default:
	    assert(0);
	 }
      }
#ifdef FINAL_FREE_VALUE_DEBUG_OUTPUT
      else {
	 switch(location.ui_first) {
	 case c_value_type_BLANK:
	    printf("ff_BLANK\n");
	    break;
	 case c_value_type_CHAR:
	    printf("ff_CHAR\n");
	    break;
	 case c_value_type_SHORT:
	    printf("ff_SHORT\n");
	    break;
	 case c_value_type_INT:
	    printf("ff_INT\n");
	    break;
	 case c_value_type_DOUBLE:
	    printf("ff_DOUBLE\n");
	    break;
	 case c_value_type_COLOR:
	    printf("ff_COLOR\n");
	    break;
	 case c_value_type_THREAD:
	    printf("ff_THREAD\n");
	    break;
	 default:
	    assert(0);
	 }
      }
#endif
   }
   else {
      IM_ACCESS_STRUCT_PTR(location.ulli_second)->clear();
      cfree(IM_ACCESS_STRUCT_PTR(location.ulli_second));
   }

   remove(a_idx);
}

/*
 * release all script variables from memory
 */

void value_location_pool_s::final_free_all_values()
{
   if (location_array.used == 0) return;

   unsigned v_idx = 0;
   do {
      if (location_array[v_idx].ui_first != c_idx_not_exist) {

	 //FIXME debug vypis (pocet na konci uvolnovanych hodnot)
	 //putchar('*');

	 final_free_value(v_idx);
      }
   } while(++v_idx < location_array.used);

   assert(empty_stack.used == location_array.used);
}

/*
 * create new value and its location by copying it from described existing location
 */

unsigned value_location_pool_s::copy_create_value(unsigned src_location_idx)
{
   value_location_s &src_location = location_array[src_location_idx];

   unsigned ui_first;
   unsigned long long ulli_second;

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_BLANK:
	    assert(0);
	    break;
	 case c_value_type_CHAR:
	    ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(ulli_second) = get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(ulli_second) = get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(ulli_second) = get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(ulli_second) = get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(ulli_second) = *(unsigned long long *)get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    assert(0);
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    ui_first = src_location.ui_first;
	    ulli_second = src_location.ulli_second;
	    
	    src_location.ui_first = c_value_type_BLANK;
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       {
		  ui_first = c_value_type_STRING;
		  string_s *str_ptr = (string_s *)cmalloc(sizeof(string_s));
		  ulli_second = IM_ACCESS_DATA_PTR(str_ptr);
		  str_ptr->init();
		  *str_ptr = *IM_ACCESS_STRING_PTR(src_location.ulli_second);
	       }
	       break;
	    case c_value_type_LOCAL_IMG:
	       {
		  ui_first = c_value_type_LOCAL_IMG;
		  script_parser_s *sp_ptr = (script_parser_s *)script_parser_ptr;
		  local_img_s *local_img_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));
		  ulli_second = IM_ACCESS_DATA_PTR(local_img_ptr);
		  local_img_ptr->init();

		  if (sp_ptr->multiple_threads) {
		     local_img_ptr->lock_set(sp_ptr->mutex,*IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second));
		  }
		  else {
		     local_img_ptr->set(*IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second));
		  }
	       }
	       break;
	    case c_value_type_CHAR_ARRAY:
	       {
		  ui_first = c_value_type_CHAR_ARRAY;
		  bc_array_s *bc_array_ptr = (bc_array_s *)cmalloc(sizeof(bc_array_s));
		  ulli_second = IM_ACCESS_DATA_PTR(bc_array_ptr);
		  bc_array_ptr->init();
		  *bc_array_ptr = *IM_ACCESS_CHAR_ARRAY_PTR(src_location.ulli_second);
	       }
	       break;
	    case c_value_type_INT_ARRAY:
	       {
		  ui_first = c_value_type_INT_ARRAY;
		  bi_array_s *bi_array_ptr = (bi_array_s *)cmalloc(sizeof(bi_array_s));
		  ulli_second = IM_ACCESS_DATA_PTR(bi_array_ptr);
		  bi_array_ptr->init();
		  *bi_array_ptr = *IM_ACCESS_INT_ARRAY_PTR(src_location.ulli_second);
	       }
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       {
		  ui_first = c_value_type_DOUBLE_ARRAY;
		  bd_array_s *bd_array_ptr = (bd_array_s *)cmalloc(sizeof(bd_array_s));
		  ulli_second = IM_ACCESS_DATA_PTR(bd_array_ptr);
		  bd_array_ptr->init();
		  *bd_array_ptr = *IM_ACCESS_DOUBLE_ARRAY_PTR(src_location.ulli_second);
	       }
	       break;
	    case c_value_type_OBJ_ARRAY:
	       {
		  ui_first = c_value_type_OBJ_ARRAY;
		  ui_array_s *ui_array_ptr = (ui_array_s *)cmalloc(sizeof(ui_array_s));
		  ulli_second = IM_ACCESS_DATA_PTR(ui_array_ptr);
		  ui_array_ptr->init();
		  
		  ui_array_s *src_ui_array_ptr = IM_ACCESS_OBJ_ARRAY_PTR(src_location.ulli_second);

		  if (src_ui_array_ptr->used != 0) {
		     unsigned *si_ptr = src_ui_array_ptr->data;
		     unsigned *si_ptr_end = si_ptr + src_ui_array_ptr->used;

		     do {
			ui_array_ptr->push(copy_create_value(*si_ptr));
		     } while(++si_ptr < si_ptr_end);
		  }
	       }
	       break;
	    case c_value_type_MUTEX:
	       {
		  ui_first = c_value_type_MUTEX;

		  unsigned src_mutex_idx = IM_ACCESS_MUTEX_SRC(src_location.ulli_second);

		  ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.mutex_increase_cnt(src_mutex_idx);
		  IM_ACCESS_MUTEX_TRG(ulli_second) = src_mutex_idx;
	       }
	       break;
	    case c_value_type_CONDITION:
	       {
		  ui_first = c_value_type_CONDITION;

		  unsigned src_condition_idx = IM_ACCESS_COND_SRC(src_location.ulli_second);

		  ((script_parser_s *)script_parser_ptr)->sp_mcs_pool.condition_increase_cnt(src_condition_idx);
		  IM_ACCESS_COND_TRG(ulli_second) = src_condition_idx;
	       }
	       break;
	    default:
	       assert(0);
	    }
	 }
      }
   }
   else {
      if (src_location.uc_third & c_value_modifier_TMP) {
	 ui_first = src_location.ui_first;
	 ulli_second = src_location.ulli_second;
	 
	 src_location.ui_first = c_value_type_BLANK;
      }
      else {
	 ui_first = src_location.ui_first;
	 ui_array_s *ui_array_ptr = (ui_array_s *)cmalloc(sizeof(ui_array_s));
	 ulli_second = IM_ACCESS_DATA_PTR(ui_array_ptr);
	 ui_array_ptr->init();

	 ui_array_s *src_ui_array_ptr = IM_ACCESS_STRUCT_PTR(src_location.ulli_second);

	 if (src_ui_array_ptr->used != 0) {
	    unsigned *si_ptr = src_ui_array_ptr->data;
	    unsigned *si_ptr_end = si_ptr + src_ui_array_ptr->used;

	    do {
	       ui_array_ptr->push(copy_create_value(*si_ptr));
	    } while(++si_ptr < si_ptr_end);
	 }
      }
   }

   return insert(ui_first,ulli_second,c_value_modifier_WRITABLE);
}

/*
 * compare two variables described by its locations index
 */

bool value_location_pool_s::compare_values(unsigned first_location_idx,unsigned second_location_idx)
{
   value_location_s &first_location = location_array[first_location_idx];
   value_location_s &second_location = location_array[second_location_idx];

   if (first_location.ui_first != second_location.ui_first) {
      return false;
   }

   if (first_location.ui_first < c_value_type_STRUCT_BASE) {
      if (first_location.ui_first < c_value_type_STRING) {
	 switch (first_location.ui_first) {
	 case c_value_type_BLANK:
	    assert(0);
	    break;
	 case c_value_type_CHAR:
	    if (get_char_value(first_location) == get_char_value(second_location)) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_SHORT:
	    if (get_short_value(first_location) == get_short_value(second_location)) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_INT:
	    if (get_int_value(first_location) == get_int_value(second_location)) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_DOUBLE:
	    if (get_double_value(first_location) == get_double_value(second_location)) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_COLOR:
	    if (*((unsigned long long *)get_color_ptr(first_location)) == *((unsigned long long *)get_color_ptr(second_location))) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_THREAD:
	    if (IM_ACCESS_THREAD_SRC(first_location.ulli_second) == IM_ACCESS_THREAD_SRC(second_location.ulli_second)) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 default:
	    assert(0);
	 }
      }
      else {
	 switch (first_location.ui_first) {
	 case c_value_type_STRING:
	    if (*(IM_ACCESS_STRING_PTR(first_location.ulli_second)) == *(IM_ACCESS_STRING_PTR(second_location.ulli_second))) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_LOCAL_IMG:
	    {
	       local_img_s *first_local_img_ptr = IM_ACCESS_LOCAL_IMG_PTR(first_location.ulli_second);
	       local_img_s *second_local_img_ptr = IM_ACCESS_LOCAL_IMG_PTR(second_location.ulli_second);
	       script_parser_s &sp_ptr = *((script_parser_s *)script_parser_ptr);

	       if (sp_ptr.multiple_threads) {
		  return first_local_img_ptr->lock_compare(sp_ptr.mutex,*second_local_img_ptr);
	       }
	       else {
		  return first_local_img_ptr->compare(*second_local_img_ptr);
	       }
	    }
	 case c_value_type_CHAR_ARRAY:
	    if (*(IM_ACCESS_CHAR_ARRAY_PTR(first_location.ulli_second)) == *(IM_ACCESS_CHAR_ARRAY_PTR(second_location.ulli_second))) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_INT_ARRAY:
	    if (*(IM_ACCESS_INT_ARRAY_PTR(first_location.ulli_second)) == *(IM_ACCESS_INT_ARRAY_PTR(second_location.ulli_second))) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_DOUBLE_ARRAY:
	    if (*(IM_ACCESS_DOUBLE_ARRAY_PTR(first_location.ulli_second)) == *(IM_ACCESS_DOUBLE_ARRAY_PTR(second_location.ulli_second))) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_OBJ_ARRAY:
	    {
	       ui_array_s *first_ui_array_ptr = IM_ACCESS_OBJ_ARRAY_PTR(first_location.ulli_second);
	       ui_array_s *second_ui_array_ptr = IM_ACCESS_OBJ_ARRAY_PTR(second_location.ulli_second);

	       if (first_ui_array_ptr->used != second_ui_array_ptr->used) return false;
	       if (first_ui_array_ptr->used == 0) return true;

	       unsigned *fui_ptr = first_ui_array_ptr->data;
	       unsigned *fui_ptr_end = fui_ptr + first_ui_array_ptr->used;
	       unsigned *sui_ptr = second_ui_array_ptr->data;

	       do {
		  if (!(compare_values(*fui_ptr,*sui_ptr))) {
		     return false;
		  }
	       } while(++sui_ptr,++fui_ptr < fui_ptr_end);

	       return true;
	    }
	 case c_value_type_MUTEX:
	    if (IM_ACCESS_MUTEX_SRC(first_location.ulli_second) == IM_ACCESS_MUTEX_SRC(second_location.ulli_second)) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 case c_value_type_CONDITION:
	    if (IM_ACCESS_COND_SRC(first_location.ulli_second) == IM_ACCESS_COND_SRC(second_location.ulli_second)) {
	       return true;
	    }
	    else {
	       return false;
	    }
	 default:
	    assert(0);
	 }
      }
   }
   else {
      ui_array_s *first_ui_array_ptr = IM_ACCESS_STRUCT_PTR(first_location.ulli_second);
      ui_array_s *second_ui_array_ptr = IM_ACCESS_STRUCT_PTR(second_location.ulli_second);

      if (first_ui_array_ptr->used != 0) {
	 unsigned *fui_ptr = first_ui_array_ptr->data;
	 unsigned *fui_ptr_end = fui_ptr + first_ui_array_ptr->used;
	 unsigned *sui_ptr = second_ui_array_ptr->data;

	 do {
	    if (!(compare_values(*fui_ptr,*sui_ptr))) {
	       return false;
	    }
	 } while(++sui_ptr,++fui_ptr < fui_ptr_end);
      }

      return true;
   }
}

/*
 * release of object describing obj_array from memory
 */

void value_location_pool_s::obj_array_clear(ui_array_s *ui_array_ptr)
{
   if (ui_array_ptr->used != 0) {
      unsigned *i_ptr = ui_array_ptr->data;
      unsigned *i_ptr_end = i_ptr + ui_array_ptr->used;

      do {
	 free_value(*i_ptr);
      } while(++i_ptr < i_ptr_end);
   }

   ui_array_ptr->clear();
   cfree(ui_array_ptr);
}

/*
 * release of structure and element of this structure from memory
 */

void value_location_pool_s::struct_clear(ui_array_s *struct_ptr)
{
   if (struct_ptr->used != 0) {
      unsigned *s_var_ptr = struct_ptr->data;
      unsigned *s_var_ptr_end = s_var_ptr + struct_ptr->used;

      do {
	 free_value(*s_var_ptr);
      } while(++s_var_ptr < s_var_ptr_end);
   }

   struct_ptr->clear();
   cfree(struct_ptr);
}

/*
 * print of array content
 */

void value_location_pool_s::char_array_print(bc_array_s *bc_array_ptr)
{
   if (bc_array_ptr->used != 0) {
      char *c_ptr = bc_array_ptr->data;
      char *c_ptr_end = c_ptr + bc_array_ptr->used;

      do {
	 printf("%c ",*c_ptr);
      } while(++c_ptr < c_ptr_end);
   }
   else {
      printf("empty");
   }
}

/*
 * printf of integer array content to stdout
 */

void value_location_pool_s::int_array_print(bi_array_s *bi_array_ptr)
{
   if (bi_array_ptr->used != 0) {
      int *i_ptr = bi_array_ptr->data;
      int *i_ptr_end = i_ptr + bi_array_ptr->used;

      do {
	 printf("%d ",*i_ptr);
      } while(++i_ptr < i_ptr_end);
   }
   else {
      printf("empty");
   }
}

/*
 * print of double array content to stdout
 */

void value_location_pool_s::double_array_print(bd_array_s *bd_array_ptr)
{
   if (bd_array_ptr->used != 0) {
      double *d_ptr = bd_array_ptr->data;
      double *d_ptr_end = d_ptr + bd_array_ptr->used;

      do {
	 printf("%f ",*d_ptr);
      } while(++d_ptr < d_ptr_end);
   }
   else {
      printf("empty");
   }
}

/*
 * print of object array content to stdout
 */

void value_location_pool_s::obj_array_print(ui_array_s *ui_array_ptr)
{
   if (ui_array_ptr->used != 0) {
      unsigned *i_ptr = ui_array_ptr->data;
      unsigned *i_ptr_end = i_ptr + ui_array_ptr->used;

      do {
	 print_value_idx(*i_ptr);
	 //putchar(' ');
      } while(++i_ptr < i_ptr_end);
   }
   else {
      printf("empty");
   }
}

/*
 * print of value described by location
 */

void value_location_pool_s::print_value(value_location_s &location)
{
   if (location.ui_first < c_value_type_STRUCT_BASE) {
      switch (location.ui_first) {
      case c_value_type_BLANK:
	 printf("<BLANK>");
	 break;
      case c_value_type_CHAR:
	 putchar(get_char_value(location));
	 break;
      case c_value_type_SHORT:
	 printf("%hd",get_short_value(location));
	 break;
      case c_value_type_INT:
	 printf("%d",get_int_value(location));
	 break;
      case c_value_type_DOUBLE:
	 printf("%f",get_double_value(location));
	 break;
      case c_value_type_COLOR:
	 {
	    short *color_ptr = get_color_ptr(location);
	    printf("color r:%hd g:%hd b:%hd a:%hd",color_ptr[0],color_ptr[1],color_ptr[2],color_ptr[3]);
	 }
	 break;
      case c_value_type_THREAD:
	 printf("thread: %u",IM_ACCESS_THREAD_SRC(location.ulli_second));
	 break;
      case c_value_type_STRING:
	 printf("%s",IM_ACCESS_STRING_PTR(location.ulli_second)->data);
	 break;
      case c_value_type_LOCAL_IMG:
	 local_img_print(IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second));
	 break;
      case c_value_type_CHAR_ARRAY:
	 char_array_print(IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second));
	 break;
      case c_value_type_INT_ARRAY:
	 int_array_print(IM_ACCESS_INT_ARRAY_PTR(location.ulli_second));
	 break;
      case c_value_type_DOUBLE_ARRAY:
	 double_array_print(IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second));
	 break;
      case c_value_type_OBJ_ARRAY:
	 obj_array_print(IM_ACCESS_OBJ_ARRAY_PTR(location.ulli_second));
	 break;
      case c_value_type_MUTEX:
	 {
	    sp_mcs_s &sp_mutex = ((script_parser_s *)script_parser_ptr)->sp_mcs_pool[IM_ACCESS_MUTEX_SRC(location.ulli_second)];
	    printf("mutex: %s",(sp_mutex.ui_first)?"locked":"unlocked");
	 }
	 break;
      case c_value_type_CONDITION:
	 {
	    sp_mcs_s &sp_condition = ((script_parser_s *)script_parser_ptr)->sp_mcs_pool[IM_ACCESS_COND_SRC(location.ulli_second)];
	    printf("condition: waiting %d",sp_condition.ui_first);
	 }
	 break;
      default:
	 assert(0);
      }
   }
   else {
      assert(0);
   }
}


