/*
*	This file contains class that load images from specified video sequence.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/


#include "StdAfx.h"
#include <tchar.h>
#include <strsafe.h>
#include "VideoFile.h"

/** Funkce pro vytvoreni tridy a preneseni ven z DLL.
*
*	\note	Muze vratit NULL pri chybe.
*/
extern "C" TCameraAbstract*	CreateCamera( const char * filename )
{
	return TCameraVideoFile::CreateCamera( filename );
}

/** Tato staticka metoda vyrvori kameru.
*
*	\note	Vraci NULL pri chybe.
*
*	\param	filename	[in] jmeno souboru s videosekvenci
*/
TCameraVideoFile* TCameraVideoFile::CreateCamera( const char * filename )
{
	//vytvorime objekt
	TCameraVideoFile * cam = new TCameraVideoFile;

	//inicializujeme
	if ( cam->Initialize( filename ) )
	{
		//ok - kamera inicializovana v poradku
		return cam;
	}
	else
	{
		//nejaka chyba
		delete cam;
		return NULL;
	}
}

/** Soukromy konstruktor.
*/
TCameraVideoFile::TCameraVideoFile(void)
{
	m_source = NULL;
}

/** Soukromy destruktor.
*/
TCameraVideoFile::~TCameraVideoFile(void)
{
	//odstranime pokud je potreba
	if ( m_source )
	{
		m_source->Destroy();
		delete m_source;
		m_source = NULL;
	}
}

/** Tato metoda inicializuje tridu po vytvoreni.
*/
bool TCameraVideoFile::Initialize( const char * filename )
{
	m_source = new TVideoDSFile;
	if ( m_source->Initialize( filename ) )
	{
		return true;
	}
	else
	{
		delete m_source;
		m_source = NULL;
		
		return false;
	}
}

/** Velikost obrazku v bajtech.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*/
DWORD TCameraVideoFile::GetDataSize(void)
{
	return this->GetWidth() * this->GetHeight() * 3;
}

/** Ulozi data do pripraveneho bufferu.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*
*	\param	dest	[in out] buffer pro data obrazku
*/
void TCameraVideoFile::GetData(void * dest)
{
	m_source->GetDataRGB( dest );
}

/** Vrati sirku obrazku v pixelech.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*/
int TCameraVideoFile::GetWidth(void)
{
	return m_source->GetWidth();
}

/** Vrati vysku obrazku v pixelech.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*/
int TCameraVideoFile::GetHeight(void)
{
	return m_source->GetHeight();
}

/** Zrusi tento objekt.
*/
void TCameraVideoFile::Destroy(void)
{
	delete this;
}