/*
*	This file contains DLL that represents simple working unit.
*
*	You can use this project to create new simple unit.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <crtdbg.h>
#include <windows.h>

#include "MemoryAlloc.h"

#include "pipeline/SimpleUnit.h"
#include "DerivedUnit.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// EXPORT TABLE

//tyto funkce musi exportovat kazda DLL knihovna s jednotkou
extern "C" __declspec(dllexport) EnumDLLType		GetType(void);
extern "C" __declspec(dllexport) TUnitInterface*	CreateUnit( TDispatcherInterface * dispatcher );
extern "C" __declspec(dllexport) EnumUnitType		GetUnitResultType(void);
extern "C" __declspec(dllexport) const char *		GetUnitCreateInfo(void);
extern "C" __declspec(dllexport) const char *		GetUnitResultInfo(void);


/** Funkce pro urceni typu funkce "CreateUnit"
*/
extern "C" EnumDLLType GetType(void)
{
	return ENUM_DLLTYPE_BASIC;
}

/** Funkce pro vytvoreni tridy a preneseni ven z DLL.
*
*	Presny typ funkce (jejich parametru) lze ziskat pomoci funkce GetType().
*
*	\param	dispatcher	[in] platne rozhrani dispatcheru
*/
extern "C" TUnitInterface*	CreateUnit( TDispatcherInterface * dispatcher )
{
	TTestUnit * test	= new TTestUnit;
	TSimpleUnit * unit	= new TSimpleUnit( dispatcher, test, FALSE );

	return unit;
}

/** Funkce vraci informaci o datovem typu vysledku dane jednotky pouzite v teto DLL.
*/
extern "C" __declspec(dllexport) EnumUnitType GetUnitResultType(void)
{
	return ENUM_UNITTYPE_INTEGER;
}

/** Tato funkce vraci textovy retezec s informacemi o funkci CreateUnit, ktera vytvari
*	jednotku.
*
*	Retezec by mel obsahovat napr. deklaraci funkce a popis parametru - pokud existuji
*/
extern "C" const char *	GetUnitCreateInfo(void)
{
	return 
	"TUnitInterface * CreateUnit( TDispatcherInterface * dispatcher )\n"
	"\n"
	"dispatcher [in] interface to valid dispatcher";
}

/** Tato funkce vraci textovy retezec s informacemi o typu navratovych hodnot teto jednotky.
*
*	Mel by zde byt obsazen typ navratove hodnoty a dale napr. informace o tom, co je vlastne
*	ve vysledku obsazeno.
*/
extern "C" const char *	GetUnitResultInfo(void)
{
	return
	"TUnitRetType_integer\n"
	"\n"
	"This is testing unit that returns average intensity of pixels in gray image.";
}

// EXPORT TABLE
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/** Standardni vstupni funkce DLL knihovny.
*
*	\param	hinstDLL	[in] handle aktualni instance processu
*	\param	fdwReason	[in] duvod zavolani teto funkce
*	\param	lpReserved	[in] nepouzito
*/
BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpReserved)
{
    // Perform actions based on the reason for calling.
    switch( fdwReason ) 
    { 
        case DLL_PROCESS_ATTACH:
         // Initialize once for each new process.
         // Return FALSE to fail DLL load.
#ifdef _DEBUG
			_CrtDbgReport(_CRT_WARN, NULL, NULL,NULL, 
			"============================\n"
			"DLL with working unit loaded\n"
			"============================\n"
			"Example of unit that compute intensity of frames.\n"
			);
#endif
		break;

        case DLL_THREAD_ATTACH:
         // Do thread-specific initialization.
            break;

        case DLL_THREAD_DETACH:
         // Do thread-specific cleanup.
            break;

        case DLL_PROCESS_DETACH:
         // Perform any necessary cleanup.
#ifdef _DEBUG
			_CrtDbgReport(_CRT_WARN, NULL, NULL,NULL, 
			"============================================\n"
			"DLL with working unit unloaded\n"
			"Memory using:\n"
			"\t Blocks via \"operator new\"  : %d\n"
			"\t Blocks via \"operator new[]\": %d\n"
			"\n"
			"Allocated objects for results: %u\n"
			"============================================\n",
			TMemoryAllocStats::m_alloc_normal,
			TMemoryAllocStats::m_alloc_array,
			TManager<TUnitRetType_integer_implemented>::GetAllocCount()
			);			
#endif
            break;
    }
    return TRUE;  // Successful DLL_PROCESS_ATTACH.
}