/*
*	 This file contains class that encapsulates system thread.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <windows.h>

//FORWARD DECLARATIONS
namespace NSPipeline
{
	class TThread;
};

#ifndef _PIPELINE_THREAD_HH_
#define _PIPELINE_THREAD_HH_

/** Novy typ pro specifikaci ukazatele na funkci spoustenou vlaknem.
*/
typedef DWORD (*FUNC_PTR)(void*);

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TThread

/** Tato trida reprezentuje jednoduche vlakno.
*
*	Vlakno se spousti metodou TThread::Run().
*
*	Po spusteni by melo byt vlakno ukonceno nejakym externim mechanismem (napr. promennou), ktera
*	ve vykonavaci funkci kontroluje beh smycky. Vlakno by melo byt spravne ukonceno tak, ze
*	metoda TThread::IsTerminated() vrati TRUE a nasledne staci zavolat metodu TThread::Finish(), ktera
*	zajisti vycisteni promennych uvnitr..
*
*	Vlakno lze prerusit nasilim pomoci metody TThread::Terminate() - pouziti teto metody je vsak nebezpecne
*	protoze uvnitr beziciho vlakna muzou zustat nealokovane zdroje, otevrene synchronizacni mechanismy apod.
*
*	\warning	Funkce spoustena vlaknem musi vracet hodnotu typu DWORD. Tato hodnota
*	nesmi byt v zadnem pripade shodna s hodnotou STILL_ACTIVE. V tom pripade by totiz
*	nebylo mozne rozeznat jiz dokoncenou funkci (toto chovani vychazi z implementace vlakne ve Windows).
*/
class TThread
{
//PUBLIC METHODS
public:
					TThread(void);
					~TThread(void);

	BOOL			Run(FUNC_PTR function,void * params);
	BOOL			IsRunning(void) const;
	BOOL			IsTerminated(void);
	BOOL			Finish(void);
	BOOL			Terminate(void);

//PRIVATE FAKE METHODS
private:
					TThread( const TThread & orig );	///< falesny kopirovaci konstruktor
	void			operator=( const TThread & orig );	///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	HANDLE			m_thread;		///< handle na vytvorene vlakno
};
//OK 2007-08-25 00:04:59 B04-315B\Tom

/** Konstruktor.
*
*	Vytvori neinicializovane vlakno.
*	To musi byt nasledne spusteno metodou Run().
*/
inline TThread::TThread(void) 
{
	m_thread = NULL;
}
//OK 2007-08-25 00:05:02 B04-315B\Tom

/** Destruktor.
*
*	Mel by byt volan pouze na radne ukoncene vlakno, tj. metoda IsTerminated() vraci
*	TRUE a nasledna metoda Finish() vycisti objekt.
*	
*	Pokud vlakno neni radne ukonceno pak se jej destruktor pokusi ukoncit, coz ale
*	muze zpusobit problemy, protoze to muze znamenat preruseni beziciho vlakna napr. po vstupu
*	do kriticke sekce apod.
*/
inline TThread::~TThread(void)
{
	if( m_thread )
	{
		Terminate();
	}
}
//OK 2007-08-25 00:08:29 B04-315B\Tom

// TThread
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

};//end of NSPipeline
using namespace NSPipeline;

#endif