/*
*	 This file contains class that helps you load working unit from DLL.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <windows.h>

//FORWARD DECLARATIONS
namespace NSPipeline
{
	class TUnitLoader;
};

#ifndef _PIPELINE_UNITLOADER_HH_
#define _PIPELINE_UNITLOADER_HH_

#include "pipeline/Unit.h"

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TUnitLoader

/** Tato trida nacte pracovni jednotku ze zadane DLL.
*
*	Vytvoreny objekt v sobe udrzuje nactenou DLL.
*
*	Jakmile objekt vrati jednotku pak je tato ulozena a je vracena vzdy.
*
*	Pred znicenim tohoto objektu musi byt jednotka jim vytvorena take znicena.
*/
class TUnitLoader
{
//PUBLIC METHODS
public:
							TUnitLoader(void);
							~TUnitLoader(void);	
		
	TUnitInterface*			GetUnit_BASIC( const char * dllName, TDispatcherInterface * dispatcher );
	TUnitInterface*			GetUnit_STRING( const char * dllName, TDispatcherInterface * dispatcher, const char * str );

//PROTECTED FAKE METHODS
protected:
							TUnitLoader( const TUnitLoader & orig );	///< falesny kopirovaci konstruktor
	void					operator=( const TUnitLoader & orig );		///< falesny prirazovaci operator


//PRIVATE COMPONENTS
private:
	TUnitInterface*			m_unit;			///< vracena jednotka z DLL
	HMODULE					m_library;		///< pouzita knihovna
};
//OK 2007-08-25 18:22:45 B04-315B\Tom

// TUnitLoader
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of NSPipeline
using namespace NSPipeline;

#endif