/*
*
*	This file contains structures that store pointer to image
*	and also information about used area in rectangle.
*	Structures has reference counting.
*
*	There is also manager for this objects.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <cassert>
#include "simpleunit/ImageResStruct.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TImageRGBResult

/** Snizi pocet referenci na objekt.
*
*	Pokud pocet referenci klesne na 0 pak je objekt navracen do manageru kterym byl vytvoren.
*
*	Metoda je synchronizovana pro vicenasobny pristup.
*/
void TImageRGBResult::Release(void)
{
	m_cs.Enter();
		m_refs--;
		DWORD tmp_refs = m_refs;
	m_cs.Leave();

	if ( tmp_refs == 0 )
	{
		//musime objekt navratit do manageru
		m_manager->InsertObject( this );
	}
}
//OK 2007-08-25 23:41:56 B04-315B\Tom

// TImageRGBResult
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TImageRGBResultManager

/** Vytvori manager obrazku typu RGB.
*
*	\param	width		[in] sirka obrazku vytvarenych managerem
*	\param	height		[in] vyska obrazku vytvarenych managerem
*	\param	initSize	[in] pocet predalokovanych snimku
*/
TImageRGBResultManager::TImageRGBResultManager( DWORD width, DWORD height, DWORD initSize)
{
	m_width		= width;
	m_height	= height;

	m_exportCount = 0;		// zadny obrazek nebyl zatim exportovan

	//vytvorime predalokovane objekty
	for ( DWORD i = 0 ; i < initSize ; i++ )
	{
		m_object.push_back( new TImageRGBResult( this, m_width, m_height ) );
	}
}
//OK 2007-08-25 23:42:12 B04-315B\Tom

/** Zrusi manager.
*
*	\warning	V aplikaci se nesmi vyskytovat zadny objekt vytvoreny timto managerem.
*/
TImageRGBResultManager::~TImageRGBResultManager( void )
{
	assert( m_exportCount == 0 );

	//zrusime objekty
	while ( ! m_object.empty() )
	{
		TImageRGBResult * obj = m_object.back();
		m_object.pop_back();

		delete obj;
	}
}
//OK 2007-08-25 23:42:14 B04-315B\Tom

/** Vrati novy objekt.
*
*	Objekt ma jednu referenci a velikost platneho obdelnika je nastavena na cely obrazek.
*
*	Metoda je synchronizovana pro soubezny pristup.
*/
TImageRGBResult* TImageRGBResultManager::GetObject( void )
{
	TImageRGBResult * res = NULL;

	//zjistime jestli existuje nejaky volny objekt
	m_cs.Enter();
		if ( ! m_object.empty() )
		{
			//mame objekt - pouzijeme
			res = m_object.back();
			m_object.pop_back();
		}	
		else
		{
			//vytvorime novy objekt
			res = new TImageRGBResult( this, m_width, m_height );
		}

		res->Reset();
		
		m_exportCount++;

	m_cs.Leave();

	return res;
}
//OK 2007-08-25 23:42:29 B04-315B\Tom

/** Metoda vrati objekt zpet do manageru.
*
*	Metoda je volana z metody Release vraceneho objektu v okamziku kdy pocet referenci klesne
*	na 0.
*
*	Metoda je synchronizovana pro soubezny pristup.
*
*	\param	image	[in] vraceny obrazek
*/
void TImageRGBResultManager::InsertObject( TImageRGBResult* image )
{
	m_cs.Enter();
		m_object.push_back( image );
		m_exportCount--;
	m_cs.Leave();
}
//OK 2007-08-25 23:42:35 B04-315B\Tom

// TImageRGBResultManager
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////