/*
*	This file contains class that load images from first DirectShow camera in system.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "CameraAbstract/CameraAbstract.h"

#include "CameraSource.h"

//deklarace funkce pro export tridy ven z DLL
extern "C" __declspec(dllexport) TCameraAbstract*	CreateCamera( void );

//FORWARD DECLARATIONS
namespace NSCameras
{
	class TCameraDshow;
};

#ifndef _CAMERAS_CAMERA_HH_
#define _CAMERAS_CAMERA_HH_

namespace NSCameras
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraDshow

/** Tato trida reprezentuje kameru ziskavajici snimky z prvni fyzicke kamery
*	umistene v systemu a umoznujici pristup pres DirectShow.
*
*	Trida plne respektuje pravidla bazove tridy TCameraAbstract a proto by manipulace
*	s vytvorenym objektem mela probihat pouze pres bazovou tridu (rozhrani).
*/
class TCameraDshow : public TCameraAbstract
{
//PUBLIC OVERRIDEN METHODS
public:
	virtual DWORD				GetDataSize(void);	
	virtual void				GetData(void * dest);	
														

	virtual int					GetWidth(void);			
	virtual int					GetHeight(void);			

	virtual void				Destroy(void);

//PUBLIC STATIC METHODS
public:
	static TCameraDshow*		CreateCamera( void );

//PRIVATE METHODS
private:
	bool						Initialize( void );

								TCameraDshow(void);
								~TCameraDshow(void);

								TCameraDshow( const TCameraDshow & orig );	///< falesny kopirovaci konstruktor
	void						operator=( const TCameraDshow & orig );		///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	TVideoDSFile*				m_source;		///< zdroj videa
};

// TCameraDshow
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSCameras
using namespace NSCameras;

#endif