/*
*	This file contains class that simulates null camera.
*	This camera always return black image with size 640x480.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "CameraAbstract/CameraAbstract.h"

//deklarace funkce pro export tridy ven z DLL
extern "C" __declspec(dllexport) TCameraAbstract*	CreateCamera(const char * filename);

namespace NSCameras
{
	class TCameraImage;
};

#ifndef _CAMERAS_CAMERAIMAGE_HH_
#define _CAMERAS_CAMERAIMAGE_HH_

namespace NSCameras
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraNull

/** Tato trida reprezentuje kameru vracejici vzdy cerny obrazek
*	o velikosti 640x480.
*
*	Data jsou vzdy ve formatu 24-bitu RGB.
*
*/
class TCameraNull : public TCameraAbstract
{
//PUBLIC OVERRIDEN METHODS
public:
	virtual DWORD				GetDataSize(void);	
	virtual void				GetData(void * dest);	
														

	virtual int					GetWidth(void);			
	virtual int					GetHeight(void);			

	virtual void				Destroy(void);

//PUBLIC STATIC METHODS
public:
	static TCameraNull*			CreateCamera(const char * filename);

//PRIVATE METHODS
private:
	bool						Initialize( const char * filename );

								TCameraNull(void);
								~TCameraNull(void);						

								TCameraNull( const TCameraNull & orig );	///< falesny kopirovaci kontruktor
	void						operator=( const TCameraNull & orig );		///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	int							m_width;		///< sirka nacteneho obrazu
	int							m_height;		///< vyska nacteneho obrazu

	unsigned char*				m_data;			///< pixely obrazu	
};

// TCameraNull
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSCameras
using namespace NSCameras;

#endif