/*
*	This file contains class that load images from specified video sequence.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/


#include <windows.h>
#include <dshow.h>
#include <streams.h>

namespace NSCameras
{
	class TDSSampler;
	class TVideoDSFile;
};

#ifndef _CAMERAS_VIDEODS_HH_
#define _CAMERAS_VIDEODS_HH_

namespace NSCameras
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/** Toto je jednoznacny identifikator pro implementovany sampler.
*/
struct __declspec(  uuid("{0F53C699-B463-4c12-AAD1-FEB0A3EA1E40}")  ) CLSID_Sampler;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TDSSampler

/** Tato trida reprezentuje DirectShow komponentu pro ziskavani a ukladani snimku
*	prichazejicich sestavenym grafem.
*
*	Trida je odvozena od zobrazovaci tridy DirectShow a tedy ji lze pouzit misto
*	zobrazovaci tridy na konci DirectShow grafu.
*
*	Trida uklada prisla data do snimku typu RGB. Tato data lze nasledne ziskat
*	pomoci verejne dostupnych metod. Tyto metody jsou synchronizovane pro vicenasobny
*	pristup vice vlaken, coz umoznuje soucasny pristup ze strany grafu DirectShow 
*	a uzivatelskych volani.
*/
class TDSSampler : public CBaseVideoRenderer 
{
//PUBLIC OVERRIDEN METHODS
public:
						TDSSampler( IUnknown* unk, HRESULT *hr );
						~TDSSampler();

	HRESULT 			CheckMediaType( const CMediaType* media );
	HRESULT 			DoRenderSample( IMediaSample* sample);
	HRESULT 			ShouldDrawSampleNow( IMediaSample* sample, REFERENCE_TIME* start, REFERENCE_TIME* stop );

//PUBLIC METHODS
public:
	BITMAPINFOHEADER	GetFrameInfo(void) const;
	void				GetData( void * data );

	int					GetWidth(void) const;
	int					GetHeight(void) const;

//PRIVATE COMPONENTS
private:
	BITMAPINFOHEADER	m_info;			///< informace o vstupnim datovem toku

	bool				m_rowsFliped;	///< urcuje zda jsou radky ukladany odspodu
	int					m_rgb_width;	///< sirka snimku v pixelech
	int					m_rgb_height;	///< vyska snimku v pixelech
	int					m_rgb_size;		///< velikost snimku v bajtech ( W * H * 3 )	

	int					m_img_stride;	///< pocet bajtu v jednom radku zdrojovych snimku
	int					m_img_align;	///< pocet zarovnavacich bajtu v jednom radku

	BYTE*				m_data1;		///< snimek ve formatu RGB
	BYTE*				m_data2;		///< snimek ve formatu RGB - do nej se zapisuje a nasledne
										///< se ukazatele vymeni	

	CCritSec			m_cs;			///< kriticka sekce pro pristup k M_READ1									
};

/** Vrati sirku obrazu v pixelech.
*/
inline int TDSSampler::GetWidth(void) const
{
	return m_rgb_width;
}

/** Vrati vysku obrazu v pixelech.
*/
inline int TDSSampler::GetHeight(void) const
{
	return m_rgb_height;
}

// TDSSampler
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TVideoDSFile

/** Tato trida reprezentuje kameru ziskavajici snimky ze zadaneho video souboru.
*
*	Trida sestavi DirectShow graf a zaroven jej umi kontrolovat.
*/
class TVideoDSFile
{
//PUBLIC METHODS
public:
						TVideoDSFile(void);
						~TVideoDSFile(void);

	bool				Initialize( const char * filename );
	bool				Destroy(void);

	int					GetWidth(void) const;
	int					GetHeight(void) const;

	void				GetDataRGB( void * data );

//PRIVATE COMPONENTS
private:
	IGraphBuilder*		m_graph;		///< graf sestaveny pro prehravani videa
	IMediaControl*		m_ctrl;			///< rozhrani pro rizeni prehravani
	TDSSampler*			m_sampler;		///< vlastni sampler pro ziskavani obrazku
	IMediaSeeking*		m_seek;			///< rozhrani pro moznost navratu na zacatek

	LONGLONG			m_length;		///< delka videa zjistena pri nacteni

	int					m_width;		///< sirka snimku v pixelech
	int					m_height;		///< vyska snimku v pixelech
};

/** Sirka obrazu v pixelech.
*/
inline int TVideoDSFile::GetWidth(void) const
{
	return m_width;
}

/** Sirka obrazu v pixelech.
*/
inline int TVideoDSFile::GetHeight(void) const
{
	return m_height;
}

// TVideoDSFile
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSCameras
using namespace NSCameras;

#endif