/*
*	This file contains class that represents queue of frames that comes from
*	dispatcher and wait for displaying in renderer.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <queue>
using namespace std;

// FORWARD DECLARATIONS
namespace NSPipeline
{
	class TFrameQueue;
};

#ifndef _PIPELINE_FRAMEQUEUE_HH_
#define _PIPELINE_FRAMEQUEUE_HH_

#include "pipeline/Image.h"
#include "pipeline/CriticalSection.h"

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TFrameQueue

/** Fronta snimku (FIFO).
*
*	Obsahuje dve vnitrni fronty - vyrovnavaci buffer a vystupni frontu.
*
*	Vnitrni buffer obsahuje snimky, ktere nelze zobrazit a zajistuje tedy plynulost zobrazovani.
*	Vystupni fronta pak obsahuje snimky, ktere vystoupily z vnitrniho bufferu a mohou byt
*	ziskany pro zobrazenu.
*
*	Velikost vnitrniho bufferu lze menit za behu aplikace a tim urcovat zpozdeni.
*
*	Pokud je snimek jeste zpracovavan nejakou jednotkou pak by vystupni fronta nemela pustit snimek
*	ven z fronty - to je zajisteno zamkem na snimku od dane jednotky.
*
*	Fronta nema vlastni vlakno (neni to nutne), ale jeji metody jsou zabezpecene pro vicenasobny pristup.
*
*	Vstupem snimku do fronty je tomuto zvysen pocet referenci. Fronta nikdy nezvysuje pocet zamku na snimku.
*
*	Snimek je do fronty automaticky zaslan dispatcherem, kteremu je fronta predana jako parameter.
*
*	Dulezita vlastnost je, ze jakmile je snimek ve fronte zarazen pak uz se nemuze zvysovat pocet zamku
*	na nem. Zamek totiz lze na snimek pridat pouze v dispatcheru.
*/
class TFrameQueue
{
//PUBLIC METHODS
public:
						TFrameQueue(void);
						~TFrameQueue(void);

	void				AddFrame( TFrameReal * frame);
	TFrameReal*			GetRenderableFrame(void);

	DWORD				GetInputBufferLength(void) const;
	void				SetInputBufferLength( DWORD length );

	void				Free(void);

//PRIVATE FAKE METHODS
private:
						TFrameQueue( const TFrameQueue & orig );	///< falesny kopirovaci konstruktor
	void				operator=( const TFrameQueue & orig );		///< falesny operator prirazeni

//PRIVATE COMPONENTS
private:
	DWORD						m_length;		///< delka vnitrniho buffer

	queue<TFrameReal*>			m_buffer;		///< vnitrni buffer
	queue<TFrameReal*>			m_frames;		///< vystupni fronta snimku

	TCriticalSection			m_critical;		///< kriticka sekce pro pristup ke snimkum z fronty

};
//OK 2007-08-25 12:07:09 B04-315B\Tom

// TFrameQueue
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //end of NSPipeline
using namespace NSPipeline;

#endif