/*
*	This file contains abstract class for camera loaded from DLL.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <windows.h>

//FORWARD DECLARATIONS
namespace NSCameras
{
	class TCameraAbstract;
};

#ifndef _CAMERAS_CAMERAABSTRACT_HH_
#define _CAMERAS_CAMERAABSTRACT_HH_

namespace NSCameras
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraAbstract

/** Tato trida reprezentuje rozhrani pro kameru, ze ktere se ziskavaji snimky ve formatu RGB.
*
*	Objekt tridy musi byt odstranen pomoci metody Destroy() - operator DELETE nelze pouzit
*	protoze pamet je alokovana uvnitr DLL.
*
*	\note	Zarovnani bajtu v pixelu typu RGB na pocitacich s ukladanim bajtu little endian je
*			nasledujici [ADRESA 0]BGRBGRBGR...
*/
class TCameraAbstract
{
//PUBLIC METHODS
public:
	virtual DWORD		GetDataSize(void) = 0;				///< velikost jednoho snimku v bajtech
	virtual void		GetData(void * dest) = 0;			///< ulozi do pripravene pameti aktualni
															///< obrazova data
															///< data jsou vzdy ve formatu RGB a jsou ulozena
															///< souvisle v pameti

	virtual int			GetWidth(void) = 0;					///< sirka dat v pixelech
	virtual int			GetHeight(void) = 0;				///< vyska dat v pixelech

	virtual void		Destroy(void) = 0;					///< zniceni tohoto objektu

//PROTECTED METHODS
protected:
						TCameraAbstract(void){};						///< konstruktor
						~TCameraAbstract(void){};						///< destruktor
						TCameraAbstract( const TCameraAbstract & orig );///< falesny kopirovaci konstruktor
	void				operator=( const TCameraAbstract & orig );		///< falesny kopirovaci konstruktor
};

// TCameraAbstract
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

//ukazatele na funkce pro ziskani kamery z DLL

typedef TCameraAbstract* (*PTR_CAMERAGET)(void);	
typedef TCameraAbstract* (*PTR_CAMERAGETIMAGE)( const char * filename );

}; //END of namespace NSCameras
using namespace NSCameras;

#endif