/*
*	This file contains class that represents thread with camera input.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <windows.h>

//FORWARD DECLARATIONS
namespace NSPipeline
{
	class TCameraThread;
};

#ifndef _PIPELINE_CAMERATHREAD_HH_
#define _PIPELINE_CAMERATHREAD_HH_

#include "pipeline/Thread.h"
#include "pipeline/CriticalSection.h"
#include "pipeline/Dispatcher.h"
#include "pipeline/Image.h"
#include "pipeline/CameraAbstract.h"

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraThread

/** Tato trida reprezentuje vlakno s bezici kamerou.
*
*	Kamera a dispatcher musi byt predany do objektu. Oba objekty musi byt pozdeji zniceny
*	po zniceni tohoto objektu (tedy tento objekt neprebira referenci a zodpovednost za tyto objekty).
*
*	Pri vytvareni je pro objekt zadan interval v milisekundach, ktery uplyne mezi ziskanim dvou snimku.
*
*	Trida vytvori pro kameru alokator snimku, jehoz velikost lze ovlivnit. Jakmile nejsou k dispozici
*	zadne dalsi snimky pak kamera negeneruje zadna dalsi snimky.
*
*	\warning Tento objekt udrzuje manager snimku a proto muze byt odstranen pouze tehdy, kdyz v aplikaci
*	neexistuji reference na snimky.
*/
class TCameraThread
{
//PUBLIC METHODS
public:
	TCameraThread( TDispatcher * dispatcher, TCameraAbstract * camera, DWORD sleepTime, DWORD reservedFrames = 100 );
	~TCameraThread(void);

	BOOL					Start(void);
	BOOL					Stop(void);

	DWORD					GetSleepTime(void) const;

//STATIC PRIVATE METHODS
private:
	static DWORD WINAPI		TCameraDLLRun(void* ptr);

//PRIVATE FAKE METHODS
private:
							TCameraThread( const TCameraThread & orig );///< falesny kopirovaci konstruktor
	void					operator=( const TCameraThread & orig );	///< falesny operator prirazeni


//PRIVATE COMPONENTS
private:
	TThread*				m_thread;		///< vlakno pro beh teto kamery
	bool					m_isRunning;	///< urcuje zda kamera (vlakno) bezi

	TCameraAbstract*		m_camera;		///< objekt pro ziskavani obrazovych dat (exteni objekt)
	DWORD					m_sleepTime;	///< pocet milisekund mezi ziskanim dvou snimku	

	TDispatcher*			m_dispatcher;	///< dispatcher do ktereho se predavaji vytvorene snimky
											///< (externi objekt)
	
	TImageSetManager*		m_manager;		///< manazer snimku
};
//OK 2007-08-25 15:21:35 B04-315B\Tom

/** Vrati cas, ktery uplyne mezi ziskanim dvou snimku z kamery.
*
*	Cas je uveden v milisekundach.
*/
inline DWORD TCameraThread::GetSleepTime(void) const
{
	return m_sleepTime;
}
//OK 2007-08-25 15:21:51 B04-315B\Tom

// TCameraThread
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of NSPipeline
using namespace NSPipeline;

#endif