/*
*	 This file contains class that encapsulate system critical section.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "pipeline/CriticalSection.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCriticalSection

/** Konstruktor.
*
*	Inicializuje kritickou sekci.
*/
TCriticalSection::TCriticalSection(void)
{
	InitializeCriticalSection(&m_section);
}
//OK 2007-08-25 02:21:09 B04-315B\Tom

/** Destruktor.
*
*	Zrusi kritickou sekci.
*/
TCriticalSection::~TCriticalSection(void)
{
	DeleteCriticalSection(&m_section);
}
//OK 2007-08-25 02:21:11 B04-315B\Tom

/** Vstup do kriticke sekce.
*
*	Volani metody je blokujici az do vstupu do kriticke sekce.
*	Tj. pokud jiz jine vlakno zavolalo tuto metodu na tomto objektu
*	pak ostatni vlakna musi cekat.
*/
void TCriticalSection::Enter(void)
{
	EnterCriticalSection(&m_section);
}
//OK 2007-08-25 02:21:14 B04-315B\Tom

/** Uvolneni kriticke sekce.
*
*	Metoda smi byt volana pouze po zavolani metody Enter (po vstupu do sekce).
*	Zaroven odblokuje ostatni vlakna ktera pristupuji k teto kriticke sekci.
*/
void TCriticalSection::Leave(void)
{
	LeaveCriticalSection(&m_section);
}
//OK 2007-08-25 02:21:42 B04-315B\Tom

// TCriticalSection
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////