/*
*
*	This file contains template for simple object manager
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/
#include <vector>
using namespace std;

#include <windows.h>

#ifndef _SIMPLEUNIT_MANAGER_HH_
#define _SIMPLEUNIT_MANAGER_HH_

namespace NSSimpleUnit
{

/**	Tato sablona reprezentuje manager pro dynamicky alokovane objekty.
*	
*	Manager muze obsahovat pouze jednoduche objekty, ktere neobsahuji reference na externi objekty apod.
*	Objekty jsou vytvareny v manageru a pak vraceny aplikaci. Z toho duvodu musi byt objekty vytovritelne
*	pres defaultni konstruktor a musi mit k dispozici operator delete (zadna metoda Release apod.).
*
*	Jakmile je objekt vracen z manageru do aplikace, prebira za nej aplikace odpovednost. Bud
*	muze objekt vratit do manageru metodou PushItem() nebo znici objekt.
*/
template <typename T>
class TManager
{
//PUBLIC METHODS
public:
					TManager(void);
					TManager(DWORD size);
					~TManager( void );

	T*				GetItem(void);
	void			PushItem(T * item );

//PUBLIC STATIC METHODS
public:
	static DWORD	GetAllocCount(void);

//PRIVATE FAKE METHODS
private:
					TManager( const TManager & orig);	///< falesny kopirovaci konstruktor
	void			operator=( const TManager & orig );	///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	vector<T*>		m_objects;		///< vektor s ukazateli na objekty.

	static DWORD	ms_alloc_count;	///< celkovy pocet alokovanych objektu v manageru
};
//OK 2007-08-25 21:58:37 B04-315B\Tom

/** Implicitni konstruktor.
*
*	Vytvori manager bez predalokovanych objektu
*/
template <typename T>
inline TManager<T>::TManager(void)
{
}

/** Konstruktor. Vytvori zadany pocet objektu do vnitrniho pole.
*
*	\param	size	[in] pocet predalokovanych objektu
*/
template <typename T>
inline TManager<T>::TManager(DWORD size)
{
	for ( DWORD i = 0; i < size ; i++ )
	{
		ms_alloc_count++;
		m_objects.push_back( new T );
	}
}
//OK 2007-08-25 21:59:32 B04-315B\Tom

/** Destruktor.
*
*	Automaticky znici vsechny objekty alokovane v manageru v dobe volani.
*/
template <typename T>
inline TManager<T>::~TManager(void)
{
	while ( ! m_objects.empty() )
	{
		T * ptr = m_objects.back();
		delete ptr;
		m_objects.pop_back();
	}
}
//OK 2007-08-25 21:59:39 B04-315B\Tom

/** Vrati novy objekt.
*
*	Pokud neni dalsi objekt k dispozici pak je novy alokovan.
*
*	Metoda zaroven odstrani vraceny objekt z manageru a postarat se o nej musi
*	aplikace.
*/
template <typename T>
inline T* TManager<T>::GetItem(void)
{
	if ( ! m_objects.empty() )
	{
		//mame naalokovany objekt
		T * ptr = m_objects.back();
		m_objects.pop_back();

		return ptr;
	}
	else
	{
		//nemame uz dalsi objekt - vytvorime novy
		ms_alloc_count++;
		return new T;
	}
}
//OK 2007-08-25 21:59:54 B04-315B\Tom

/** Pomoci teto metody lze vratit drive ziskany objekt zpet do manageru.
*
*	\param	item	[in] dynamicky alokovany objekt drive ziskany z tohoto manazeru
*/
template <typename T>
inline void TManager<T>::PushItem( T * item  )
{
	m_objects.push_back( item );
}
//OK 2007-08-25 22:00:04 B04-315B\Tom

/** Vrati celkovy pocet alokaci provedenych v managerech tohoto typu.
*/
template <typename T>
inline DWORD TManager<T>::GetAllocCount(void)
{
	return ms_alloc_count;
}
//OK 2007-08-25 22:00:14 B04-315B\Tom

}; //END of namespace NSSimpleUnit
using namespace NSSimpleUnit;

#endif