/*
*	This file contains class that represents working class inside
*	TSimpleUnit and returns 
*
*		IMAGES 
*
*	value. Returned class
*	is derived from 
*
*		TUnitRetType_images
*
*	class.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/



#include <deque>
#include <vector>
using namespace std;

namespace NSSimpleUnit
{
	class TUnitRetType_images_rgb_implemented;
	class TSimpleUnitProcessingInterface_images_rgb;
};

#ifndef _SIMPLEUNIT_SIMPLE_IMAGES_HH_
#define _SIMPLEUNIT_SIMPLE_IMAGES_HH_

#include "pipeline/SimpleUnit.h"
#include "simpleunit/Manager.h"
#include "simpleunit/ImageResStruct.h"

namespace NSSimpleUnit
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TUnitRetType_images_rgb_implemented

/** Tato trida reprezentuje navratovy typ, reprezentujici obrazek ve formatu RGB (TImageRGB).
*
*	Jedina pouzitelna metoda pro vypocetni jednotku je metoda InsertImage(), ktera
*	vlozi novy obrazek do vysledku
*
*	Ostatni nevirtualni metody jsou nepodstatne.
*
*	JE VZDY NUTNE REIMPLEMENTOVAT VSECHNY VIRTUALNI METODY Z BAZOVE TRIDY!!!
*/
class TUnitRetType_images_rgb_implemented : public TUnitRetType_images
{
friend TManager<TUnitRetType_images_rgb_implemented>;
friend TSimpleUnitProcessingInterface_images_rgb;

//PUBLIC OVERRIDEN METHODS
public:
	virtual EnumUnitType	GetType(void) const;
	virtual void			Release(void);

	virtual DWORD			GetImageCount(void);
	virtual	const TImage*	GetImage( DWORD index );
	virtual	const TRT_Rect*	GetRectangle( DWORD index );

//PUBLIC METHODS
public:
	void					InsertImage( TImageRGBResult * imageRes );

//PRIVATE METHODS
private:
							TUnitRetType_images_rgb_implemented(void);
							~TUnitRetType_images_rgb_implemented(void);

	void					AddRefs(void);
	void					PreReset(void);
	void					Reset(void);
	void					SetParent( TSimpleUnitProcessingInterface_images_rgb * parent);

//PRIVATE FAKE METHODS
private:
							TUnitRetType_images_rgb_implemented( const TUnitRetType_images_rgb_implemented & orig);	///< falesny kopirovaci konstruktor
	void					operator=( const TUnitRetType_images_rgb_implemented & orig);						///< falesny prirazovaci operator


//PRIVATE COMPONENTS
private:
	DWORD										m_refs;		///< pocet referenci na objekt
	vector<TImageRGBResult*>					m_values;	///< vlastni ulozene obrazky
															///< kazdy udrzuje referenci na objekt

	TCriticalSection							m_cs;		///< synchronizace pro pocitani referenci

	TSimpleUnitProcessingInterface_images_rgb*	m_parent;	///< jednotka kde byl objekt vytvoren
															///< a kam ma byt vracen
};
//OK 2007-08-26 00:21:48 B04-315B\Tom

/** Vrati typ tridy.
*/
inline EnumUnitType TUnitRetType_images_rgb_implemented::GetType(void) const
{
	return ENUM_UNITTYPE_IMAGES_RGB;
}
//OK 2007-09-06 20:16:55 B04-315B\Tom

/** Virtualni metoda vracejici pocet obrazku ulozenych v tomto vysledku.
*/
inline DWORD TUnitRetType_images_rgb_implemented::GetImageCount(void)
{
	return (DWORD)m_values.size();
}
//OK 2007-08-26 00:16:28 B04-315B\Tom

/** Vrati ukazatel na obrazek ulozeny na zadanem indexu.
*
*	Pokud je index mimo rozsah pak vraci NULL.
*
*	\param	index	[in] index pozadovaneho obrazku
*/
inline const TImage* TUnitRetType_images_rgb_implemented::GetImage( DWORD index )
{
	if ( index < (DWORD)m_values.size() )
	{
		return m_values[index]->GetImage();
	}
	else
	{
		return NULL;
	}
}
//OK 2007-08-26 00:16:32 B04-315B\Tom

/** Vrati ukazatel na informace o platnosti dat v obrazku ulozeny na zadanem indexu.
*
*	Pokud je index mimo rozsah pak vraci NULL.
*
*	\param	index	[in] index pozadovaneho obdelniku (obrazku)
*/
inline const TRT_Rect* TUnitRetType_images_rgb_implemented::GetRectangle( DWORD index )
{
	if ( index < (DWORD)m_values.size() )
	{
		return m_values[index]->GetRectangle();
	}
	else
	{
		return NULL;
	}
}
//OK 2007-08-26 00:16:35 B04-315B\Tom

/** Soukromy konstruktor.
*
*	Vytvori objekt s jednou referenci a zadnym obrazkem uvnitr.
*
*	METODA JE VOLANA Z MANAGERU TECHTO OBJEKTU VE VYPOCETNI JEDNOTCE DEFINOVANE NIZE.
*/
inline TUnitRetType_images_rgb_implemented::TUnitRetType_images_rgb_implemented(void)
{
	m_refs	= 1;
}
//OK 2007-08-26 00:16:53 B04-315B\Tom

/** Soukromy destruktor.
*
*	METODA JE VOLANA Z MANAGERU TECHTO OBJEKTU VE VYPOCETNI JEDNOTCE DEFINOVANE NIZE.
*/
inline TUnitRetType_images_rgb_implemented::~TUnitRetType_images_rgb_implemented(void)
{
	//odstranime reference na vsechny obrazky
	while( ! m_values.empty() )
	{
		TImageRGBResult * img = m_values.back();
		m_values.pop_back();

		img->Release();
	}
}
//OK 2007-08-26 00:17:04 B04-315B\Tom

/** Prida dalsi obrazek do vysledku.
*
*	Metoda zvysi pocet referenci na obrazek.
*
*	Tato metoda by mela byt pouzita v ramci tridy TSimpleUnitProcessingInterface_images
*	v metode ProcessFrame, kdy objekt jeste neni zarazen do seznamu vysledku a tedy
*	nad nim pracuje pouze jedno vlakno.
*
*	\param	imageRes	[in] pridany platny obrazek
*/
inline void TUnitRetType_images_rgb_implemented::InsertImage( TImageRGBResult * imageRes )
{
	imageRes->AddRefs();

	m_values.push_back( imageRes );
}
//OK 2007-08-26 00:17:24 B04-315B\Tom

/** Pridani reference na objekt.
*/
inline void TUnitRetType_images_rgb_implemented::AddRefs(void)
{
	m_cs.Enter();
		m_refs++;
	m_cs.Leave();
}
//OK 2007-08-26 00:17:26 B04-315B\Tom

/** Tato metoda je volana pred vracenim objektu zpatky do manazeru a zajistuje, ze vsechny
*	reference na obrazky budou uvolneny.
*
*	Metoda by mela byt volana pouze z jednoho vlakna a tedy neni nutna synchronizace.
*/
inline void TUnitRetType_images_rgb_implemented::PreReset(void)
{
	while( ! m_values.empty() )
	{
		TImageRGBResult * img = m_values.back();
		m_values.pop_back();

		img->Release();
	}
}
//OK 2007-08-26 00:21:57 B04-315B\Tom

/** Tato metoda inicializuje zadany objekt do podoby po vytvoreni.
*
*	Metoda by mela byt volana v manageru objektu pokud byl uz objekt
*	drive pouzit. To znamena, ze objekt je pri zavolani drzen pouze jednim vlaknem
*	a tedy neni potreba synchronizace.
*/
inline void TUnitRetType_images_rgb_implemented::Reset(void)
{
	m_refs	= 1;

	//odstranime reference na vsechny obrazky - k tomu by nemelo nikdy dojit 
	//nebot reference by mely byt vzdy odstraneny pred vracenim objektu do manageru!!!
	while( ! m_values.empty() )
	{
		TImageRGBResult * img = m_values.back();
		m_values.pop_back();

		img->Release();
	}
}
//OK 2007-08-26 00:22:03 B04-315B\Tom

/** Nastaveni rodicovske jednotky pro tento objekt.
*
*	Metoda je volana v manageru objektu zadane jednotky a tedy k ni pristupuje pouze
*	jedno vlakno.
*
*	\param	parent	[in] rodicovska jednotka, ktera objekt vlastni a do ktere by mel byt vracen
*/
inline void 
TUnitRetType_images_rgb_implemented::SetParent( TSimpleUnitProcessingInterface_images_rgb * parent)
{
	m_parent = parent;
}
//OK 2007-08-26 00:22:09 B04-315B\Tom

// TUnitRetType_images_rgb_implemented
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TSimpleUnitProcessingInterface_images_rgb

/** Tato jednotka vraci hodnoty typu IMAGES_RGB.
*
*	ODVOZENA TRIDA MUSI REIMPLEMENTOVAT METODU PROCESSFRAME()!!!
*/
class TSimpleUnitProcessingInterface_images_rgb : public TSimpleUnitProcessingInterface
{
friend TUnitRetType_images_rgb_implemented;

//PUBLIC OVERRIDEN METHODS
public:
	virtual void						ProcessFrame( const TFrame * frame ) = 0;

	virtual								~TSimpleUnitProcessingInterface_images_rgb(void);

	/** Typ jednotky a vracenych vysledku.
	*/
	virtual EnumUnitType				GetType(void) const { return ENUM_UNITTYPE_IMAGES_RGB; };

	virtual TUnitRetTypeInterface*		GetResult( DWORD id );

//PUBLIC METHODS
public:
										TSimpleUnitProcessingInterface_images_rgb(void);

//PROTECTED METHODS
protected:
	void									AddResult( DWORD id, TUnitRetType_images_rgb_implemented * res );

	TUnitRetType_images_rgb_implemented*	GetObject(void);
	void									ReturnObject( TUnitRetType_images_rgb_implemented * object );

	void									FreeImageResults(void);

//PROTECTED FAKE METHODS
protected:
										TSimpleUnitProcessingInterface_images_rgb( const TSimpleUnitProcessingInterface_images_rgb & orig);	///< falesny kopirovaci konstruktor
	void								operator=( const TSimpleUnitProcessingInterface_images_rgb & orig);									///< falesny prirazovaci operator

//PROTECTED COMPONENTS
protected:
	static const DWORD sc_memory = 10;	///< maximalni pocet vysledku, ktere si trida pamatuje

//PRIVATE COMPONENTS
private:
	deque<TUnitRetType_images_rgb_implemented*>	m_results;		///< posledni vysledky
	deque<DWORD>								m_resultsID;	///< identifikatory k vysledkum
																///< identifikator urcuje ID snimku
																///< ktereho se vysledek tyka

	TManager<TUnitRetType_images_rgb_implemented>	m_objects;		///< manager s objekty, neni je nutne
																	///< neustale alokovat

	TCriticalSection							m_cs_res;		///< synchronizace pristupu
																///< k vysledkum	
	TCriticalSection							m_cs_manager;	///< synchronizace pristupu k manageru
};
//OK 2007-08-26 00:22:50 B04-315B\Tom

/** Konstruktor.
*/
inline TSimpleUnitProcessingInterface_images_rgb::TSimpleUnitProcessingInterface_images_rgb(void)
{
	//empty
}
//OK 2007-08-26 00:22:52 B04-315B\Tom

/** Virtualni destruktor.
*
*	Smi byt volan v okamziku kdyz uz neexistuji zadne reference na vysledky teto jednotky!!!
*/
inline TSimpleUnitProcessingInterface_images_rgb::~TSimpleUnitProcessingInterface_images_rgb(void)
{
	//odstranime vsechny vysledky
	while ( ! m_results.empty() )
	{
		//muzeme pouzit operator delete, protoze na vysledek uz v aplikaci nejsou reference
		//metoda Release() by vysledek pouze vratila do manageru
		TUnitRetType_images_rgb_implemented * ptr = m_results.front();
		m_results.pop_front();
		delete ptr;
	}
}
//OK 2007-08-26 00:22:55 B04-315B\Tom

/** Ziskani vysledku ze snimku s pozadovanym ID.
*
*	\param	id		[in] identifikator pozadovaneho snimku
*/
inline TUnitRetTypeInterface* TSimpleUnitProcessingInterface_images_rgb::GetResult( DWORD id ) 
{
	//TODO - mozna by se vyplatilo zahodit vsechny vysledky starsi nez ten posledni pozadovany

	TUnitRetType_images_rgb_implemented * res = NULL;

	m_cs_res.Enter();
		//musime nalezt snimek s pozadovanym ID a vratit vysledek
		const size_t size = m_resultsID.size();
		for ( size_t i = 0 ; i < size ; i++ )
		{
			if ( id == m_resultsID[i] )
			{
				//nasli jsme pozadovany vysledek
				res = m_results[i];
				res->AddRefs();
				break;
			}
		}
	m_cs_res.Leave();

	return res; 
};
//OK 2007-08-26 00:22:58 B04-315B\Tom

/** Pridani noveho vysledku do seznamu vysledku.
*
*	Vysledek je pridan na konec seznamu.
*
*	\param	id		[in] identifikace snimku pro nejz je vysledek urcen
*	\param	res		[in] platny vysledek - metoda nezvysuje pocet referenci na nej !!!
*/
inline void 
TSimpleUnitProcessingInterface_images_rgb::AddResult( DWORD id, TUnitRetType_images_rgb_implemented * res )
{
	m_cs_res.Enter();
		m_results.push_back( res );
		m_resultsID.push_back( id );

		//odstranime zastarale prvky
		if ( m_results.size() > sc_memory )
		{
			TUnitRetType_images_rgb_implemented * ptr = m_results.front();
			ptr->Release();

			m_results.pop_front();
			m_resultsID.pop_front();
		}
	m_cs_res.Leave();
}
//OK 2007-08-26 00:23:17 B04-315B\Tom

/** Vrati novy objekt z manageru objektu.
*
*	Tento objekt je dale ve vlastnictvi aplikace dokud jej nevrati zpet do manageru
*	pomoci metody ReturnObject();
*
*	Metoda je volana z metody ProcessFrame().
*/
inline TUnitRetType_images_rgb_implemented *
TSimpleUnitProcessingInterface_images_rgb::GetObject(void)
{
	m_cs_manager.Enter();
		TUnitRetType_images_rgb_implemented * ptr = m_objects.GetItem();
	m_cs_manager.Leave();

	//re-inicializace objektu
	ptr->Reset();

	ptr->SetParent( this );

	return ptr;
}
//OK 2007-08-26 00:23:20 B04-315B\Tom

/** Vrati zpet do manageru objekt ziskany metodou GetObject().
*
*	Metoda by mela byt volana z metody Release() vraceneho objektu.
*
*	Tato metoda zaroven uvolni vsechny obrazky drzene v objektu.
*
*	\param	object	[in] vraceny objekt - metoda jej zaradi do manageru a pri pristim
*					pouziti jej manager znovu reinicializuje
*/
inline void
TSimpleUnitProcessingInterface_images_rgb::ReturnObject( TUnitRetType_images_rgb_implemented * object )
{
	m_cs_manager.Enter();
		//uvolnime reference v objektu
		object->PreReset();
		//vratime objekt do manageru
		m_objects.PushItem( object );
	m_cs_manager.Leave();
}
//OK 2007-08-26 00:23:34 B04-315B\Tom

// TSimpleUnitProcessingInterface_images_rgb
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSSimpleUnit
using namespace NSSimpleUnit;

#endif

