/*
*	This file contains working unit derived from TSimpleUnit.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/
#include <cstdio>

#include "DerivedUnit.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TTestUnit

/** Virtualni destruktor.
*/
TTestUnit::~TTestUnit(void)
{
}

/** Metoda pro zpracovani snimku.
*
*	\param	frame	[in] nove prichozi snimek zaslany jednotkou TSimpleUnit.
*/
void TTestUnit::ProcessFrame( const TFrame * frame )
{
	//ukazkova uloha - vypocet prumerne hodnoty intenzity v monochromatickem obraze

	//informace o snimku
	const DWORD f_id				=	frame->GetTimestamp().GetID();
	const DWORD f_width				=	frame->GetImageSet()->GetGray()->GetWidth();
	const DWORD f_height			=	frame->GetImageSet()->GetGray()->GetHeight();

	//data snimku v odstinech sedi
	const DWORD f_size				=	frame->GetImageSet()->GetGray()->GetDataSize();
	const unsigned char * f_data	=	(unsigned char *)frame->GetImageSet()->GetGray()->GetData();

	//soucet intenzit
	int sum = 0;
	for ( DWORD i = 0 ; i < f_size ; i++ )
	{
		sum += f_data[i];
	}
	//vysledna intenzita
	sum /= f_size;

	//ZAPIS VYSLEDKU
	//ziskame objekt pro ulozeni vysledku
	TUnitRetType_integer_implemented * res = this->GetObject();
	
	//nastaveni hodnoty vysledku do objektu pro ulozeni vysledku
	res->SetValue( sum );

	//ulozime vysledek pro tento snimek - je identifikovat jednoznacnym ID
	this->AddResult( frame->GetTimestamp().GetID(), res );
}

// TTestUnit
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////