#include <stdio.h>
#include "highgui.h"
#include "vplGradLocals.h"


struct cGradLocals * gradLocalsCreate( void )
{
	struct cGradLocals * gl = (struct cGradLocals *)malloc( sizeof( struct cGradLocals) );

	gl->gaussWnd = NULL;
	gl->bins = 0;
	gl->pyrs = 0;
	gl->ws = 0;
	gl->wo = 0.0;

	gl->ip = NULL;
	gl->ftrs = NULL;

	return gl;
}


int gradLocalsInit( struct cGradLocals * gl, int pyrs, int bins, float wndOverlap, int wndSize )
{
	if( !gl ) return -1;

	gl->ws = MAX(1,wndSize);
	gl->wo = wndOverlap;
	gl->pyrs = pyrs;
	gl->bins = bins;

	if( gl->gaussWnd && gl->gaussWnd->size != gl->ws )
		wndPatchRelease( &gl->gaussWnd );

	if( !gl->gaussWnd )
		gl->gaussWnd = wndPatchCreate( gl->ws, 1.0*gl->ws/(8.0*sqrt(2.0)) );

	return 1;

}

int gradLocalsCount( struct cGradLocals * gl, int rows, int cols, int oct, int * gr, int * gc, double * ds )
{
	double _ds;								// delta of width, resp. height
	int _gr, _gc, count, ftr_count, i;

	if( !gl ) return 0;

	_ds = gl->ws*(1.-gl->wo);
	_ds = (_ds==0.?1.0:_ds);
	_gc = cvFloor( 1.*(cols-gl->ws)/_ds )+1;
	_gr = cvFloor( 1.*(rows-gl->ws)/_ds )+1;
	count = _gc*_gr; ftr_count = 0;

	if( oct < 0 )
		for( i = 0; i < gl->pyrs; ++i ) ftr_count += (count>>(2*i));
	else 
		ftr_count = (count>>(2*oct));

	if( gc ) *gc = _gc;
	if( gr ) *gr = _gr;
	if( ds ) *ds = _ds;

	return ftr_count;
}

int gradLocalsDims( struct cGradLocals * gl )
{
	if( !gl ) return 0;
	return gl->bins;
}

CvMat * gradLocalsEval( struct cGradLocals * gl, CvArr * image, CvMat * ftrs )
{
	int i, o, k;
	CvMat * fts = NULL;
    CvMat tmp, *src = (CvMat*)image;
	double ds;								// delta of width, resp. height
	int gr, gc, ftr_count;

	#ifdef _DEBUG
	CvMat * show = NULL;
	CvMat * showWnd = NULL;
	#endif

	if( !gl || !image ) return NULL;

	//cvNamedWindow( "Pattern1", 1 );
	//cvShowImage( "Pattern1", image );

	src = cvGetMat( image, &tmp, &i, 0 );

	ftr_count = gradLocalsCount( gl, src->rows, src->cols, -1, &gr, &gc, &ds );

	if( ftrs && ( ftrs->cols != gl->bins || ftrs->rows != ftr_count ) ) 
		return NULL;

	if( gl->ftrs && ( gl->ftrs->cols != gl->bins || gl->ftrs->rows != ftr_count) ) 
		cvReleaseMat( &gl->ftrs );

	if( ftrs ) fts = ftrs;
	else 
	{
		if( !gl->ftrs )	gl->ftrs = cvCreateMat( ftr_count, gl->bins, CV_32FC1 );
		fts = gl->ftrs;
	}
	
	cvZero( fts );

	gl->ip = imagePyrSobel( gl->ip, image, gl->pyrs, 3 );

	for( k = 0, o = 0; o < gl->pyrs; ++o ) 
	{
		for( i = 0; i < gr*gc; ++i, ++k ) 
		{
			int x = i%gc;
			int y = i/gc;
			CvMat f;

			CvRect wnd = cvRect( cvFloor(x*ds), cvFloor(y*ds), gl->ws, gl->ws );

			gradWeighted( 
				imagePyrGet(gl->ip,o,3), 
				imagePyrGet(gl->ip,o,4), 
				wnd, 
				cvGetRow( fts, &f, k ), 
				gl->gaussWnd->g, 
				gl->gaussWnd->p );
	
			#if _DEBUG
			if( !show ) { show = cvCreateMat( imagePyrGet(gl->ip,o,3)->rows+5, imagePyrGet(gl->ip,o,3)->cols+5, src->type ); showWnd = cvCreateMat( gl->ws, gl->ws, src->type ); }
			if( i == 0 ) cvZero( show ); 
			cvConvertScale( gl->gaussWnd->p, showWnd, 64., 0. );
			cvAdd( showWnd, cvGetSubRect( show, &f, wnd ), cvGetSubRect( show, &f, wnd ), 0 );
			//cvNamedWindow( "Pattern", 1 );
			//cvShowImage( "Pattern", show );
			//if( cvWaitKey( 10 ) == 27 ) break;
			#endif
			
		}

		#ifdef _DEBUG
		{
			CvMat * s1 = cvCreateMat( show->rows, show->cols, CV_8UC3 );
			cvCvtColor( show, s1, CV_GRAY2RGB );
			for( i = 0; i < gr*gc; ++i ) 
				cvCircle( s1, cvPoint(cvFloor(i%gc*ds+0.5*gl->ws),cvFloor(i/gc*ds+0.5*gl->ws)), gl->ws/3, CV_RGB(255,0,0), 1, CV_AA, 0 );
			cvNamedWindow( "Pattern", 1 );
			cvShowImage( "Pattern", s1 );
			//cvWaitKey( 0 );
			cvReleaseMat( &s1 );
			cvReleaseMat( &show );
			cvReleaseMat( &showWnd );
		}
		#endif

		gr = gr>>1;
		gc = gc>>1;
	}

	return fts;
}

double gradLocalsDistance( const void * a, const void * b, void * userdata )
{
	struct cGradLocals * gl = NULL;
	int ftr_count;
	CvMat * A, * B, _A, _B;
	int i;
	double d = 0.;

	if( userdata ) 
	{	
		ftr_count = *(int *)userdata;
		A = cvReshape( (CvArr *)a, &_A, 0, ftr_count );
		B = cvReshape( (CvArr *)b, &_B, 0, ftr_count );
	}
	else 
	{
		A = (CvMat *)a;
		B = (CvMat *)b;
		if( !CV_ARE_SIZES_EQ( A, B ) ) return -1.;
		ftr_count = A->rows;
	}
	
	for( i = 0; i < ftr_count; ++i )
	{
		CvMat rA, rB;
		d += cvNorm( cvGetRow( A, &rA, i ), cvGetRow( B, &rB, i ), CV_L2, 0 );
	}
	return d;
}


void gradLocalsRelease( struct cGradLocals ** gl )
{

	if( !gl ||!*gl ) return;

	if( (*gl)->gaussWnd ) wndPatchRelease( &(*gl)->gaussWnd );
	//if( (*gl)->gradWnd ) vplGllfGradDistRelease( &(*gl)->gradWnd );
	if( (*gl)->ftrs ) cvReleaseMat( &(*gl)->ftrs );
	if( (*gl)->ip ) imagePyrRelease( &(*gl)->ip );

	free( *gl );
	*gl = NULL;

	return;
}










