#ifndef _VPL_WND_PATCH_H_
#define _VPL_WND_PATCH_H_

#include "cv.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef struct cWndPatch
{
	CvMat * g;
	CvMat * p;
	CvMat * r;
	int size;
} cWndPatch;

struct cWndPatch * wndPatchCreate ( int size, double sigma );
int				   wndPatchRelease( struct cWndPatch ** wp );
CvMat *			   wndPatchGet( struct cWndPatch * wndPatch, CvMat * src, CvPoint c, double scale );
CvMat *			   wndPatchGetSubPix( struct cWndPatch * wndPatch, CvMat * src, CvPoint2D32f c, double scale );
CvMat *			   wndPatchRot( struct cWndPatch * wndPatch, double angle );
CvMat *			   wndPatchSubPixAdd( struct cWndPatch * wndPatch, CvMat * dst, CvPoint base, CvPoint2D32f offset, double angle, double scale );

#ifdef __cplusplus
}
#endif


#endif