#ifndef _FIND_RECT_H_
#define _FIND_RECT_H_

#include "cv.h"
#include <list>

struct s_Point
{
  float x,y;
};

struct s_Line
{
   float Alpha, R;
};


typedef std::list<s_Line> t_LineList;


float FindRectangle(IplImage *grey, CvPoint2D32f *Points, int Low, int High);




void ResizeTwice(unsigned char *source, unsigned char *dst, int Width, int Height);
// the final size of output image is twice smaller, rounded down

int LinesIntersection(s_Line *Line1, s_Line *Line2, CvPoint2D32f *Point);
// return intersection point [x,y]

float HypothesisTest(unsigned char *Image, int Width, int Height, CvPoint2D32f *Lines, int nr);
// compute coincidence of defined rectangle with binary image

class c_DetectRectangle
{

   t_LineList HorizontalLines;
   t_LineList VerticalLines;
   public:
   int Width, Height;
   int VerticalPoints, HorizontalPoints;
   void Init(int XSize, int YSize);
   void PutLine(float R, float Alpha, int Weight);
   void Sort();
   float FindRectangle(unsigned char *Image, int xsize, int ysize, CvPoint2D32f *BestA);
   float HypothesisTest(unsigned char *Image, int xsize, int ysize, CvPoint2D32f *Lines, int nr);
};


#endif