#ifndef _SLIDE_PARAMS_H_
#define _SLIDE_PARAMS_H_

#include "cv.h"
#include "vplgllfgraddist.h"
#include "vplWndPatch.h"
#include "highgui.h"

#ifdef __cplusplus
extern "C" {
#endif


// config params
typedef struct cSlideDetParams {
	int presentWidth;	        // width of the presentation image
	int presentHeight;	        // height of the presentation image
	CvPoint2D32f Points[4];		// points of the projection screen defined by rectangle
	
	// presentation detection
	int Low, High;
	int presentDetCount;
	CvMat * presentHomo;

	// slide changes
	int slideFrameStep;			// amount of frames between processed frames (e.g. 25 means that each 25th frame is processed)
	int slideDiffScale;
	int slideDiffBuff; 
	int slideDetWidth, slideDetHeight;

	float slideDiffThresh;
	float slideDistrThresh;

	// local feature extraction]
	float locWndOverlap;
	int   locWndSize;
	int localWidth, localHeight;

	float matchLimit;

	// gradient feature
	int gradBinSize;

} cSlideDetParams;



struct cSlideDetParams * slideDetParams( struct cSlideDetParams * params, char * config_file, struct ffMedia * video );
//struct cSlideDetParams * slideDetParams( struct cSlideDetParams * params, char * config_file, CvCapture * video );

void slideDetParamsRelease( struct cSlideDetParams ** params );

#ifdef __cplusplus
}
#endif



#endif