
#include "cv.h"


typedef struct cKMeanVoc 
{
	CvMat * center;
	CvMat * weight;
	int dim, count;
	int used;
} cKMeanVoc;

struct cKMeanVoc * kMeanVocCreate();
struct cKMeanVoc * kMeanVocInit( struct cKMeanVoc * kmv, int dim, int count );
void kMeanVocRelease( struct cKMeanVoc ** kmv );

struct cKMeanVoc * kMeanVocLoad( const char * filename );
int kMeanVocSave( struct cKMeanVoc * kmv, const char * filename );

int kMeanVocFindClosest( struct cKMeanVoc * kmv, CvMat * ftr, double * dist, int norm_type );
CvMat * kMeanVocBagOfWords( struct cKMeanVoc * kmv, CvMat * ftrs, CvMat * wrds, int norm_type );
CvMat * kMeanVocSetOfWords( struct cKMeanVoc * kmv, CvMat * ftrs, CvMat * wrds, int norm_type );
CvMat * kMeanVocTranslateToWords( struct cKMeanVoc * kmv, CvMat * ftrs, CvMat * wrds, int norm_type );

int kMeanVocEval( struct cKMeanVoc * kmv, CvMat * ftrs, int used, CvTermCriteria termcrit, CvMat ** map );
int kMeanVocUpdate( struct cKMeanVoc * kmv, CvMat * ftr, int i );
int kMeanVocAdd( struct cKMeanVoc * kmv, CvMat * ftr );


