
#include <stdio.h>
#include <stdlib.h>
#include "highgui.h"

#include "vplcore.h"
#include "vplSlides.h"
#include "slideParams.h"
#include "vplGradLocals.h"

#include <libxml/tree.h>



//struct cLocals * slideGetLocalOfType( struct cSlide * slide, int type )
//{
//	CvSeqReader locRdr;
//	int k;
//
//	cvStartReadSeq( slide->locals, &locRdr, 0 );
//	for( k = 0; k < slide->locals->total; ++k )
//	{
//		struct cLocals * loc = (struct cLocals *)locRdr.ptr;
//		if( loc->type == type ) return loc;
//		CV_NEXT_SEQ_ELEM( locRdr.seq->elem_size, locRdr );
//	}
//	return NULL;
//}



struct cSlides * slidesCreate( const char * videoSource, const char * origsSource )
{
	struct cSlides * sl = NULL;
	sl = (struct cSlides *)malloc(sizeof(struct cSlides));
	sl->storage = cvCreateMemStorage( 10000000 );
	sl->slides = cvCreateSeq( 0, sizeof(CvSeq), sizeof(struct cSlide), sl->storage );
	sl->matches = cvCreateSeq( 0, sizeof(CvSeq), sizeof(struct cSlide), sl->storage );
	sl->videoSource.ptr = NULL;
	sl->origsSource.ptr = NULL;
	if( videoSource ) sl->videoSource = cvMemStorageAllocString( sl->storage, videoSource, -1 );
	if( origsSource ) sl->origsSource = cvMemStorageAllocString( sl->storage, origsSource, -1 );
	return sl;
}



struct cSlides * slidesLoadXML( struct cSlides * slides, char * xmlpath )
{
	xmlDoc * cfgXmlDoc = NULL;
	xmlNode * cur_node = NULL, * cur_node_next = NULL;
	int id = 1000;
	char * tmp, * videoSource = NULL, * origsSource = NULL;
	cSlide * sll = NULL;

	__BEGIN__

	if( !xmlpath ) return slides;

	/* open XML configuraion file */
	cfgXmlDoc = xmlReadFile( xmlpath, NULL, 0 );
	if( !cfgXmlDoc ) EXIT;

	/* find appropriate node */
	cur_node = xmlDocGetRootElement( cfgXmlDoc );
	for( cur_node_next = cur_node->children; cur_node_next; cur_node_next = cur_node_next->next) 
		if( cur_node_next->type == XML_ELEMENT_NODE && xmlStrEqual( cur_node_next->name, BAD_CAST( "sources" ) ) )
		break;

	if( (cur_node = cur_node_next) )
	{
		for( cur_node_next = cur_node->children; cur_node_next; cur_node_next = cur_node_next->next) 
			if( cur_node_next->type == XML_ELEMENT_NODE && xmlStrEqual( cur_node_next->name, BAD_CAST( "video" ) ) )
				videoSource = (char *)xmlGetProp( cur_node_next, BAD_CAST( "src" ) );		
			else if( cur_node_next->type == XML_ELEMENT_NODE && xmlStrEqual( cur_node_next->name, BAD_CAST( "originals" ) ) )
				origsSource = (char *)xmlGetProp( cur_node_next, BAD_CAST( "src" ) );		
	}

	cur_node = xmlDocGetRootElement( cfgXmlDoc );
	for( cur_node_next = cur_node->children; cur_node_next; cur_node_next = cur_node_next->next) 
		if( cur_node_next->type == XML_ELEMENT_NODE && xmlStrEqual( cur_node_next->name, BAD_CAST( "slides" ) ) )
		break;

	if( (cur_node = cur_node_next) )
	{
		if( !slides ) slides = slidesCreate( videoSource, origsSource );

		for( cur_node_next = cur_node->children; cur_node_next; cur_node_next = cur_node_next->next) 
			if( cur_node_next->type == XML_ELEMENT_NODE && xmlStrEqual( cur_node_next->name, BAD_CAST( "slide" ) ) )
			{
				struct cSlide sl;
				int start = 0, end = 0;
				int idt;
				double confID = 0.0;
				
				tmp = (char *)xmlGetProp( cur_node_next, BAD_CAST( "id" ) );		
				if( tmp ) idt = atoi( tmp );
				else idt = id++;

				tmp = (char *)xmlGetProp( cur_node_next, BAD_CAST( "start" ) );		
				if( tmp ) start = atoi( tmp );
				tmp = (char *)xmlGetProp( cur_node_next, BAD_CAST( "end" ) );		
				if( tmp ) end = atoi( tmp );
				tmp = (char *)xmlGetProp( cur_node_next, BAD_CAST( "confidence" ) );		
				if( tmp ) confID = atof( tmp );

				if( start <= 0 && sll && sll->time.y > 0 ) start = sll->time.y + 1;
				if( sll && sll->time.y <= 0 && start > 0 ) sll->time.y = start - 1;
				
				sl = slideInit( idt, (char *)xmlGetProp( cur_node_next, BAD_CAST( "src" ) ), cvPoint( start, end ), confID, slides->storage );
				sll = (struct cSlide *)cvSeqPush( slides->slides, &sl );

				tmp = (char *)xmlGetProp( cur_node_next, BAD_CAST( "match_id" ) );
				if( tmp )
				{
					idt = atoi( tmp );
					sl = slideInit( idt, (char *)xmlGetProp( cur_node_next, BAD_CAST( "match_src" ) ), cvPoint( 0, 0 ), 0.0, slides->storage );
					sll->match = (struct cSlide *)cvSeqPush( slides->matches, &sl );
				}

			}
	}

	/* release XML parsing structures */
	__END__
	if( cfgXmlDoc ) xmlFreeDoc( cfgXmlDoc );
	xmlCleanupParser();
	
	return slides;
}

int slidesSaveXml( struct cSlides * slides, const char * xmlpath )
{
	CvSeqReader slRdr;
	xmlDocPtr doc = NULL;
	xmlNodePtr sub_node = NULL, cur_node = NULL, root = NULL;
	char buff[1024];
	int i;

	CV_FUNCNAME( "slidesSaveToXmlNode" );
	__BEGIN__

	if( !slides || !slides->slides )
		return -1;

	if( !(doc = xmlNewDoc((const xmlChar*)"1.0") ) ) return -1;
	if( !(root = xmlNewDocNode(doc, NULL, (const xmlChar*)"data", NULL ) ) ) { fprintf( stderr, "Error: Cannot create DOC root node.\n" ); EXIT; }

	xmlDocSetRootElement( doc, root );

	cur_node = xmlNewChild( root, NULL, (const xmlChar*)"sources", NULL );
	if( slides->videoSource.ptr )
	{
		sub_node = xmlNewChild( cur_node, NULL, (const xmlChar*)"video", NULL );
		xmlSetProp( sub_node, (const xmlChar*)"src", (const xmlChar*)slides->videoSource.ptr );
	}
	if( slides->origsSource.ptr )
	{
		sub_node = xmlNewChild( cur_node, NULL, (const xmlChar*)"originals", NULL );
		xmlSetProp( sub_node, (const xmlChar*)"src", (const xmlChar*)slides->origsSource.ptr );
	}

	// report slide change info
	cur_node = xmlNewChild( root, NULL, (const xmlChar*)"slides", NULL );
	//xmlSetProp( cur_node, (const xmlChar*)"root", (const xmlChar*)slides->root.ptr );

	cvStartReadSeq( slides->slides, &slRdr, 0 );
	for( i = 0; i < slides->slides->total; ++i )
	{
		struct cSlide * sl = (struct cSlide *)slRdr.ptr;
		CV_NEXT_SEQ_ELEM( slRdr.seq->elem_size, slRdr );

		sub_node = xmlNewChild( cur_node, NULL, (const xmlChar*)"slide", NULL );
		sprintf( buff, "%d", sl->id );
		xmlSetProp( sub_node, (const xmlChar*)"id", (const xmlChar*)buff );
		sprintf( buff, "%d", sl->time.x );
		xmlSetProp( sub_node, (const xmlChar*)"start", (const xmlChar*)buff );
		sprintf( buff, "%d", sl->time.y );
		xmlSetProp( sub_node, (const xmlChar*)"end", (const xmlChar*)buff );
		sprintf( buff, "%f", sl->confID );
		xmlSetProp( sub_node, (const xmlChar*)"confidence", (const xmlChar*)buff );
		if( sl->source.ptr )
			xmlSetProp( sub_node, (const xmlChar*)"src", (const xmlChar*)sl->source.ptr );

		if( sl->match )
		{
			sprintf( buff, "%d", sl->match->id );
			xmlSetProp( sub_node, (const xmlChar*)"match_id", (const xmlChar*)buff );
			if( sl->match->source.ptr )
				xmlSetProp( sub_node, (const xmlChar*)"match_src", (const xmlChar*)sl->match->source.ptr );
		}
	}

	if( !xmlSaveFormatFile( xmlpath, doc, 1 ) ) fprintf( stderr, "Error: Cannot save XML file.\n" );
       
	__END__
	if( doc ) xmlFreeDoc(doc);

	return 1;
}

/* a < b ? -1 : a > b ? 1 : 0 */
static int slides_cmp_id( const void* _a, const void* _b, void* userdata)
{
	struct cSlide * a = (struct cSlide *)_a;
	struct cSlide * b = (struct cSlide *)_b;
	return ( a->id < b->id ? -1 : ( a->id > b->id ? 1 : 0 ) );
}	


int slidesGetByID( struct cSlides * slides, int id )
{
	struct cSlide * sl = NULL;
	int idx;
	sl = (struct cSlide *)cvSeqSearch( slides->slides, &id, slides_cmp_id, 0, &idx, NULL );
	return idx;
}



//int slidesFindClosest( struct cSlides * slides, int type, CvMat * ftr, double * dist )
//{
//	CvSeqReader slRdr;
//	CvSeqReader locRdr;
//	double d, miv = 1000000000.;
//	int i, k, imiv = -1;
//
//	cvStartReadSeq( slides->slides, &slRdr, 0 );
//	for( i = 0; i < slides->slides->total; ++i )
//	{
//		struct cSlide * sl = (struct cSlide *)slRdr.ptr;
//		CV_NEXT_SEQ_ELEM( slRdr.seq->elem_size, slRdr );
//
//		cvStartReadSeq( sl->locals, &locRdr, 0 );
//		for( k = 0; k < sl->locals->total; ++k )
//		{
//			struct cLocals * loc = (struct cLocals *)locRdr.ptr;
//			CV_NEXT_SEQ_ELEM( locRdr.seq->elem_size, locRdr );
//			if( loc->type != type ) continue;
//			 
//			// compute the distance
//			d = cvNorm( ftr, &loc->ftrs, CV_L2, 0 );
//			printf( "%f, ", d );
//			if( d < miv ) { miv = d; imiv = i; }
//		}
//
//	}
//
//	if( dist ) *dist = d;
//	return imiv;
//}


//int slidesFindClosest2( struct cSlides * slides, int type, CvMat * ftr, double * dist, LocalsDistance func )
//{
//	CvSeqReader slRdr;
//	CvSeqReader locRdr;
//	double d, miv = 1000000000.;
//	int i, k, imiv = -1;
//
//	cvStartReadSeq( slides->slides, &slRdr, 0 );
//	for( i = 0; i < slides->slides->total; ++i )
//	{
//		struct cSlide * sl = (struct cSlide *)slRdr.ptr;
//		CV_NEXT_SEQ_ELEM( slRdr.seq->elem_size, slRdr );
//
//		cvStartReadSeq( sl->locals, &locRdr, 0 );
//		for( k = 0; k < sl->locals->total; ++k )
//		{
//			struct cLocals * loc = (struct cLocals *)locRdr.ptr;
//			CV_NEXT_SEQ_ELEM( locRdr.seq->elem_size, locRdr );
//			if( loc->type != type ) continue;
//			 
//			// compute the distance
//			d = func( ftr, &(loc->ftrs), NULL );
//			printf( "%f, ", d );
//			if( d < miv ) { miv = d; imiv = i; }
//		}
//
//	}
//
//	if( dist ) *dist = d;
//	return imiv;
//}




int slidesFindClosestWeightedVoting( CvSeq * gradFtrs, CvMat * ftr, double * confidence, CvMat ** distances )
{
	CvSeqReader slRdr;
	double val;
	int iw, i, imiv = -1;
	CvPoint best;
	CvMat * hist = NULL, * dist = NULL, distC, _hist;
	
	if( distances )
		hist = *distances;
	if( !hist ) hist = cvCreateMat( 1, gradFtrs->total, CV_32FC1 );
	if( distances )
		*distances = hist;
	hist = cvReshape( hist, &_hist, 1, gradFtrs->total );

	dist = cvCreateMat( gradFtrs->total, ftr->rows, CV_32FC1 );		// distances between query and patterns windows - rows: patterns, cols: query windows
	cvZero( hist );

	//printf( "Query Slide:\n" ); cvMatPrint( ftr, NULL );  printf( "\n" );

	// compute distances
	cvStartReadSeq( gradFtrs, &slRdr, 0 );
	for( i = 0; i < gradFtrs->total; ++i )
	{
		CvMat fsm = cvMat( ftr->rows, ftr->cols, CV_32FC1, (float *)cvGetSeqElem( gradFtrs, i ) );
		CvMat fq, fs, distR;

		//printf( "\nSlide:\n" ); cvMatPrint( fsm, NULL ); printf( "\n\n" );

		cvGetRow( dist, &distR, i );
		for( iw = 0; iw < ftr->rows; ++iw )
		{
			distR.data.fl[iw] = (float)cvNorm( cvGetRow( ftr, &fq, iw ), cvGetRow( &fsm, &fs, iw ), CV_L2, 0 );
			//printf( "Slide[%d]:Wnd[%d]: Q: ", i, iw ); cvMatPrint( &fq, NULL );
			//printf( "Slide[%d]:Wnd[%d]: S: ", i, iw ); cvMatPrint( &fs, NULL );
			//printf( "Slide[%d]:Wnd[%d]: D: %f\n", i, iw, distR.data.fl[iw] );
		}

		CV_NEXT_SEQ_ELEM( slRdr.seq->elem_size, slRdr );
	}
	
	//printf( "\nDistances:\n" ); cvMatPrint( dist, NULL ); printf( "\n" );
	for( iw = 0; iw < ftr->rows; ++iw )
	{
		double weight;

		cvGetCol( dist, &distC, iw );

		// find closest (best) candidate
		cvMinMaxLoc( &distC, &val, &weight, NULL, NULL, NULL );
		if( val >= 0.3 ) continue;

		// remove all cadidates further than 90% of the best distance
		cvThreshold( &distC, &distC, 1.1*val, 1, CV_THRESH_BINARY_INV );
		//cvThreshold( &distC, &distC, 0.5, 1, CV_THRESH_BINARY_INV );
		//cvConvert( &distC, mask );

		// count the number of candidates
		weight = (int)cvCountNonZero( &distC );
		//printf( "% 5d % 5d\n", (int)cvCountNonZero( cand ), (int)cvSum( cand ).val[0] );

		// update probablity of voting candidates
		cvAddWeighted( &distC, (weight>0.?1./weight:0.), hist, 1., 0.0, hist );

	}

	//printf( "\nDistances:\n" ); cvMatPrint( dist, NULL ); printf( "\n" );
	//printf( "\nHIST:\n" ); cvMatPrint( hist, NULL ); printf( "\n" );

	// find the strongest candidate
	cvMinMaxLoc( hist, NULL, confidence, NULL, &best, NULL );
	//cvReshape( hist, &distC, 1, 1 );

	//showGraph( "Hist",  &distC, 300, 500 );
	//if( accum ) cvAdd( &distC, accum, accum, 0 );

	//if( hist ) cvReleaseMat( &hist );
	if( dist ) cvReleaseMat( &dist );

	return best.y;
}


int slidesFindClosestWeightedVoting2( struct CvFeatureTree * kd, CvMat * ftrsP, CvMat * ftrQ, int docs_count, double * confidence )
{
	int i, q;
	CvPoint best1;
	double d1;
	CvMat * cand1 = NULL;
	CvMat * hist1 = NULL, * dist1 = NULL, * labe1 = NULL, * dist11 = NULL;
	CvMat * hist2 = NULL, * dist2 = NULL, * labe2 = NULL;
	int k = 1;


	cand1 = cvCreateMat( 1, docs_count, CV_32FC1 );		// distances
	hist1 = cvCreateMat( 1, docs_count, CV_32FC1 );
	dist1 = cvCreateMat( 1, ftrsP->rows, CV_64FC1 );
	dist11= cvCreateMat( 1, ftrQ->rows, CV_64FC1 );
	labe1 = cvCreateMat( 1, ftrQ->rows,  CV_32SC1 );
	cvZero( hist1 );

	for( q = 0; q < ftrQ->rows; ++q )
	{
		CvMat fq, fp;
		double weight;

		cvGetRow( ftrQ, &fq, q );
		cvZero( cand1 );

		// compute distances
		for( i = 0; i < ftrsP->rows; ++i )
		{
			dist1->data.db[i] = cvNorm( cvGetRow( ftrsP, &fp, i ), &fq, CV_L2, 0 );
			if( dist1->data.db[i] < 0.1 ) 
				cand1->data.fl[i/ftrQ->rows] += 1.;
		}
		showProgress( "Progress", "Matching: ", (1.*q)/(ftrQ->rows), 35,500 );

		//printf( "\nDistances:\n" ); cvMatPrint( cand, NULL ); printf( "\n" );
		cvMinMaxLoc( dist1, &weight, NULL, &best1, NULL, NULL );
		dist11->data.db[q] = weight;
		labe1->data.i[q]   = best1.x;

		// count the number of candidates
		weight = cvSum( cand1 ).val[0];
		//printf( "% 5d % 5d\n", (int)cvCountNonZero( cand ), (int)cvSum( cand ).val[0] );
		

		// update probablity of voting candidates
		cvAddWeighted( cand1, (weight>0.?1./weight:0.), hist1, 1., 0.0, hist1 );
	}

	//printf( "\nHIST:\n" ); cvMatPrint( hist, NULL ); printf( "\n" );

	// find the strongest candidate
	cvMinMaxLoc( hist1, NULL, &d1, NULL, &best1, NULL );


	labe2 = cvCreateMat( ftrQ->rows, k, CV_32SC1 );
	dist2 = cvCreateMat( ftrQ->rows, k, CV_64FC1 );
	hist2 = cvCreateMat( 1, docs_count, CV_32FC1 );
	cvZero( hist2 );
	cvFindFeatures( kd, ftrQ, labe2, dist2, k, 20 );
	for( i = 0; i < ftrQ->rows; ++i )
	{
		printf( "D1[% 6d:% 8.5f] D2[% 6d:% 8.5f]\n", labe1->data.i[i], dist11->data.db[i], labe2->data.i[i], dist2->data.db[i] );
		//for( j = 0; j < k; ++j )
		//{
		//	if( dist2->data.db[i*k+j] < 0.1 ) 
		//		hist2->data.fl[ cvFloor(1.*labe2->data.i[i*k+j]/ftrQ->rows) ] += 1.;
		//}
	}
	// find the strongest candidate
	//cvMinMaxLoc( hist2, NULL, &d2, NULL, &best2, NULL );


	if( hist1 ) cvReleaseMat( &hist1 );
	if( cand1 ) cvReleaseMat( &cand1 );
	if( dist1 ) cvReleaseMat( &dist1 );

	if( hist2 ) cvReleaseMat( &hist2 );
	if( dist2 ) cvReleaseMat( &dist2 );
	if( labe2 ) cvReleaseMat( &labe2 );

	return best1.x;
}


int slidesFindClosestWeightedVoting3( struct CvFeatureTree * kd, CvMat * ftr, int docs_count, double * confidence )
{
	int i, j;
	CvPoint best;
	CvMat * hist = NULL, * dist = NULL, * labels = NULL;
	int k = 10;

	labels = cvCreateMat( ftr->rows, k, CV_32SC1 );
	dist   = cvCreateMat( ftr->rows, k, CV_64FC1 );

	cvFindFeatures( kd, ftr, labels, dist, k, 20 );

	hist = cvCreateMat( 1, docs_count, CV_32FC1 );
	cvZero( hist );

	for( i = 0; i < ftr->rows; ++i )
	{
		for( j = 0; j < k; ++j )
			if( dist->data.db[i*k+j] < 0.2 ) 
				hist->data.fl[ labels->data.i[i*k+j]/ftr->rows ] += 1.;
	}
	//printf( "\nHIST:\n" ); cvMatPrint( hist, NULL ); printf( "\n" );

	//showGraph( "HIST", hist, 400, 700 );	if( cvWaitKey( 0 ) == 27 ) exit(1);

	// find the strongest candidate
	cvMinMaxLoc( hist, NULL, confidence, NULL, &best, NULL );
	*confidence /= ftr->rows;

	if( hist ) cvReleaseMat( &hist );
	if( dist ) cvReleaseMat( &dist );
	if( labels ) cvReleaseMat( &labels );

	return best.x;
}




//void slidesPrintLocsOfType( struct cSlides * slides, int type )
//{
//	CvSeqReader slRdr;
//	CvSeqReader locRdr;
//	int i, k;
//	CvMat tmp;
//
//	cvStartReadSeq( slides->slides, &slRdr, 0 );
//	for( i = 0; i < slides->slides->total; ++i )
//	{
//		struct cSlide * sl = (struct cSlide *)slRdr.ptr;
//		CV_NEXT_SEQ_ELEM( slRdr.seq->elem_size, slRdr );
//
//		cvStartReadSeq( sl->locals, &locRdr, 0 );
//		for( k = 0; k < sl->locals->total; ++k )
//		{
//			struct cLocals * loc = (struct cLocals *)locRdr.ptr;
//			CV_NEXT_SEQ_ELEM( locRdr.seq->elem_size, locRdr );
//			if( loc->type != type ) continue;
//			 
//			// print
//			printf( "ID[%d]: ", loc->srcID );
//			cvMatPrint( cvReshape( &(loc->ftrs), &tmp, 0, 1 ), NULL );
//		}
//
//	}
//}


void slidesPrint( struct cSlides * slides )
{
	CvSeqReader slRdr;
	int i;

	cvStartReadSeq( slides->slides, &slRdr, 0 );
	for( i = 0; i < slides->slides->total; ++i )
	{
		struct cSlide * sl = (struct cSlide *)slRdr.ptr;
		CV_NEXT_SEQ_ELEM( slRdr.seq->elem_size, slRdr );
		printf( "id[%d] start[%d] end[%d] source[%s]\n", sl->id, sl->time.x, sl->time.y, sl->source.ptr );
	}
}



void slidesRelease( struct cSlides ** slides )
{
	struct cSlides * sl;

	if( !slides || !*slides ) return;

	sl = *slides;
	cvReleaseMemStorage( &sl->storage );
	free( sl );
	*slides = NULL;

	return;
}


struct cSlide * slidesRemoveNeighbourDuplicates(  struct cSlides * slides )
{
	int i;
	struct cSlide * sl0, * sl1; 
	if( !slides ) return NULL;

	for( i = 0; i < slides->slides->total; i++ )
	{
		sl1 = (struct cSlide *)cvGetSeqElem( slides->slides, i );
		if( i == 0 ) { sl0 = sl1; continue; }
		if( !sl0->match || !sl1->match ) { sl0 = sl1; continue; }
		if( sl0->match->id != sl1->match->id ) { sl0 = sl1; continue; }
		if( sl1->time.x - sl0->time.y  >  1 ) 
		{ 
			printf( "Error: slides should be stored consequently with no gaps!\n" ); 
			sl0 = sl1; continue;  
		}

		sl0->time.x = MIN( sl0->time.x, sl1->time.x );
		sl0->time.y = MAX( sl0->time.y, sl1->time.y );
		cvSeqRemove( slides->slides, i );

		//  !!!!!!!!!!!!!!!!!!!!!
		--i;						
	}
	if( slides->slides->total > 0 )
		return (struct cSlide *)cvGetSeqElem( slides->slides, slides->slides->total-1 );
	return NULL;
}




void slideShow( struct cSlides * slides,  int i, const char * wndname, struct cSlideDetParams * params, char * storepath )
{
	struct cSlide * slide = (struct cSlide *)cvGetSeqElem(slides->slides, i);
	CvMat * grayFrameProcess = NULL;
	CvMat * slideImage = NULL;
	slideImage = cvLoadImageM( concat( storepath, strsub( slide->source.ptr, '/', -1, 0, NULL ), NULL ), 1 );
	if( !slideImage ) return;
	if( params ) 
	{
		grayFrameProcess = imagePreprocForGrad( slideImage, grayFrameProcess, params );
		cvShowImage( wndname, grayFrameProcess );
		cvReleaseMat( &grayFrameProcess );
	}
	else
		cvShowImage( wndname, slideImage );
	cvReleaseMat( &slideImage );
	return;
}



CvMat * imagePreprocForGrad( CvArr * image, CvMat * dst, struct cSlideDetParams * params )
{
	CvMat * gray = NULL;
    CvMat tmp, *src = (CvMat*)image;
	int i;
	double sigmaX, sigmaY;

	if( !image || !( dst || params ) ) return dst;

	src = cvGetMat( image, &tmp, &i, 0 );
	//if( !dst ) dst = cvCreateMat( (params->presentHeight)>>(params->slideDiffScale), (params->presentWidth)>>(params->slideDiffScale), CV_8UC1 );
	if( !dst ) dst = cvCreateMat( (params->localHeight), (params->localWidth), CV_8UC1 );

	sigmaX = 1.0*src->cols/params->localWidth;
	sigmaY = 1.0*src->rows/params->localHeight;

	if( CV_MAT_CN(src->type) == 1 )
	{
		cvSmooth( src, src, CV_GAUSSIAN, 0, 0, sigmaX, sigmaY );
		cvResize( src, dst, CV_INTER_NN );
	} 
	else if( CV_MAT_CN(src->type) == 3 )
	{
		gray = cvCreateMat( src->rows, src->cols, CV_8UC1 );
		cvCvtColor( src, gray, CV_BGR2GRAY );
		cvSmooth( gray, gray, CV_GAUSSIAN, 0, 0, sigmaX, sigmaY );
		cvResize( gray, dst, CV_INTER_NN );
		cvReleaseMat( &gray );
	} else
		cvZero( dst );

	return dst;
}

CvSeq * slidesExtractFeaturesGrad( struct cSlides * slides, struct cGradLocals * GL, struct cSlideDetParams * params, CvSeq * gradFtrs, char * storepath )
{
	int i;
	int dims, counts;
	CvMat * grayFrameProcess = NULL;
	
	if( !params || !slides || !GL ) return gradFtrs;
	
	// init feature sequence
	if( gradFtrs ) cvClearMemStorage( gradFtrs->storage );
	if( slides->slides->total <= 0 ) return NULL;

	counts = gradLocalsCount( GL, params->localHeight, params->localWidth, -1, 0, 0, 0 );
	dims   = gradLocalsDims( GL );
	gradFtrs = cvCreateSeq( 0, sizeof(CvSeq), sizeof(float)*dims*counts, cvCreateChildMemStorage( slides->storage ) );
	cvSetSeqBlockSize( gradFtrs, slides->slides->total );
	cvSeqPushMulti( gradFtrs, NULL,  slides->slides->total, 0 );

	for( i = 0; i < slides->slides->total; ++i )
	{
		struct cSlide * slide = (struct cSlide *)cvGetSeqElem(slides->slides,i);
		CvMat * slideImage = cvLoadImageM( slide->source.ptr, 1 );
		CvMat ftrs = cvMat( counts, dims, CV_32FC1, (float *)cvGetSeqElem( gradFtrs, i ) );
		cvZero( &ftrs );

		if( !slideImage ) continue;
		grayFrameProcess = imagePreprocForGrad( slideImage, grayFrameProcess, params );
		cvReleaseMat( &slideImage );

		// process gradient extractor
		gradLocalsEval( GL, grayFrameProcess, &ftrs );

		#ifdef DEBUG
		printf( "Slides feature extraction: %d / %d                \r", i, slides->slides->total );
		#endif
		if( storepath && strlen(storepath) > 0 ) cvSaveImage( concat(storepath, strsub( slide->source.ptr, '/', -1, 0, NULL ), NULL ), grayFrameProcess, 0 );		
		{ showProgress( "Progress", "Feature Extraction: ", 1.*i/slides->slides->total, 35,500 ); if( cvWaitKey( 10 ) == 27 ) exit(1);}

	}
	#ifdef DEBUG
	printf( "\n" );
	#endif

	if( grayFrameProcess ) cvReleaseMat( &grayFrameProcess );
	cvDestroyWindow( "Progress" );

	return gradFtrs;
}







