/**
 * feature extractors
 */

// C++ headers
#include <iostream>
#include <string>
#include <fstream>

// OpenCV 2 header
#include <opencv/cv.h>

// user headers
// #include "colorextraction.h"
// #include "textureextraction.h"
#include "vpl/vplgllfgraddist.h"
#include "vpl/vplgllf2dgridhist.h"
#include "cvffmpeg/abbrevs.h"
#include "cvffmpeg/cvffmpeg.h"

using namespace std;

// /**
//  * ColorLayout
//  */
// int fe_color(IplImage * iin, vector<int> &out)
// {
// 	//variables
// 	IplImage * src = iin;
// 
// 	//feat_extractor init
// 	ColorExtraction* cle = new ColorExtraction (src->width, src->height);
// 
// 	for (int y = 0; y < src->height; y++) {      // rows
// 		// source
// 		byte* cvRow = (byte*)(src->imageData + y*src->widthStep);
// 		// Y image
// 		//byte* pimg = (byte*)(ymage + y*src->width);
// 		// BGR images
// 		byte* pb = (byte*)(cle->ib + y*cle->width);
// 		byte* pg = (byte*)(cle->ig + y*cle->width);
// 		byte* pr = (byte*)(cle->ir + y*cle->width);
// 		// go through pixels
// 		for (int x = 0; x < src->width; x++) { // cols
// 			//pimg[x] = (byte)(( (  (int)66 * cvRow[3*x + 2] + 129 * cvRow[3*x + 1] +  25 * cvRow
// 			// yntensity(cvRow, [3*x]);
// 			pb[x] = cvRow[3*x    ];
// 			pg[x] = cvRow[3*x + 1];
// 			pr[x] = cvRow[3*x + 2];
// 		}
// 	}
// 
// 	//do extraction
// 	cle->FeatureExtraction();
// 
// 	//store results
// 	for(int i=1;i < YCOEFS;i++)
// 	{
// 		out.push_back((unsigned int)cle->cy[i]);
// 	}
// 	for(int i=1;i < UVCOEF;i++)
// 	{
// 		out.push_back((unsigned int)cle->cu[i]);
// 	}
// 	for(int i=1;i < UVCOEF;i++)
// 	{
// 		out.push_back((unsigned int)cle->cv[i]);
// 	}
// 
// 	//feat extractor deinit
// 	delete cle;
// }
// 
// /**
//  * Gabor
//  */
// int fe_gabor(IplImage * iin, vector<int> &out)
// {
// 	//variables
// 	IplImage * src = iin;
// 	byte *ymage=NULL;
// 		
// 	//feat_extractor init
// 	TextureExtraction texturator;
// 	int feature_vector[31]; // 62
// 	texturator.image_height = src->width;
// 	texturator.image_width = src->height;
// 	
// 	ymage = (unsigned char *) malloc(src->width*src->height*8);
// 	for (int y = 0; y < src->height; y++) {      // rows
// 		// source
// 		byte* cvRow = (byte*)(src->imageData + y*src->widthStep);
// 		// Y image
// 		byte* pimg = (byte*)(ymage + y*src->width);
// 
// 		// go through pixels
// 		for (int x = 0; x < src->width; x++) { // cols
// 		pimg[x] = (byte)(( (  (int)66 * cvRow[3*x + 2] + 129 * cvRow[3*x + 1] +  25 * cvRow[3*x + 2] + 128 ) >> 8) +  16);
// 		// yntensity(cvRow, [3*x]);
// 		//pb[x] = cvRow[3*x    ];
// 		//pg[x] = cvRow[3*x + 1];
// 		//pr[x] = cvRow[3*x + 2];
// 		}
// 	}
// 
// 	//do extraction
// 	texturator.FeatureExtraction((byte *)ymage);
// 
// 	feature_vector[0] = texturator.m_dc;
// 	// feature_vector[31] = extractor.m_std;
// 	for(int i = 0; i < 5; i++) {                    // 5 scales
// 		for(int j = 0; j < 6; j++) {                // 6 orientations
// 		feature_vector[i*6+j+1] = texturator.mean2[i][j];
// 		// feature_vector[i*6+j+1+31] = texturator.dev2[i][j];
// 		}
// 	}
// 
// 	for(int i=0;i<31;i++)
// 	{
// 		out.push_back((unsigned int)(feature_vector[i]));
// 	}
// 
// 	free(ymage);
// }

/**
 * Grad
 */
int fe_grad(IplImage * iin, vector<int> &out)
{
	//variables
	CvMat * gray = NULL;

	//feat_extractor init
	// initialize Gradient Distribution
	int pyramids = 4;
	int hist_bins = 16;
	struct VplGllfGradDist * GD = vplGllfGradDistInit( NULL, pyramids, hist_bins , 1);
	CvMat * featureGD = cvCreateMat( 1, vplGllfGradDistGetSize( GD ), VPL_DATA_MAT_TYPE );

	gray = cvCreateMat( iin->height, iin->width, CV_8UC1 );
	cvCvtColor( iin, gray, CV_BGR2GRAY );

	// extract GradDist feature 
	vplGllfGradDistExtract( GD, gray, featureGD );
	for(int i=0;i<featureGD->cols;i++)
		out.push_back( (unsigned int)(featureGD->data.fl[i]*100000.0) );

	//feat extractor deinit
	vplGllfGradDistRelease( &GD );
	cvReleaseMat( &featureGD );
	cvReleaseMat( &gray );
}

/**
 * Color
 */
int fe_hist(IplImage * iin, vector<int> &out)
{
	//variables
	IplImage * src = iin;
	CvMat * h_plane, * s_plane, * v_plane, * hsv = NULL, * gray = NULL;

	//feat_extractor init
	int dims = 2;
	int hist_size[] = {9, 5};
	float h_ranges[] = { 0, 180 }; // hue varies from 0 (~0red) to 180 (~360red again)
	float s_ranges[] = { 0, 255 }; // saturation varies from 0 (black-gray-white) to 255 (pure spectrum color)
	float* ranges[] = { h_ranges, s_ranges };
	struct VplGllf2DGridHist * GH = vplGllf2DGridHistInit( NULL, cvSize(4,3), (float)1.2, dims, hist_size, ranges );
	CvMat * featureGH = cvCreateMat( 1, vplGllf2DGridHistGetSize( GH ), VPL_DATA_MAT_TYPE );

	h_plane = cvCreateMat( src->height, src->width, CV_8UC1 );
	s_plane = cvCreateMat( src->height, src->width, CV_8UC1 );
	v_plane = cvCreateMat( src->height, src->width, CV_8UC1 );
	hsv     = cvCreateMat( src->height, src->width, CV_8UC3 );

	// extract GradDist feature 
	cvCvtColor( src, hsv, CV_BGR2HSV );
	cvCvtPixToPlane( hsv, h_plane, s_plane, v_plane, 0 );
	CvMat * planes[] = { h_plane, s_plane };
	vplGllf2DGridHistExtract( GH, planes, featureGH );

	for(int i=0;i<featureGH->cols;i++)
		out.push_back( (unsigned int)(featureGH->data.fl[i]*100000.0) );

	//feat extractor deinit
	vplGllf2DGridHistRelease( &GH );
	cvReleaseMat( &featureGH );
	cvReleaseMat( &h_plane );
	cvReleaseMat( &s_plane );
	cvReleaseMat( &v_plane );
	cvReleaseMat( &hsv );
}

/**
 * All, extracts all and concatenates results to one long feature vector
 */
int fe_all(IplImage * iin, vector<int> &out)
{
	//fe_color(iin, out);
	//fe_gabor(iin, out);
	fe_grad(iin, out);
	fe_hist(iin, out);

	return 0;
}

/**
 * extracts and returns one feature vector from given frame
 */
int extract_feature_from_frame( IplImage *frame, int frame_number, const char *feature_name, vector<int> &feature_vector )
{
	if ( !strcmp( feature_name, "ColorLayout" ) )
	{
		fprintf(stderr, "This function is not currently availeble\n");
		//return fe_color( frame, feature_vector );
	}
	if ( !strcmp( feature_name, "Color" ) )
		return fe_hist( frame, feature_vector );
	if ( !strcmp( feature_name, "Gabor" ) )
	{
		//return fe_gabor( frame, feature_vector );
		fprintf(stderr, "This function is not currently availeble\n");
	}
	if ( !strcmp( feature_name, "Grad" ) )
		return fe_grad( frame, feature_vector );
	if ( !strcmp( feature_name, "All" ) )
		return fe_all( frame, feature_vector );

	cerr << "Unknown feature" << endl;

	return 1;
}

/**
 * extracts one feature vector from each video frame and writes it into corresponding file
 */
int extract_feature_from_video( const char *video_file_name, const char *feature_name )
{
	string output_file( video_file_name );
	output_file.append( "." );
	output_file.append( feature_name );

	// cerr << "debug: video=" << video_file_name << " feature=" << feature_name << " output_file=" << output_file << endl;

	// open output file
	ofstream output( output_file.c_str() );

	// open video
	CvCapture *capture = cvCaptureFromFile( video_file_name );

	// loop
	IplImage *frame;
	int frame_number = 0;
	while ( frame = cvQueryFrame( capture ) )
	{
		vector<int> feature_vector;

		extract_feature_from_frame( frame, frame_number, feature_name, feature_vector );

		output << frame_number;

		vector<int>::iterator it;
		for ( it=feature_vector.begin() ; it < feature_vector.end(); it++ )
			output << ", " << *it;

		output << endl;

		frame_number++;	
	}

	return 0;
}

/**
 * program entry function
 */
int main_( int argc, const char *argv[] )
{
	if( argc < 2 || argc > 3 )
	{
		cerr << "usage: " << argv[0] << " [-ColorLayout|-Color|-Gabor|-Grad|-All] video" << endl;
		return 1;
	}

	// call this function recursively (for each feature type)
	if( argc == 2 )
	{
		const char *argv_[4];
		argv_[0] = argv[0];
		argv_[2] = argv[1];
		argv_[3] = 0;
		argv_[1] = "-ColorLayout";
		main_(3, argv_);
		argv_[1] = "-Color";
		main_(3, argv_);
		argv_[1] = "-Gabor";
		main_(3, argv_);
		argv_[1] = "-Grad";
		main_(3, argv_);
		return 0;
	}

	if( argv[1][0] != '-' )
		cerr << "Wrong syntax" << endl;

	return extract_feature_from_video( argv[2], argv[1]+1 );
}

int main( int argc, const char *argv[] )
{
	return main_( argc, argv );
}
