///////////////////////////////////////////////////////////////////////////////
// $Id: CDecimator.h 636 2009-11-13 10:05:16Z krsek $
//
// Copyright (c) 2008 by 3Dim Laboratory s.r.o.
//
///////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// Header file for CDecimator class

#ifndef CDecimator_H
#define CDecimator_H

////////////////////////////////////////////////////////////
// Includes

#include <VectorEntity/mctris.h>

// MDSTk
#include <MDSTk/Module/mdsSerializable.h>
#include <MDSTk/Module/mdsProgress.h>

// STL
#include <vector>

////////////////////////////////////////////////////////////
//! Tri mesh decimating algorithm implementation class.
//! Implements Volume error metrics polygonal surface simplification.

class CDecimator : public mds::mod::CProgress
{
public:
    //! Decimating class constructor.
    CDecimator() {}

    //! Decimating class destructor.
    ~CDecimator() {}

    //! Reduce input tri mesh using Volume error metrics polygonal surface simplification.
    bool Reduce(vctl::MCTriS & tris, int final_tri_number);

private:
    //! Evaluate all edges of input tri mesh by error volume and sort them.
    bool EvaluateAllEdgesVolume(vctl::MCTriS & tris);

    //! Evaluate input edge by shared tris volume.
    void EvaluateEdgeVolume(vctl::MCTriS & tris, vctl::MCEdge * evaluated_edge);

    //! Test input tris groups for possible edge collapse duplicities.
    //! @return Return true then duplicities exists and false then there are no duplicities.
    bool TestCollapseDuplicities(std::vector<vctl::MCTri *> & tri_u0, std::vector<vctl::MCTri *> & tri_u1, std::vector<vctl::MCTri *> & tri_edge);

    //! Calculate volume of input collapse parameters.
    double EvaluateCollapse(vctl::MCVertex * u0, vctl::MCVertex * u1, std::vector<vctl::MCTri *> & tri_u0, std::vector<vctl::MCTri *> & tri_u1, vctl::MCVertex * new_vertex);

    //! Make input edge collapse, organise and prepare the collapse.
    vctl::MCVertex * CollapseEdge(vctl::MCTriS & tris, vctl::MCEdge * collapsed_edge);

    //! Make edge collapse on input tri mesh, realize entity cleaning
    void MakeCollapse(vctl::MCTriS & tris, vctl::MCVertex * u0, vctl::MCVertex * u1, std::vector<vctl::MCTri *> & tri_u0, std::vector<vctl::MCTri *> & tri_edge);

    //! Delete group of tris in shape of tetrahedron, instead of collapsing their edge.
    void DeleteTetra(vctl::MCTriS & tris, vctl::MCTri * base_tri);

    //! Reevaluate influenced edgea after edge collapsing.
    void ReevaluateColapseChanges(vctl::MCTriS & tris, vctl::MCVertex * new_vertex);

    bool TestVertices(vctl::MCTriS & tris);

private:
    std::vector<vctl::MCTri *>              m_tri_edge;                         //! Vector of pointers to tris around input edge
    std::vector<vctl::MCTri *>              m_tri_u0, m_tri_u1;                 //! Vector of pointers to tris around vertices of input edge
    std::vector<vctl::MCTri *>              m_tri_list_influenced;              //! Vector of pointers to tris influenced by collapse
    std::vector<vctl::MCEdge *>             m_edge_list;                        //! Vector of edge pointers around vertex
    std::vector<vctl::MCEdge *>             m_edge_list_influenced;             //! Vector of edge pointers influenced by collapse with resulted new vertex
    std::vector<vctl::MCEdge *>             m_edge_list_rest;                   //! Vector of edge pointers around rest vertex
    vctl::MCVector3D			            m_move_vector;                      //! Vector of edge vertex move, tetrahedron creation
    vctl::MCVector3D			            m_collapsed_normal;                 //! Normal vector of collapsed tri
};


#endif // CDecimator_H

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
