//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    DecimatorModule.h                   \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 */

#ifndef MDS_DecimatorModule_H
#define MDS_DecimatorModule_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * MDSTk based polygonal mesh decimating module
 */
class CDecimatorModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    //MDS_CLASS_NAME(CDecimatorModule);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CDecimatorModule);

public:
    //! Default constructor.
    CDecimatorModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CDecimatorModule();

    //! Progress function
    bool ProgressFunction(int count, int max)       { std::cout << std::endl << "Decimator - mesh tri number = " << count << " / " << max; return true; };

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);


    // Module parameters
    int             m_iPercents;                  //! Size of output tri mesh in percents.
    int             m_iTriangles;                 //! Number of triangles of output tri mesh.
    bool            m_bUseTrianglesNumber;        //! State to use number of triangles of output tri mesh. Default value is false.
    bool            m_bTestManifold;              //! State for manifold test of output tri mesh.

};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CDecimatorModule::tSmartPtr    CDecimatorModulePtr;


#endif // MDS_DecimatorModule_H

