//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    SaveSTL.h                           \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 */

#ifndef MDS_SaveSTLModule_H
#define MDS_SaveSTLModule_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module for translation from MDSTk::VectorEntity library native TRI format into STL format.
 */
class CSaveSTLModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    //MDS_CLASS_NAME(CSaveSTLModule);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CSaveSTLModule);

public:
    //! Default constructor.
    CSaveSTLModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CSaveSTLModule();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CSaveSTLModule::tSmartPtr    CSaveSTLModulePtr;


#endif // MDS_SaveSTLModule_H

