//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    SaveVRMLModule.h                    \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 */

#ifndef MDS_SaveVRMLModule_H
#define MDS_SaveVRMLModule_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module for translation from MDSTk::VectorEntity library native TRI format into STL format.
 */
class CSaveVRMLModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    //MDS_CLASS_NAME(CSaveVRMLModule);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CSaveVRMLModule);

public:
    //! Default constructor.
    CSaveVRMLModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CSaveVRMLModule();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CSaveVRMLModule::tSmartPtr    CSaveVRMLModulePtr;


#endif // MDS_SaveVRMLModule_H

