//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    SmoothingModule.h                   \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 */

#ifndef MDS_SmoothingModule_H
#define MDS_SmoothingModule_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * MDSTk based Smoothing cubes module 
 */
class CSmoothingModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    //MDS_CLASS_NAME(CSmoothingModule);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CSmoothingModule);

public:
    //! Default constructor.
    CSmoothingModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CSmoothingModule();

    //! Progress function
    bool ProgressFunction(int count, int max)       { std::cout << std::endl << "Smoothing step = " << count << " / " << max; return true; };

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);


    // Module parameters
    int             m_iRepeat;                  //! Number of smoothing iterations.
    double          m_dLambda;                  //! Positive scale factor.
    double          m_dKpb;                     //! Filter pass-band frequency.

};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CSmoothingModule::tSmartPtr    CSmoothingModulePtr;


#endif // MDS_SmoothingModule_H

