//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    Tri2VRML.h                           \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 */

#ifndef MDS_Tri2VRMLModule_H
#define MDS_Tri2VRMLModule_H

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module for translation from MDSTk::VectorEntity library native TRI format into VRL format.
 */
class CTri2VRMLModule : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    //MDS_CLASS_NAME(CTri2VRMLModule);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CTri2VRMLModule);

public:
    //! Default constructor.
    CTri2VRMLModule(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CTri2VRMLModule();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing an usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CTri2VRMLModule::tSmartPtr    CTri2VRMLModulePtr;


#endif // MDS_Tri2VRMLModule_H

