///////////////////////////////////////////////////////////////////////////////
// $Id$
//
// EasyDent
// Navigation and implants planning software for dentistry.
//
// Copyright (c) 2008 by 3Dim Laboratory s.r.o.
//
///////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// Includes

#include "CMarchingCubes.h"

// STL

////////////////////////////////////////////////////////////
// scheme cubes with numbering conventions of nodes and edges

/*       128 |7|----------10---------|6| 64
            / |                     / |
           /  |                    /  |
         11   |                   9   |
         /    |                  /    |
        /     7                 /     6
       /      |                /      |
  16 |4|----------8----------|5| 32   |
      |       |               |       |
      |       |               |       |
      |       |               |       |
      |    8 |3|----------2---|------|2| 4
      4      /                5      /
      |     /                 |     /
      |    3                  |    1
      |   /                   |   /
      |  /                    |  /
      | /                     | /
   1 |0|----------0----------|1| 2        */

// array for all 256 combinations of nodes states, have new triangles vertex edge indexes 
const int node_state[256][12] = { 
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},   // 0 C
    {0, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 1
    {1, 0, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 2
    {5, 1, 3, 3, 4, 5, -1, -1, -1, -1, -1, -1},         // 3
    {2, 1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 4
    {0, 3, 4, 2, 1, 6, -1, -1, -1, -1, -1, -1},         // 5
    {6, 2, 0, 0, 5, 6, -1, -1, -1, -1, -1, -1},         // 6
    {3, 4, 6, 6, 2, 3, 4, 5, 6, -1, -1, -1},            // 7
    {3, 2, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 8
    {4, 0, 2, 2, 7, 4, -1, -1, -1, -1, -1, -1},         // 9
    {1, 0, 5, 3, 2, 7, -1, -1, -1, -1, -1, -1},         // 10
    {2, 7, 5, 5, 1, 2, 7, 4, 5, -1, -1, -1},            // 11
    {7, 3, 6, 3, 1, 6, -1, -1, -1, -1, -1, -1},         // 12
    {1, 6, 4, 4, 0, 1, 6, 7, 4, -1, -1, -1},            // 13
    {0, 5, 7, 7, 3, 0, 5, 6, 7, -1, -1, -1},            // 14
    {4, 5, 6, 6, 7, 4, -1, -1, -1, -1, -1, -1},         // 15
    {11, 8, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1},     // 16
    {0, 3, 11, 11, 8, 0, -1, -1, -1, -1, -1, -1},       // 17
    {1, 0, 5, 11, 8, 4, -1, -1, -1, -1, -1, -1},        // 18
    {5, 1, 11, 11, 8, 5, 1, 3, 11, -1, -1, -1},         // 19
    {2, 1, 6, 11, 8, 4, -1, -1, -1, -1, -1, -1},        // 20
    {2, 1, 6, 0, 3, 11, 11, 8, 0, -1, -1, -1},          // 21
    {11, 8, 4, 6, 2, 0, 0, 5, 6, -1, -1, -1},           // 22
    {8, 5, 11, 5, 6, 2, 5, 2, 11, 2, 3, 11},            // 23
    {3, 2, 7, 11, 8, 4, -1, -1, -1, -1, -1, -1},        // 24
    {11, 8, 2, 2, 7, 11, 8, 0, 2, -1, -1, -1},          // 25
    {1, 0, 5, 3, 2, 7, 11, 8, 4, -1, -1, -1},           // 26
    {8, 5, 7, 5, 1, 2, 5, 2, 7, 7, 11, 8},              // 27
    {11, 8, 4, 7, 3, 1, 1, 6, 7, -1, -1, -1},           // 28
    {0, 1, 8, 1, 6, 7, 1, 7, 8, 7, 11, 8},              // 29
    {11, 8, 4, 0, 5, 7, 7, 3, 0, 5, 6, 7},              // 30
    {11, 5, 7, 5, 11, 8, 7, 5, 6, -1, -1, -1},          // 31 C
    {8, 9, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 32
    {0, 3, 4, 8, 9, 5, -1, -1, -1, -1, -1, -1},         // 33
    {8, 9, 1, 1, 0, 8, -1, -1, -1, -1, -1, -1},         // 34
    {8, 9, 3, 3, 4, 8, 9, 1, 3, -1, -1, -1},            // 35
    {2, 1, 6, 8, 9, 5, -1, -1, -1, -1, -1, -1},         // 36
    {0, 3, 4, 2, 1, 6, 8, 9, 5, -1, -1, -1},            // 37
    {6, 2, 8, 8, 9, 6, 2, 0, 8, -1, -1, -1},            // 38
    {9, 6, 4, 6, 2, 3, 6, 3, 4, 4, 8, 9},               // 39
    {3, 2, 7, 8, 9, 5, -1, -1, -1, -1, -1, -1},         // 40
    {8, 9, 5, 4, 0, 2, 2, 7, 4, -1, -1, -1},            // 41
    {3, 2, 7, 8, 9, 1, 1, 0, 8, -1, -1, -1},            // 42
    {2, 7, 1, 7, 4, 8, 7, 8, 1, 8, 9, 1},               // 43
    {8, 9, 5, 7, 3, 1, 1, 6, 7, -1, -1, -1},            // 44
    {8, 9, 5, 1, 6, 4, 4, 0, 1, 6, 7, 4},               // 45
    {9, 6, 8, 6, 7, 3, 6, 3, 8, 3, 0, 8},               // 46
    {8, 6, 4, 6, 8, 9, 4, 6, 7, -1, -1, -1},            // 47 C
    {4, 11, 9, 9, 5, 4, -1, -1, -1, -1, -1, -1},        // 48
    {0, 3, 9, 9, 5, 0, 3, 11, 9, -1, -1, -1},           // 49
    {4, 11, 1, 1, 0, 4, 11, 9, 1, -1, -1, -1},          // 50
    {3, 11, 9, 9, 1, 3, -1, -1, -1, -1, -1, -1},        // 51
    {2, 1, 6, 4, 11, 9, 9, 5, 4, -1, -1, -1},           // 52
    {2, 1, 6, 0, 3, 9, 9, 5, 0, 3, 11, 9},              // 53
    {9, 6, 11, 6, 2, 0, 6, 0, 11, 0, 4, 11},            // 54
    {6, 3, 9, 3, 6, 2, 9, 3, 11, -1, -1, -1},           // 55 C
    {3, 2, 7, 4, 11, 9, 9, 5, 4, -1, -1, -1},           // 56
    {5, 0, 9, 0, 2, 7, 0, 7, 9, 7, 11, 9},              // 57
    {3, 2, 7, 4, 11, 1, 1, 0, 4, 11, 9, 1},             // 58
    {2, 11, 1, 11, 2, 7, 1, 11, 9, -1, -1, -1},         // 59 C
    {7, 3, 1, 1, 6, 7, 4, 11, 9, 9, 5, 4},              // 60
    {1, 5, 0, 6, 11, 9, 11, 6, 7, -1, -1, -1},          // 61 C
    {0, 4, 3, 6, 11, 9, 11, 6, 7, -1, -1, -1},          // 62 C
    {6, 7, 9, 9, 7, 11, -1, -1, -1, -1, -1, -1},        // 63 C
    {9, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1},     // 64
    {0, 3, 4, 9, 10, 6, -1, -1, -1, -1, -1, -1},        // 65
    {1, 0, 5, 9, 10, 6, -1, -1, -1, -1, -1, -1},        // 66
    {9, 10, 6, 5, 1, 3, 3, 4, 5, -1, -1, -1},           // 67
    {2, 1, 10, 1, 9, 10, -1, -1, -1, -1, -1, -1},       // 68
    {0, 3, 4, 2, 1, 9, 9, 10, 2, -1, -1, -1},           // 69
    {9, 10, 0, 0, 5, 9, 10, 2, 0, -1, -1, -1},          // 70
    {3, 4, 2, 4, 5, 9, 4, 9, 2, 9, 10, 2},              // 71
    {3, 2, 7, 9, 10, 6, -1, -1, -1, -1, -1, -1},        // 72
    {9, 10, 6, 4, 0, 2, 2, 7, 4, -1, -1, -1},           // 73
    {1, 0, 5, 3, 2, 7, 9, 10, 6, -1, -1, -1},           // 74
    {9, 10, 6, 2, 7, 5, 5, 1, 2, 7, 4, 5},              // 75
    {7, 3, 9, 9, 10, 7, 3, 1, 9, -1, -1, -1},           // 76
    {10, 7, 9, 7, 4, 0, 7, 0, 9, 0, 1, 9},              // 77
    {10, 7, 5, 7, 3, 0, 7, 0, 5, 5, 9, 10},             // 78
    {9, 7, 5, 7, 9, 10, 5, 7, 4, -1, -1, -1},           // 79 C
    {11, 8, 4, 9, 10, 6, -1, -1, -1, -1, -1, -1},       // 80
    {9, 10, 6, 0, 3, 11, 11, 8, 0, -1, -1, -1},         // 81
    {1, 0, 5, 11, 8, 4, 9, 10, 6, -1, -1, -1},          // 82
    {9, 10, 6, 5, 1, 11, 11, 8, 5, 1, 3, 11},           // 83
    {11, 8, 4, 2, 1, 9, 9, 10, 2, -1, -1, -1},          // 84
    {0, 3, 11, 11, 8, 0, 2, 1, 9, 9, 10, 2},            // 85
    {11, 8, 4, 9, 10, 0, 0, 5, 9, 10, 2, 0},            // 86
    {8, 5, 9, 10, 3, 11, 3, 10, 2, -1, -1, -1},         // 87 C
    {3, 2, 7, 11, 8, 4, 9, 10, 6, -1, -1, -1},          // 88
    {9, 10, 6, 11, 8, 2, 2, 7, 11, 8, 0, 2},            // 89
    {1, 0, 5, 3, 2, 7, 11, 8, 4, 9, 10, 6},             // 90
    {2, 6, 1, 8, 5, 9, 10, 7, 11, -1, -1, -1},          // 91 C
    {11, 8, 4, 7, 3, 9, 9, 10, 7, 3, 1, 9},             // 92
    {10, 7, 11, 8, 1, 9, 1, 8, 0, -1, -1, -1},          // 93 C
    {0, 4, 3, 8, 5, 9, 10, 7, 11, -1, -1, -1},          // 94 C
    {8, 5, 9, 10, 7, 11, -1, -1, -1, -1, -1, -1},       // 95 C
    {5, 8, 6, 8, 10, 6, -1, -1, -1, -1, -1, -1},        // 96
    {0, 3, 4, 5, 8, 10, 10, 6, 5, -1, -1, -1},          // 97
    {1, 0, 10, 10, 6, 1, 0, 8, 10, -1, -1, -1},         // 98
    {6, 1, 10, 1, 3, 4, 1, 4, 10, 4, 8, 10},            // 99
    {5, 8, 2, 2, 1, 5, 8, 10, 2, -1, -1, -1},           // 100
    {0, 3, 4, 5, 8, 2, 2, 1, 5, 8, 10, 2},              // 101
    {0, 8, 10, 10, 2, 0, -1, -1, -1, -1, -1, -1},       // 102
    {3, 8, 2, 8, 3, 4, 2, 8, 10, -1, -1, -1},           // 103 C
    {3, 2, 7, 5, 8, 10, 10, 6, 5, -1, -1, -1},          // 104
    {4, 0, 2, 2, 7, 4, 5, 8, 10, 10, 6, 5},             // 105
    {3, 2, 7, 1, 0, 10, 10, 6, 1, 0, 8, 10},            // 106
    {2, 6, 1, 7, 8, 10, 8, 7, 4, -1, -1, -1},           // 107 C
    {7, 3, 10, 3, 1, 5, 3, 5, 10, 5, 8, 10},            // 108
    {1, 5, 0, 7, 8, 10, 8, 7, 4, -1, -1, -1},           // 109 C
    {7, 0, 10, 0, 7, 3, 10, 0, 8, -1, -1, -1},          // 110 C
    {7, 4, 10, 10, 4, 8, -1, -1, -1, -1, -1, -1},       // 111 C
    {10, 6, 4, 4, 11, 10, 6, 5, 4, -1, -1, -1},         // 112
    {10, 6, 11, 6, 5, 0, 6, 0, 11, 0, 3, 11},           // 113
    {0, 4, 6, 4, 11, 10, 4, 10, 6, 6, 1, 0},            // 114
    {10, 1, 11, 1, 10, 6, 11, 1, 3, -1, -1, -1},        // 115 C
    {1, 5, 2, 5, 4, 11, 5, 11, 2, 11, 10, 2},           // 116
    {1, 5, 0, 10, 3, 11, 3, 10, 2, -1, -1, -1},         // 117 C
    {4, 10, 0, 10, 4, 11, 0, 10, 2, -1, -1, -1},        // 118 C
    {10, 2, 11, 11, 2, 3, -1, -1, -1, -1, -1, -1},      // 119 C
    {3, 2, 7, 10, 6, 4, 4, 11, 10, 6, 5, 4},            // 120
    {10, 7, 11, 6, 0, 2, 0, 6, 5, -1, -1, -1},          // 121 C
    {0, 4, 3, 2, 6, 1, 10, 7, 11, -1, -1, -1},          // 122 C
    {2, 6, 1, 10, 7, 11, -1, -1, -1, -1, -1, -1},       // 123 C
    {10, 7, 11, 5, 3, 1, 3, 5, 4, -1, -1, -1},          // 124 C
    {1, 5, 0, 10, 7, 11, -1, -1, -1, -1, -1, -1},       // 125 C
    {0, 4, 3, 10, 7, 11, -1, -1, -1, -1, -1, -1},       // 126 C
    {10, 7, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1},    // 127 C
    {10, 11, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1},    // 128
    {0, 3, 4, 10, 11, 7, -1, -1, -1, -1, -1, -1},       // 129
    {1, 0, 5, 10, 11, 7, -1, -1, -1, -1, -1, -1},       // 130
    {10, 11, 7, 5, 1, 3, 3, 4, 5, -1, -1, -1},          // 131
    {2, 1, 6, 10, 11, 7, -1, -1, -1, -1, -1, -1},       // 132
    {0, 3, 4, 2, 1, 6, 10, 11, 7, -1, -1, -1},          // 133
    {10, 11, 7, 6, 2, 0, 0, 5, 6, -1, -1, -1},          // 134
    {10, 11, 7, 3, 4, 6, 6, 2, 3, 4, 5, 6},             // 135
    {10, 11, 2, 11, 3, 2, -1, -1, -1, -1, -1, -1},      // 136
    {4, 0, 10, 10, 11, 4, 0, 2, 10, -1, -1, -1},        // 137
    {1, 0, 5, 10, 11, 3, 3, 2, 10, -1, -1, -1},         // 138
    {11, 4, 10, 4, 5, 1, 4, 1, 10, 1, 2, 10},           // 139
    {10, 11, 1, 1, 6, 10, 11, 3, 1, -1, -1, -1},        // 140
    {11, 4, 6, 4, 0, 1, 4, 1, 6, 6, 10, 11},            // 141
    {10, 11, 6, 11, 3, 0, 11, 0, 6, 0, 5, 6},           // 142
    {10, 4, 6, 4, 10, 11, 6, 4, 5, -1, -1, -1},         // 143 C
    {7, 10, 4, 10, 8, 4, -1, -1, -1, -1, -1, -1},       // 144
    {7, 10, 0, 0, 3, 7, 10, 8, 0, -1, -1, -1},          // 145
    {1, 0, 5, 7, 10, 8, 8, 4, 7, -1, -1, -1},           // 146
    {5, 1, 8, 1, 3, 7, 1, 7, 8, 7, 10, 8},              // 147
    {2, 1, 6, 7, 10, 8, 8, 4, 7, -1, -1, -1},           // 148
    {2, 1, 6, 7, 10, 0, 0, 3, 7, 10, 8, 0},             // 149
    {6, 2, 0, 0, 5, 6, 7, 10, 8, 8, 4, 7},              // 150
    {3, 7, 2, 5, 10, 8, 10, 5, 6, -1, -1, -1},          // 151 C
    {3, 2, 8, 8, 4, 3, 2, 10, 8, -1, -1, -1},           // 152
    {0, 2, 10, 10, 8, 0, -1, -1, -1, -1, -1, -1},       // 153
    {1, 0, 5, 3, 2, 8, 8, 4, 3, 2, 10, 8},              // 154
    {5, 2, 8, 2, 5, 1, 8, 2, 10, -1, -1, -1},           // 155 C
    {6, 10, 1, 10, 8, 4, 10, 4, 1, 4, 3, 1},            // 156
    {1, 10, 0, 10, 1, 6, 0, 10, 8, -1, -1, -1},         // 157 C
    {0, 4, 3, 5, 10, 8, 10, 5, 6, -1, -1, -1},          // 158 C
    {5, 6, 8, 8, 6, 10, -1, -1, -1, -1, -1, -1},        // 159 C
    {8, 9, 5, 10, 11, 7, -1, -1, -1, -1, -1, -1},       // 160
    {0, 3, 4, 8, 9, 5, 10, 11, 7, -1, -1, -1},          // 161
    {10, 11, 7, 8, 9, 1, 1, 0, 8, -1, -1, -1},          // 162
    {10, 11, 7, 8, 9, 3, 3, 4, 8, 9, 1, 3},             // 163
    {2, 1, 6, 8, 9, 5, 10, 11, 7, -1, -1, -1},          // 164
    {0, 3, 4, 2, 1, 6, 8, 9, 5, 10, 11, 7},             // 165
    {10, 11, 7, 6, 2, 8, 8, 9, 6, 2, 0, 8},             // 166
    {3, 7, 2, 11, 4, 8, 9, 6, 10, -1, -1, -1},          // 167 C
    {8, 9, 5, 10, 11, 3, 3, 2, 10, -1, -1, -1},         // 168
    {8, 9, 5, 4, 0, 10, 10, 11, 4, 0, 2, 10},           // 169
    {8, 9, 1, 1, 0, 8, 10, 11, 3, 3, 2, 10},            // 170
    {11, 4, 8, 2, 9, 1, 9, 2, 10, -1, -1, -1},          // 171 C
    {8, 9, 5, 10, 11, 1, 1, 6, 10, 11, 3, 1},           // 172
    {1, 5, 0, 11, 4, 8, 9, 6, 10, -1, -1, -1},          // 173 C
    {9, 6, 10, 0, 11, 3, 11, 0, 8, -1, -1, -1},         // 174 C
    {11, 4, 8, 9, 6, 10, -1, -1, -1, -1, -1, -1},       // 175 C
    {9, 5, 7, 7, 10, 9, 5, 4, 7, -1, -1, -1},           // 176
    {3, 7, 5, 7, 10, 9, 7, 9, 5, 5, 0, 3},              // 177
    {10, 9, 7, 9, 1, 0, 9, 0, 7, 0, 4, 7},              // 178
    {7, 9, 3, 9, 7, 10, 3, 9, 1, -1, -1, -1},           // 179 C
    {2, 1, 6, 9, 5, 7, 7, 10, 9, 5, 4, 7},              // 180
    {1, 5, 0, 3, 7, 2, 9, 6, 10, -1, -1, -1},           // 181 C
    {9, 6, 10, 4, 2, 0, 2, 4, 7, -1, -1, -1},           // 182 C
    {3, 7, 2, 9, 6, 10, -1, -1, -1, -1, -1, -1},        // 183 C
    {9, 5, 10, 5, 4, 3, 5, 3, 10, 3, 2, 10},            // 184
    {9, 0, 10, 0, 9, 5, 10, 0, 2, -1, -1, -1},          // 185 C
    {0, 4, 3, 2, 9, 1, 9, 2, 10, -1, -1, -1},           // 186 C
    {2, 10, 1, 1, 10, 9, -1, -1, -1, -1, -1, -1},       // 187 C
    {9, 6, 10, 5, 3, 1, 3, 5, 4, -1, -1, -1},           // 188 C
    {1, 5, 0, 9, 6, 10, -1, -1, -1, -1, -1, -1},        // 189 C
    {0, 4, 3, 9, 6, 10, -1, -1, -1, -1, -1, -1},        // 190 C
    {9, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1},     // 191 C
    {6, 9, 7, 9, 11, 7, -1, -1, -1, -1, -1, -1},        // 192
    {0, 3, 4, 6, 9, 11, 11, 7, 6, -1, -1, -1},          // 193
    {1, 0, 5, 6, 9, 11, 11, 7, 6, -1, -1, -1},          // 194
    {5, 1, 3, 3, 4, 5, 6, 9, 11, 11, 7, 6},             // 195
    {2, 1, 11, 11, 7, 2, 1, 9, 11, -1, -1, -1},         // 196
    {0, 3, 4, 2, 1, 11, 11, 7, 2, 1, 9, 11},            // 197
    {5, 9, 0, 9, 11, 7, 9, 7, 0, 7, 2, 0},              // 198
    {3, 7, 2, 4, 9, 11, 9, 4, 5, -1, -1, -1},           // 199 C
    {6, 9, 3, 3, 2, 6, 9, 11, 3, -1, -1, -1},           // 200
    {6, 9, 2, 9, 11, 4, 9, 4, 2, 4, 0, 2},              // 201
    {1, 0, 5, 6, 9, 3, 3, 2, 6, 9, 11, 3},              // 202
    {2, 6, 1, 4, 9, 11, 9, 4, 5, -1, -1, -1},           // 203 C
    {3, 1, 9, 9, 11, 3, -1, -1, -1, -1, -1, -1},        // 204
    {4, 1, 11, 1, 4, 0, 11, 1, 9, -1, -1, -1},          // 205 C
    {0, 9, 3, 9, 0, 5, 3, 9, 11, -1, -1, -1},           // 206 C
    {4, 9, 11, 9, 4, 5, -1, -1, -1, -1, -1, -1},        // 207 C
    {8, 4, 6, 6, 9, 8, 4, 7, 6, -1, -1, -1},            // 208
    {9, 8, 6, 8, 0, 3, 8, 3, 6, 3, 7, 6},               // 209
    {1, 0, 5, 8, 4, 6, 6, 9, 8, 4, 7, 6},               // 210
    {8, 5, 9, 7, 1, 3, 1, 7, 6, -1, -1, -1},            // 211 C
    {2, 1, 7, 1, 9, 8, 1, 8, 7, 8, 4, 7},               // 212
    {3, 7, 2, 8, 1, 9, 1, 8, 0, -1, -1, -1},            // 213 C
    {8, 5, 9, 4, 2, 0, 2, 4, 7, -1, -1, -1},            // 214 C
    {3, 7, 2, 8, 5, 9, -1, -1, -1, -1, -1, -1},         // 215 C
    {2, 6, 4, 6, 9, 8, 6, 8, 4, 4, 3, 2},               // 216
    {6, 8, 2, 8, 6, 9, 2, 8, 0, -1, -1, -1},            // 217 C
    {0, 4, 3, 2, 6, 1, 8, 5, 9, -1, -1, -1},            // 218 C
    {2, 6, 1, 8, 5, 9, -1, -1, -1, -1, -1, -1},         // 219 C
    {8, 3, 9, 3, 8, 4, 9, 3, 1, -1, -1, -1},            // 220 C
    {8, 1, 9, 1, 8, 0, -1, -1, -1, -1, -1, -1},         // 221 C
    {0, 4, 3, 8, 5, 9, -1, -1, -1, -1, -1, -1},         // 222 C
    {8, 5, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 223 C
    {11, 7, 5, 5, 8, 11, 7, 6, 5, -1, -1, -1},          // 224
    {0, 3, 4, 11, 7, 5, 5, 8, 11, 7, 6, 5},             // 225
    {11, 7, 8, 7, 6, 1, 7, 1, 8, 1, 0, 8},              // 226
    {11, 4, 8, 7, 1, 3, 1, 7, 6, -1, -1, -1},           // 227 C
    {1, 5, 7, 5, 8, 11, 5, 11, 7, 7, 2, 1},             // 228
    {1, 5, 0, 3, 7, 2, 11, 4, 8, -1, -1, -1},           // 229 C
    {11, 2, 8, 2, 11, 7, 8, 2, 0, -1, -1, -1},          // 230 C
    {3, 7, 2, 11, 4, 8, -1, -1, -1, -1, -1, -1},        // 231 C
    {8, 11, 5, 11, 3, 2, 11, 2, 5, 2, 6, 5},            // 232
    {11, 4, 8, 6, 0, 2, 0, 6, 5, -1, -1, -1},           // 233 C
    {2, 6, 1, 0, 11, 3, 11, 0, 8, -1, -1, -1},          // 234 C
    {2, 6, 1, 11, 4, 8, -1, -1, -1, -1, -1, -1},        // 235 C
    {5, 11, 1, 11, 5, 8, 1, 11, 3, -1, -1, -1},         // 236 C
    {1, 5, 0, 11, 4, 8, -1, -1, -1, -1, -1, -1},        // 237 C
    {0, 11, 3, 11, 0, 8, -1, -1, -1, -1, -1, -1},       // 238 C
    {11, 4, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1},     // 239 C
    {4, 6, 5, 6, 4, 7, -1, -1, -1, -1, -1, -1},         // 240
    {0, 7, 5, 7, 0, 3, 5, 7, 6, -1, -1, -1},            // 241 C
    {1, 4, 6, 4, 1, 0, 6, 4, 7, -1, -1, -1},            // 242 C
    {7, 6, 3, 3, 6, 1, -1, -1, -1, -1, -1, -1},         // 243 C
    {2, 5, 7, 5, 2, 1, 7, 5, 4, -1, -1, -1},            // 244 C
    {1, 5, 0, 3, 7, 2, -1, -1, -1, -1, -1, -1},         // 245 C
    {4, 2, 0, 2, 4, 7, -1, -1, -1, -1, -1, -1},         // 246 C
    {3, 7, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 247 C
    {3, 6, 4, 6, 3, 2, 4, 6, 5, -1, -1, -1},            // 248 C
    {6, 0, 2, 0, 6, 5, -1, -1, -1, -1, -1, -1},         // 249 C
    {0, 4, 3, 2, 6, 1, -1, -1, -1, -1, -1, -1},         // 250 C
    {2, 6, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 251 C
    {5, 3, 1, 3, 5, 4, -1, -1, -1, -1, -1, -1},         // 252 C
    {1, 5, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 253 C
    {0, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1},      // 254 C
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};  // 255 C

////////////////////////////////////////////////////////////
// Face hole test data, down side

       /* 128 |7|----------10---------|6| 64
              / |                     / |
             /  |                    /  |
           11   |                   9   |
           /    |                  /    |
          /     7                 /     6
         /      |                /      |
    16 |4|----------8----------|5| 32   |
        |       |               |       |
        |       |               |       |
        |       |               |       |
        |    8 |3|----------2---|------|2| 4
        4      /|               5      /|
        |     / |               |     / |
        |    3  |               |    1  |
        |   /   |               |   /   |
        |  /    19              |  /    18
        | /     |               | /     |
     1 |0|----------0----------|1| 2    |
        |       |               |       |
        |       |               |       |
        |       |               |       |
        | 2048 |11|--------14---|------|10| 1024
        16     /                17     /
        |     /                 |     /
        |    15                 |    13
        |   /                   |   /
        |  /                    |  /
        | /                     | /
   256 |8|----------12---------|9| 512        */

// 2D array for all 256 combinations of cube nodes states for face hole test, 
// have state of down neighbor cube in case of face hole
const int down_hole_code[256][11] = {
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 0
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 1
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 2
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 3
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 4
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 5 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 6
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 7
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 8
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 9
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 10 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 11
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 12
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 13
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 14
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 15
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 16
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 17
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 18
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 19
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 20
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 21 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 22
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 23
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 24
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 25
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 26 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 27
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 28
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 29
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 30
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 31
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 32
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 33
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 34
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 35
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 36
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 37 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 38
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 39
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 40
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 41
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 42 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 43
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 44
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 45
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 46
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 47
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 48
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 49
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 50
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 51
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 52
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 53 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 54
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 55
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 56
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 57
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 58 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 59
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 60
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 61
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 62
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 63
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 64
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 65
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 66
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 67
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 68
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 69 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 70
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 71
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 72
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 73
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 74 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 75
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 76
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 77
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 78
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 79
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 80
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 81
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 82
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 83
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 84
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 85 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 86
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 87
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 88
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 89
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 90 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 91
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 92
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 93
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 94
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 95
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 96
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 97
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 98
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 99
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 100
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 101 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 102
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 103
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 104
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 105
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 106 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 107
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 108
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 109
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 110
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 111
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 112
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 113
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 114
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 115
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 116
    {80, 81, 82, 83, 84, 85, 86, 88, 89, 90, 92},             // 117 o
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 118
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 119
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 120
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 121
    {160, 161, 162, 163, 164, 165, 166, 168, 169, 170, 172},  // 122 o
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 123
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 124
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 125
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 126
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 127
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 128
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 129
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 130
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 131
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 132
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 133 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 134
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 135
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 136
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 137
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 138 i
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 139
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 140
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 141
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 142
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 143
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 144
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 145
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 146
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 147
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 148
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 149
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 150
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 151
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 152
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 153
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 154
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 155
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 156
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 157
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 158
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 159
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 160
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 161
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 162
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 163
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 164
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 165
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 166
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 167
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 168
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 169
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 170
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 171
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 172
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 173
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 174
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 175
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 176
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 177
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 178
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 179
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 180
    {80, 81, 82, 83, 84, 85, 86, 88, 89, 90, 92},             // 181
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 182
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 183
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 184
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 185
    {160, 161, 162, 163, 164, 165, 166, 168, 169, 170, 172},  // 186
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 187
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 188
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 189
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 190
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 191
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 192
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 193
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 194
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 195
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 196
    {87, 91, 93, 94, 95, -1, -1, -1, -1, -1, -1},             // 197
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 198
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 199
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 200
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 201
    {167, 171, 173, 174, 175, -1, -1, -1, -1, -1, -1},        // 202
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 203
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 204
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 205
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 206
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 207
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 208
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 209
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 210
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 211
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 212
    {80, 81, 82, 83, 84, 85, 86, 88, 89, 90, 92},             // 213
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 214
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 215
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 216
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 217
    {160, 161, 162, 163, 164, 165, 166, 168, 169, 170, 172},  // 218
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 219
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 220
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 221
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 222
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 223
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 224
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 225
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 226
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 227
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 228
    {80, 81, 82, 83, 84, 85, 86, 88, 89, 90, 92},             // 229
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 230
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 231
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 232
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 233
    {160, 161, 162, 163, 164, 165, 166, 168, 169, 170, 172},  // 234
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 235
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 236
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 237
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 238
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 239
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 240
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 241
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 242
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 243
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 244
    {80, 81, 82, 83, 84, 85, 86, 88, 89, 90, 92},             // 245
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 246
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 247
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 248
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 249
    {160, 161, 162, 163, 164, 165, 166, 168, 169, 170, 172},  // 250
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 251
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 252
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 253
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 254
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};            // 255

////////////////////////////////////////////////////////////
// Face hole test data, front side

                /* 128 |7|----------10---------|6| 64
                      / |                     / |
                     /  |                    /  |
                   11   |                   9   |
                   /    |                  /    |
                  /     7                 /     6
                 /      |                /      |
            16 |4|----------8----------|5| 32   |
              / |       |             / |       |
             /  |       |            /  |       |
            19  |       |           18  |       |
           /    |    8 |3|----2----/----|------|2| 4
          /     4      /          /     5      /
    1024 /      |     3          /      |     /
       |10|-------------17-----|11|     |    1
        |       |   /           | 2048  |   /
        |       |  /            |       |  /
        |       | /             |       | /
        |    1 |0|----------0---|------|1| 2
        15     /                16     /
        |     /                 |     /
        |    14                 |    13
        |   /                   |   /
        |  /                    |  /
        | /                     | /
   256 |8|----------12---------|9| 512        */

// 2D array for all 256 combinations of cube nodes states for face hole test, 
// have state of front neighbor cube in case of face hole
const int front_hole_code[256][11] = {
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 0
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 1
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 2
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 3
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 4
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 5
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 6
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 7
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 8
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 9
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 10
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 11
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 12
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 13
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 14
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 15
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 16
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 17
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 18
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 19
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 20
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 21
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 22
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 23
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 24
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 25
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 26
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 27
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 28
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 29
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 30
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 31
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 32
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 33
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 34
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 35
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 36
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 37
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 38
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 39
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 40
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 41
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 42
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 43
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 44
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 45
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 46
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 47
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 48
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 49
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 50
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 51
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 52
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 53
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 54
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 55
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 56
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 57
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 58
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 59
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 60
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 61
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 62
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 63
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 64
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 65
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 66
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 67
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 68
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 69
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 70
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 71
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 72
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 73
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 74
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 75
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 76
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 77
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 78
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 79
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 80
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 81
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 82
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 83
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 84
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 85
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 86
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 87
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 88
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 89
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 90
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 91
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 92
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 93
    {132, 133, 134, 135, 148, 149, 150, 164, 165, 166, 180},  // 94
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 95
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 96
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 97
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 98
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 99
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 100
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 101
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 102
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 103
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 104
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 105
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 106
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 107
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 108
    {72, 73, 74, 75, 88, 89, 90, 104, 105, 106, 120},         // 109
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 110
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 111
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 112
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 113
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 114
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 115
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 116
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 117
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 118
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 119
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 120
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 121
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 122
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 123
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 124
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 125
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 126
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 127
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 128
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 129
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 130
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 131
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 132
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 133
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 134
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 135
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 136
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 137
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 138
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 139
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 140
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 141
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 142
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 143
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 144
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 145
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 146
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 147
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 148
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 149
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 150
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 151
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 152
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 153
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 154
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 155
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 156
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 157
    {132, 133, 134, 135, 148, 149, 150, 164, 165, 166, 180},  // 158
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 159
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 160
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 161
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 162
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 163
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 164
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 165
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 166
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 167
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 168
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 169
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 170
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 171
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 172
    {72, 73, 74, 75, 88, 89, 90, 104, 105, 106, 120},         // 173
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 174
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 175
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 176
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 177
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 178
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 179
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 180
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 181
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 182
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 183
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 184
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 185
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 186
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 187
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 188
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 189
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 190
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 191
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 192
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 193
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 194
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 195
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 196
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 197
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 198
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 199
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 200
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 201
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 202
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 203
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 204
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 205
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 206
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 207
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 208
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 209
    {151, 167, 181, 182, 183, -1, -1, -1, -1, -1, -1},        // 210
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 211
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 212
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 213
    {132, 133, 134, 135, 148, 149, 150, 164, 165, 166, 180},  // 214
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 215
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 216
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 217
    {132, 133, 134, 135, 148, 149, 150, 164, 165, 166, 180},  // 218
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 219
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 220
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 221
    {132, 133, 134, 135, 148, 149, 150, 164, 165, 166, 180},  // 222
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 223
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 224
    {91, 107, 121, 122, 123, -1, -1, -1, -1, -1, -1},         // 225
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 226
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 227
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 228
    {72, 73, 74, 75, 88, 89, 90, 104, 105, 106, 120},         // 229
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 230
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 231
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 232
    {72, 73, 74, 75, 88, 89, 90, 104, 105, 106, 120},         // 233
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 234
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 235
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 236
    {72, 73, 74, 75, 88, 89, 90, 104, 105, 106, 120},         // 237
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 238
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 239
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 240
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 241
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 242
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 243
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 244
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 245
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 246
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 247
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 248
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 249
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 250
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 251
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 252
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 253
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 254
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};            // 255

////////////////////////////////////////////////////////////
// Face hole test data, left side

      /* 2048 |11|---------18---------|7|----------10---------|6| 64
              / |                     / | 128                 / |
             /  |                    /  |                    /  |
           19   |                  11   |                   9   |
           /    |                  /    |                  /    |
          /     16                /     7                 /     6
         /      |             16 /      |                /      |
  1024 |10|---------17---------|4|----------8----------|5| 32   |
        |       |               |       |               |       |
        |       |               |       |               |       |
        |       |               |     8 |               |       |
        |  512 |9|----------13--|------|3|----------2---|------|2| 4
        15     /                4      /                5      /
        |     /                 |     /                 |     /
        |    14                 |    3                  |    1
        |   /                   |   /                   |   /
        |  /                    |  /                    |  /
        | /                   1 | /                     | /
   256 |8|----------12---------|0|----------0----------|1| 2        */

// 2D array for all 256 combinations of cube nodes states for face hole test, 
// have state of left neighbor cube in case of face hole
const int left_hole_code[256][11] = { 
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},            // 0
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 1
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 2
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 3
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 4
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 5
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 6
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 7
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 8
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 9
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 10
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 11
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 12
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 13
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 14
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 15
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 16
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 17
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 18
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 19
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 20
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 21
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 22
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 23
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 24
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 25
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 26
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 27
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 28
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 29
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 30
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 31
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 32
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 33
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 34
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 35
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 36
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 37
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 38
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 39
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 40
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 41
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 42
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 43
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 44
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 45
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 46
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 47
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 48
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 49
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 50
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 51
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 52
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 53
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 54
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 55
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 56
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 57
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 58
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 59
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 60
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 61
    {36, 37, 44, 45, 52, 53, 60, 164, 165, 172, 180},         // 62
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 63
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 64
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 65
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 66
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 67
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 68
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 69
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 70
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 71
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 72
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 73
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 74
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 75
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 76
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 77
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 78
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 79
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 80
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 81
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 82
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 83
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 84
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 85
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 86
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 87
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 88
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 89
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 90
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 91
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 92
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 93
    {36, 37, 44, 45, 52, 53, 60, 164, 165, 172, 180},         // 94
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 95
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 96
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 97
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 98
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 99
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 100
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 101
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 102
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 103
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 104
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 105
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 106
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 107
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 108
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 109
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 110
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 111
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 112
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 113
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 114
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 115
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 116
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 117
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 118
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 119
    {61, 173, 181, 188, 189, -1, -1, -1, -1, -1, -1},         // 120
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 121
    {36, 37, 44, 45, 52, 53, 60, 164, 165, 172, 180},         // 122
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 123
    {36, 37, 44, 45, 52, 53, 60, 164, 165, 172, 180},         // 124
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 125
    {36, 37, 44, 45, 52, 53, 60, 164, 165, 172, 180},         // 126
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 127
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 128
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 129
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 130
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 131
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 132
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 133
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 134
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 135
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 136
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 137
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 138
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 139
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 140
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 141
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 142
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 143
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 144
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 145
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 146
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 147
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 148
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 149
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 150
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 151
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 152
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 153
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 154
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 155
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 156
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 157
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 158
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 159
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 160
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 161
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 162
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 163
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 164
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 165
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 166
    {66, 67, 74, 75, 82, 83, 90, 194, 195, 202, 210},         // 167
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 168
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 169
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 170
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 171
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 172
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 173
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 174
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 175
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 176
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 177
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 178
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 179
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 180
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 181
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 182
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 183
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 184
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 185
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 186
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 187
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 188
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 189
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 190
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 191
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 192
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 193
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 194
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 195
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 196
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 197
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 198
    {66, 67, 74, 75, 82, 83, 90, 194, 195, 202, 210},         // 199
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 200
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 201
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 202
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 203
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 204
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 205
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 206
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 207
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 208
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 209
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 210
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 211
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 212
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 213
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 214
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 215
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 216
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 217
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 218
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 219
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 220
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 221
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 222
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 223
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 224
    {91, 203, 211, 218, 219, -1, -1, -1, -1, -1, -1},         // 225
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 226
    {66, 67, 74, 75, 82, 83, 90, 194, 195, 202, 210},         // 227
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 228
    {66, 67, 74, 75, 82, 83, 90, 194, 195, 202, 210},         // 229
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 230
    {66, 67, 74, 75, 82, 83, 90, 194, 195, 202, 210},         // 231
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 232
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 233
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 234
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 235
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 236
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 237
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 238
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 239
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 240
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 241
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 242
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 243
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 244
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 245
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 246
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 247
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 248
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 249
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 250
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 251
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 252
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 253
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             // 254
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};            // 255

////////////////////////////////////////////////////////////
// 2D array for cube edge indexes 

const int edge_indexes [12][2] = {{0, 1}, {1, 2}, {2, 3}, {0, 3}, {0, 4}, {1, 5}, {2, 6}, {3, 7}, {4, 5}, {5, 6}, {6, 7}, {4, 7}};


////////////////////////////////////////////////////////////
//

CMarchingCubes::CMarchingCubes()
{
    // initialization of work matrices to NULL value
    state_matrix_up = NULL;
    state_matrix_down = NULL;
    node_matrix_up_h = NULL;
    node_matrix_up_v = NULL;
    node_matrix_down_h = NULL;
    node_matrix_down_v = NULL;
    node_matrix_middle = NULL;
    cube_code_matrix = NULL;
    down_cube_code_matrix = NULL;
}

////////////////////////////////////////////////////////////
//

CMarchingCubes::~CMarchingCubes()
{
  // deallocation of work matrices
  DeallocWorktMem();
}

////////////////////////////////////////////////////////////
//

void CMarchingCubes::AllocWorktMem(int size_x, int size_y)
{
    // set work matrices size
    work_matrices_size_x = size_x + 10;
    work_matrices_size_y = size_y + 10;

    // free allocated work matrices memory
    if (state_matrix_up != NULL)        delete[] (state_matrix_up);
    if (state_matrix_down != NULL)      delete[] (state_matrix_down);
    if (node_matrix_up_h != NULL)       delete[] (node_matrix_up_h);
    if (node_matrix_up_v != NULL)       delete[] (node_matrix_up_v);
    if (node_matrix_down_h != NULL)     delete[] (node_matrix_down_h);
    if (node_matrix_down_v != NULL)     delete[] (node_matrix_down_v);
    if (node_matrix_middle != NULL)     delete[] (node_matrix_middle);
    if (cube_code_matrix != NULL)       delete[] (cube_code_matrix);
    if (down_cube_code_matrix != NULL)  delete[] (down_cube_code_matrix);

    // allocation of work matrices 
    state_matrix_up =       new unsigned char [work_matrices_size_x * work_matrices_size_y];
    state_matrix_down =     new unsigned char [work_matrices_size_x * work_matrices_size_y];
    node_matrix_up_h =      new vctl::MCVertex *[work_matrices_size_x * work_matrices_size_y];
    node_matrix_up_v =      new vctl::MCVertex *[work_matrices_size_x * work_matrices_size_y];
    node_matrix_down_h =    new vctl::MCVertex *[work_matrices_size_x * work_matrices_size_y];
    node_matrix_down_v =    new vctl::MCVertex *[work_matrices_size_x * work_matrices_size_y];
    node_matrix_middle =    new vctl::MCVertex *[work_matrices_size_x * work_matrices_size_y];
    cube_code_matrix =      new unsigned char [work_matrices_size_x * work_matrices_size_y];
    down_cube_code_matrix = new unsigned char [work_matrices_size_x * work_matrices_size_y];

    // clearing work matrices
    memset(state_matrix_up, 0, work_matrices_size_x * work_matrices_size_y * sizeof(unsigned char));
    memset(state_matrix_down, 0, work_matrices_size_x * work_matrices_size_y * sizeof(unsigned char));
    memset(node_matrix_up_h, 0, work_matrices_size_x * work_matrices_size_y * sizeof(vctl::MCVertex *));
    memset(node_matrix_up_v, 0, work_matrices_size_x * work_matrices_size_y * sizeof(vctl::MCVertex *));
    memset(node_matrix_down_h, 0, work_matrices_size_x * work_matrices_size_y * sizeof(vctl::MCVertex *));
    memset(node_matrix_down_v, 0, work_matrices_size_x * work_matrices_size_y * sizeof(vctl::MCVertex *));
    memset(node_matrix_middle, 0, work_matrices_size_x * work_matrices_size_y * sizeof(vctl::MCVertex *));
    memset(cube_code_matrix, 0, work_matrices_size_x * work_matrices_size_y * sizeof(unsigned char));
    memset(down_cube_code_matrix, 0, work_matrices_size_x * work_matrices_size_y * sizeof(unsigned char));
}

////////////////////////////////////////////////////////////
//

void CMarchingCubes::DeallocWorktMem()
{
    // free allocated work matrices memory
    if (state_matrix_up != NULL)        delete[] (state_matrix_up);
    if (state_matrix_down != NULL)      delete[] (state_matrix_down);
    if (node_matrix_up_h != NULL)       delete[] (node_matrix_up_h);
    if (node_matrix_up_v != NULL)       delete[] (node_matrix_up_v);
    if (node_matrix_down_h != NULL)     delete[] (node_matrix_down_h);
    if (node_matrix_down_v != NULL)     delete[] (node_matrix_down_v);
    if (node_matrix_middle != NULL)     delete[] (node_matrix_middle);
    if (cube_code_matrix != NULL)       delete[] (cube_code_matrix);
    if (down_cube_code_matrix != NULL)  delete[] (down_cube_code_matrix);

    // initialization of work matrices to NULL value
    state_matrix_up = NULL;
    state_matrix_down = NULL;
    node_matrix_up_h = NULL;
    node_matrix_up_v = NULL;
    node_matrix_down_h = NULL;
    node_matrix_down_v = NULL;
    node_matrix_middle = NULL;
    cube_code_matrix = NULL;
    down_cube_code_matrix = NULL;
}

////////////////////////////////////////////////////////////
//

void CMarchingCubes::MakeTri(int x, int y, unsigned char cube_code)
{
    vctl::MCPoint3D             edge_center;
    vctl::MCVertex              * tri_vertex[3];


    // cycle of tri
    for (int i = 0; i < 4; i++)
    {
        // test of tri existence for actual cube code
        if (node_state[cube_code][3*i] == -1)        return;

        // cycle of edge centers vertices for particular tri creating
        for (int h = 0; h < 3; h++)
        {
            // get edge centers vertices for particular tri creating
            if ( (tri_vertex[h] = GetCubeEdgeNode(node_state[cube_code][3*i+h], x, y)) == NULL )
            {
                // edge center calculation
                edge_center.SetX( ( cube_vertices[edge_indexes[node_state[cube_code][3*i+h]][0]].GetX() + cube_vertices[edge_indexes[node_state[cube_code][3*i+h]][1]].GetX() ) / 2.0 );
                edge_center.SetY( ( cube_vertices[edge_indexes[node_state[cube_code][3*i+h]][0]].GetY() + cube_vertices[edge_indexes[node_state[cube_code][3*i+h]][1]].GetY() ) / 2.0 );
                edge_center.SetZ( ( cube_vertices[edge_indexes[node_state[cube_code][3*i+h]][0]].GetZ() + cube_vertices[edge_indexes[node_state[cube_code][3*i+h]][1]].GetZ() ) / 2.0 );
                // create edge center vertex
                tri_vertex[h] = m_tris->GetVerticeS()->New(edge_center);
                // include new vertex into context data matrix
                SetCubeEdgeNode(node_state[cube_code][3*i+h], x, y, tri_vertex[h]);
            }
        }

        // create new tri
        m_tris->New(tri_vertex[0], tri_vertex[1], tri_vertex[2]);
    }
}

////////////////////////////////////////////////////////////
//

void CMarchingCubes::HoleFilling(int x, int y, unsigned char cube_code)
{
    unsigned char           down_code = GetCubeCodeDown(x, y);               // code of down cube 
    unsigned char           front_code = GetCubeCodeFront(x, y);             // code of front cube
    unsigned char           left_code = GetCubeCodeLeft(x, y);               // code of left cube


    // cycle for hole on cube down face
    for (int i = 0; i < 11; i++)
    {
        // test existence of hole code for down cube
        if (down_hole_code[cube_code][i] == -1)      break;
        // test unity of down cube hole code with down cube code => hole existence
        else if (down_hole_code[cube_code][i] == GetCubeCodeDown(x, y))
        {
            vctl::MCVertex              * hole_vertex[4];               // array of pointers of hole vertices

            // take hole vertices pointers
            hole_vertex[0] = GetCubeEdgeNode(0, x, y);
            hole_vertex[1] = GetCubeEdgeNode(1, x, y);
            hole_vertex[2] = GetCubeEdgeNode(2, x, y);
            hole_vertex[3] = GetCubeEdgeNode(3, x, y);

            // test of cube code node number
            if (CubeCodeNodeNumber(cube_code) > 4)
            {
                // created inverted tri to fill hole
                m_tris->New(hole_vertex[0], hole_vertex[2], hole_vertex[1]);
                m_tris->New(hole_vertex[2], hole_vertex[0], hole_vertex[3]);
            }
            else
            {
                // created tri to fill hole
                m_tris->New(hole_vertex[0], hole_vertex[1], hole_vertex[2]);
                m_tris->New(hole_vertex[2], hole_vertex[3], hole_vertex[0]);
            }

            break;
        }
    }

    // cycle for hole on cube front face
    for (int i = 0; i < 11; i++)
    {
        // test existence of hole code for front cube
        if (front_hole_code[cube_code][i] == -1)
            break;
        // test unity of front cube hole code with front cube code => hole existence
        else if (front_hole_code[cube_code][i] == GetCubeCodeFront(x, y))
        {
            vctl::MCVertex              * hole_vertex[4];               // array of pointers of hole vertices

            // take hole vertices pointers
            hole_vertex[0] = GetCubeEdgeNode(0, x, y);
            hole_vertex[1] = GetCubeEdgeNode(5, x, y);
            hole_vertex[2] = GetCubeEdgeNode(8, x, y);
            hole_vertex[3] = GetCubeEdgeNode(4, x, y);

            // test of cube code node number
            if (CubeCodeNodeNumber(cube_code) > 4)
            {
                // created inverted tri to fill hole
                m_tris->New(hole_vertex[0], hole_vertex[2], hole_vertex[3]);
                m_tris->New(hole_vertex[2], hole_vertex[0], hole_vertex[1]);
            }
            else
            {
                // created inverted tri to fill hole
                m_tris->New(hole_vertex[0], hole_vertex[3], hole_vertex[2]);
                m_tris->New(hole_vertex[2], hole_vertex[1], hole_vertex[0]);
            }

            break;
        }
    }

    // cycle for hole on cube left face
    for (int i = 0; i < 11; i++)
    {
        // test existence of hole code for left cube
        if (left_hole_code[cube_code][i] == -1)
            break;
        // test unity of left cube hole code with left cube code => hole existence
        else if (left_hole_code[cube_code][i] == left_code)
        {
            vctl::MCVertex              * hole_vertex[4];               // array of pointers of hole vertices

            // take hole vertices pointers
            hole_vertex[0] = GetCubeEdgeNode(3, x, y);
            hole_vertex[1] = GetCubeEdgeNode(7, x, y);
            hole_vertex[2] = GetCubeEdgeNode(11, x, y);
            hole_vertex[3] = GetCubeEdgeNode(4, x, y);

            // test of cube code node number
            if (CubeCodeNodeNumber(cube_code) > 4)
            {
                // created inverted tri to fill hole
                m_tris->New(hole_vertex[0], hole_vertex[2], hole_vertex[1]);
                m_tris->New(hole_vertex[2], hole_vertex[0], hole_vertex[3]);
            }
            else
            {
                // created inverted tri to fill hole
                m_tris->New(hole_vertex[0], hole_vertex[1], hole_vertex[2]);
                m_tris->New(hole_vertex[2], hole_vertex[3], hole_vertex[0]);
            }

            break;
        }
    }
}

////////////////////////////////////////////////////////////
//

vctl::MCVertex * CMarchingCubes::GetCubeEdgeNode(int edge_index, int x, int y)
{
    switch(edge_index)
    {
    case 0:
        return (*(node_matrix_down_h + y*work_matrices_size_x + x));
    case 1:
        return (*(node_matrix_down_v + y*work_matrices_size_x + x + 1));
    case 2:
        return (*(node_matrix_down_h + (y + 1)*work_matrices_size_x + x));
    case 3:
        return (*(node_matrix_down_v + y*work_matrices_size_x + x));
    case 4:
        return (*(node_matrix_middle + y*work_matrices_size_x + x));
    case 5:
        return (*(node_matrix_middle + y*work_matrices_size_x + x + 1));
    case 6:
        return (*(node_matrix_middle + (y + 1)*work_matrices_size_x + x + 1));
    case 7:
        return (*(node_matrix_middle + (y + 1)*work_matrices_size_x + x));
    case 8:
        return (*(node_matrix_up_h + y*work_matrices_size_x + x));
    case 9:
        return (*(node_matrix_up_v + y*work_matrices_size_x + x + 1));
    case 10:
        return (*(node_matrix_up_h + (y + 1)*work_matrices_size_x + x));
    case 11:
        return (*(node_matrix_up_v + y*work_matrices_size_x + x));
    }
    return NULL;
}

////////////////////////////////////////////////////////////
//

void CMarchingCubes::SetCubeEdgeNode(int edge_index, int x, int y, vctl::MCVertex * new_vertex)
{
    switch(edge_index)
    {
    case 0:
        *(node_matrix_down_h + y*work_matrices_size_x + x) = new_vertex;
        break;
    case 1:
        *(node_matrix_down_v + y*work_matrices_size_x + x + 1) = new_vertex;
        break;
    case 2:
        *(node_matrix_down_h + (y + 1)*work_matrices_size_x + x) = new_vertex;
        break;
    case 3:
        *(node_matrix_down_v + y*work_matrices_size_x + x) = new_vertex;
        break;
    case 4:
        *(node_matrix_middle + y*work_matrices_size_x + x) = new_vertex;
        break;
    case 5:
        *(node_matrix_middle + y*work_matrices_size_x + x + 1) = new_vertex;
        break;
    case 6:
        *(node_matrix_middle + (y + 1)*work_matrices_size_x + x + 1) = new_vertex;
        break;
    case 7:
        *(node_matrix_middle + (y + 1)*work_matrices_size_x + x) = new_vertex;
        break;
    case 8:
        *(node_matrix_up_h + y*work_matrices_size_x + x) = new_vertex;
        break;
    case 9:
        *(node_matrix_up_v + y*work_matrices_size_x + x + 1) = new_vertex;
        break;
    case 10:
        *(node_matrix_up_h + (y + 1)*work_matrices_size_x + x) = new_vertex;
        break;
    case 11:
        *(node_matrix_up_v + y*work_matrices_size_x + x) = new_vertex;
        break;
    }
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::TestTriOrientation()
{
    vctl::MCTri                * actual = m_tris->GetFirst();         // pointer on actual mesh tri, start with the first 


    // mesh tri cycle
    while (actual != NULL)
    {
        // test orientation of actual tri edges
        if (TestEdgeDirection(actual->GetVertex(0), actual->GetVertex(1)))
            return false;
        if (TestEdgeDirection(actual->GetVertex(1), actual->GetVertex(2)))
            return false;
        if (TestEdgeDirection(actual->GetVertex(2), actual->GetVertex(0)))
            return false;

        // take next tri
        actual = actual->GetNext();
    }

    return true;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::TestEdgeDirection(vctl::MCVertex * u0, vctl::MCVertex * u1)
{
    vctl::MCTri             * actual = u0->GetRegisteredTri();        // pointer on actual mesh tri around given vertex, start with the first 
    int                     i0[3], i1[3];                             // vertices indexes of given edge and actual vertex
    int                     numtri = 0;                               // number of tri for given edge
    int                     smer[3] = {0,0,0};                        // edge direction signs


    // tri cycle around first vertex
    while (actual != NULL)
    {
        // test of second vertex, if it belong to actual tri
        if (actual->IsVertexBool(u1))
        {
            // take indexes of given edge vertices
            i0[numtri] = actual->IsVertex(u0);
            i1[numtri] = actual->IsVertex(u1);

            // test edge directions
            if ( ((i0[numtri] == 0) && (i1[numtri] == 1)) || ((i0[numtri] == 1) && (i1[numtri] == 2)) || ((i0[numtri] == 2) && (i1[numtri] == 0)) )
                smer[numtri] = 1;
            else
                smer[numtri] = -1;
            // tri number incrementation
            numtri++;
            // test of edge tri number
            if (numtri == 2)
                break;
        }

        // take next tri around first vertex
        actual = actual->GetVertexTri(u0);
    }

    // evaluation of edges directions
    if (numtri == 2)
    {
        if ((smer[0] == 0) || (smer[1] == 0))
            return false;
        if (smer[0] == smer[1])
            return false;
    }

    return true;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::MarkupVertices()
{
    vctl::MCVertex                              * actual = m_tris->GetVerticeS()->GetFirst();           // pointer on actual mesh vertex, start with the first 
    std::vector<vctl::MCTri *>                  tri_list;                                               // vector of tris around actual vertex
    std::vector<vctl::MCTri *>::iterator        tri_list_iter;                                          // vector iterator of tris around actual vertex
    std::vector<vctl::MCTri *>::iterator        tri_list_iter_end;                                      // vector end iterator of tris around actual vertex
    vctl::MCVector3D                            first_normal, second_normal, actual_normal;             // tris normals
    int                                         vertex_type;                                            // type of vertex, 0 - flat (default), vctl::VERTEX_EDGE_FLAG, vctl::VERTEX_CORNER_FLAG


    // mesh vertices cycle
    while (actual != NULL)
    {
        // take tris around actual vertex
        actual->GetRegisteredTriList(tri_list);

        // remove all vertex flags
        actual->MaskFlag(vctl::VERTEX_CORNER_FLAG | vctl::VERTEX_EDGE_FLAG);

        // calculate first tri normal and prepare tris cycle
        tri_list_iter_end = tri_list.end();
        tri_list_iter = tri_list.begin();
        (*tri_list_iter)->GetNormal(first_normal);
        vertex_type = 0;
        ++tri_list_iter;

        // cycle of tris around actual vertex
        for (; tri_list_iter < tri_list_iter_end; ++tri_list_iter)
        {
            assert(*tri_list_iter != NULL);
            // calculate normal of actual tri
            (*tri_list_iter)->GetNormal(actual_normal);

            // compare first and actual normal
            if ((first_normal * actual_normal) < 0.99999)
            {
                if (vertex_type == 0)
                {
                    // actual vertex is edge or corner 
                    vertex_type = vctl::VERTEX_EDGE_FLAG;
                    second_normal = actual_normal;
                }
                else
                {
                    // compare second and actual normal
                    if ((second_normal * actual_normal) < 0.99999)
                    {
                        // actual vertex is corner
                        vertex_type = vctl::VERTEX_CORNER_FLAG;
                        actual->SetFlag(vctl::VERTEX_CORNER_FLAG);
                        break;
                    }
                }
            }
        }

        // set edge flag
        if (vertex_type == vctl::VERTEX_EDGE_FLAG)
            actual->SetFlag(vctl::VERTEX_EDGE_FLAG);

        // take next mesh vertex
        actual = actual->GetNext();
    }

    // OK
    return true;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::ReduceFlatAreas(vctl::MCTriS & tris)
{
    vctl::MCVertex                              * actual = m_tris->GetVerticeS()->GetFirst();           // pointer on actual mesh vertex, start with the first 
    vctl::MCVertex                              * eliminated_vertex;                                    // pointer on eliminated vertex


    // save pointers on actual tri mesh
    m_tris = &tris;

    // markup vertices of input tri, divide them on geometry groups
    if ( ! MarkupVertices())
        return false;

    // mesh vertices cycle
    while (actual != NULL)
    {
        // save pointer on eliminated vertex
        eliminated_vertex = actual;
        // take next mesh vertex
        actual = actual->GetNext();

        // test actual vertex type
        if (eliminated_vertex->TestFlag(vctl::VERTEX_EDGE_FLAG))
        {
            EliminateEdgeVertex(eliminated_vertex);
        }
        else if ( ! eliminated_vertex->TestFlag(vctl::VERTEX_CORNER_FLAG))
        {
            EliminateFlatVertex(eliminated_vertex);
        }
    }

    // swap mesh edges to improve quality
    if ( ! SwapTriEdges())
        return false;

    // cycle of tri mesh vertices to remove vertex flags
    actual = m_tris->GetVerticeS()->GetFirst();
    while (actual != NULL)
    {
        // remove all vertex flags
        actual->MaskFlag(vctl::VERTEX_CORNER_FLAG | vctl::VERTEX_EDGE_FLAG);

        // take next mesh vertex
        actual = actual->GetNext();
    }

    // OK
    return true;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::EliminateFlatVertex(vctl::MCVertex * eliminate_vertex)
{
    std::vector<vctl::MCTri *>                  tri_list;                                               // vector of tris around eliminated vertex
    std::vector<vctl::MCTri *>::iterator        tri_list_iter;                                          // vector iterator of tris around eliminated vertex
    std::vector<vctl::MCTri *>::iterator        tri_list_iter_end;                                      // vector end iterator of tris around eliminated vertex
    vctl::MCVertex                              * rest_edge_u0, * rest_edge_u1;                         // pointers on actual tri vertices of rest edge against eliminated vertex


    // take tris around eliminated vertex
    eliminate_vertex->GetRegisteredTriList(tri_list);

    // cycle of tris around actual vertex
    tri_list_iter_end = tri_list.end();
    for (tri_list_iter = tri_list.begin(); tri_list_iter < tri_list_iter_end; ++tri_list_iter)
    {
        assert(*tri_list_iter != NULL);
        // take actual tri edge against eliminated vertex
        (*tri_list_iter)->GetRestEdge(eliminate_vertex, &rest_edge_u0, &rest_edge_u1);
        // collapse eliminate vertex into actual tri rest edge first vertex
        if (CollapseEdge(eliminate_vertex, rest_edge_u0, tri_list))
            return true;    // collapse complete
    }

    // no collapse
    return false;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::EliminateEdgeVertex(vctl::MCVertex * eliminate_vertex)
{
    std::vector<vctl::MCTri *>                  tri_list;                                               // vector of tris around eliminated vertex
    std::vector<vctl::MCTri *>::iterator        tri_list_iter;                                          // vector iterator of tris around eliminated vertex
    std::vector<vctl::MCTri *>::iterator        tri_list_iter_end;                                      // vector end iterator of tris around eliminated vertex
    vctl::MCVertex                              * rest_edge_u0, * rest_edge_u1;                         // pointers on actual tri vertices of rest edge against eliminated vertex


    // take tris around eliminated vertex
    eliminate_vertex->GetRegisteredTriList(tri_list);

    // cycle of tris around actual vertex
    tri_list_iter_end = tri_list.end();
    for (tri_list_iter = tri_list.begin(); tri_list_iter < tri_list_iter_end; ++tri_list_iter)
    {
        assert(*tri_list_iter != NULL);
        // take actual tri edge against eliminated vertex
        (*tri_list_iter)->GetRestEdge(eliminate_vertex, &rest_edge_u0, &rest_edge_u1);
        // test collapse candidate result vertex to be edge vertex
        if (rest_edge_u0->TestFlag(vctl::VERTEX_EDGE_FLAG) || rest_edge_u0->TestFlag(vctl::VERTEX_CORNER_FLAG))
        {
            // collapse eliminate vertex into actual tri rest edge first vertex
            if (CollapseEdge(eliminate_vertex, rest_edge_u0, tri_list))
                return true;    // collapse complete
        }
    }

    // no collapse
    return false;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::CollapseEdge(vctl::MCVertex * eliminate_vertex, vctl::MCVertex * result_vertex, std::vector<vctl::MCTri *> & tri_list)
{
    std::vector<vctl::MCTri *>::iterator        tri_list_iter;                                          // vector iterator of tris around eliminated vertex
    std::vector<vctl::MCTri *>::iterator        tri_list_iter_end;                                      // vector end iterator of tris around eliminated vertex
    vctl::MCVertex                              * rest_edge_u0, * rest_edge_u1;                         // pointers on actual tri vertices of rest edge against eliminated vertex
    vctl::MCVector3D                            normal_before, normal_after;                            // normal of actual tri, before and after of collapse


    // cycle of tris around actual vertex, to test collapse possibility
    tri_list_iter_end = tri_list.end();
    for (tri_list_iter = tri_list.begin(); tri_list_iter < tri_list_iter_end; ++tri_list_iter)
    {
        assert(*tri_list_iter != NULL);
        // test actual tri for result vertex
        if ( ! (*tri_list_iter)->IsVertexBool(result_vertex))
        {
            // take actual tri edge against eliminated vertex
            (*tri_list_iter)->GetRestEdge(eliminate_vertex, &rest_edge_u0, &rest_edge_u1);
            // calculate actual tri normal before and after collapse
            vctl::MCVector3D::MakeNormal(eliminate_vertex, rest_edge_u0, rest_edge_u1, normal_before);
            vctl::MCVector3D::MakeNormal(result_vertex, rest_edge_u0, rest_edge_u1, normal_after);
            // @todo test tri area after collpase ??????????
            // test actual tri overturn because of collapse
            if ( (normal_before * normal_after) <= 0.9999 )
                return false;   // collapse is not possible
        }
    }

    // cycle of tris around actual vertex, to realize collapse
    tri_list_iter_end = tri_list.end();
    for (tri_list_iter = tri_list.begin(); tri_list_iter < tri_list_iter_end; ++tri_list_iter)
    {
        assert(*tri_list_iter != NULL);
        // test actual tri for result vertex
        if ( ! (*tri_list_iter)->IsVertexBool(result_vertex))
        {
            // change eliminated vertex by result vertex for actual tri
            (*tri_list_iter)->DeRegistration();
            (*tri_list_iter)->ChangeVertex(eliminate_vertex, result_vertex);
            (*tri_list_iter)->Registration();
        }
        else
        {
            // erase actual vertex
            m_tris->Erase(*tri_list_iter);
        }
    }

    // erase eliminated vertex
    m_tris->GetVerticeS()->Erase(eliminate_vertex);

    // OK
    return true;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::SwapTriEdges()
{
    vctl::MCTri                     * actual = m_tris->GetFirst();          // pointer on actual mesh tri, start with the first 
    int                             swap_number;                            // number of realized swaps


    do 
    {
        // initialization
        swap_number = 0;
        actual = m_tris->GetFirst();

        // mesh tris cycle
        while (actual != NULL)
        {
            // swap actual tri to improve his quality (shape)
            if ( SwapTriImproveQuality(actual))
                ++swap_number;

            // take next mesh tri
            actual = actual->GetNext();
        }

        std::cout << ", " << swap_number;
    } while (swap_number != 0);

    // OK
    return true;
}

////////////////////////////////////////////////////////////
//

bool CMarchingCubes::SwapTriImproveQuality(vctl::MCTri * swap_tri)
{
    vctl::MCTri             * neighbor_tri;                                  // pointer on maximal edge neighbor tri
    vctl::MCTri             work_tri;                                        // working tri 
    vctl::MCVector3D        swap_normal, neighbor_normal, work_normal;       // normals of swapped tris
    vctl::MCVertex          * swap_edge_u0, * swap_edge_u1;                  // pointers on swapped edge vertices
    vctl::MCVertex          * swap_vertex, * neighbor_vertex;                // pointers on swapped tris rest vertices
    double                  swap_quality, neighbor_quality, actual_quality;  // actual tris quality
    int                     max_edge;                                        // index of maximal edge


    assert(swap_tri != NULL);

    // take max edge of swapped tri
    max_edge = swap_tri->GetMaxEdge();

    // take neighbor tri by max edge
    neighbor_tri = swap_tri->GetNeighbour(max_edge);
    assert(neighbor_tri != NULL);

    // calculate normals of both tris to swap
    swap_tri->GetNormal(swap_normal);
    neighbor_tri->GetNormal(neighbor_normal);
    // test, if tris to swap are in plane
    if ((swap_normal * neighbor_normal) < 0.99999)
        return false;

    // take vertices of swapped edge
    swap_tri->GetEdge(max_edge, &swap_edge_u0, &swap_edge_u1);
    // take rest vertices of both swapped tris
    swap_vertex = swap_tri->GetRestVertex(swap_edge_u0, swap_edge_u1);
    neighbor_vertex = neighbor_tri->GetRestVertex(swap_edge_u0, swap_edge_u1);
    assert((swap_vertex != NULL) && (neighbor_vertex != NULL));

    // calculate quality of swapped tris
    swap_quality = swap_tri->GetQuality();
    neighbor_quality = neighbor_tri->GetQuality();

    // take maximal actual quality
    actual_quality = (swap_quality > neighbor_quality) ? swap_quality : neighbor_quality;

    // make first variant working normal, quality and test results of swap
    work_tri.SetVerticeS(swap_vertex, neighbor_vertex, swap_edge_u1);
    work_tri.GetNormal(work_normal);
    swap_quality = work_tri.GetQuality();
    // test swap tri overturn because of swap
    if ((swap_normal * work_normal) < 0.9999)
        return false;
    // test working tri area
    if (work_tri.GetArea() < 0.000000001)
        return false;

    // make second variant working normal, quality and test results of swap
    work_tri.SetVerticeS(neighbor_vertex, swap_vertex, swap_edge_u0);
    work_tri.GetNormal(work_normal);
    neighbor_quality = work_tri.GetQuality();
    // test swap tri overturn because of swap
    if ((swap_normal * work_normal) < 0.9999)
        return false;
    // test working tri area
    if (work_tri.GetArea() < 0.000000001)
        return false;

    // take maximal quality after swap
    swap_quality = (swap_quality > neighbor_quality) ? swap_quality : neighbor_quality;

    // compare actual and swap quality
    if (swap_quality >= actual_quality)
        return false;           // actual quality is better then quality after swap

    // test existence of swapped tri
    if (m_tris->TestExistence(swap_vertex, neighbor_vertex, swap_edge_u1) != NULL)
        return false;
    if (m_tris->TestExistence(neighbor_vertex, swap_vertex, swap_edge_u0) != NULL)
        return false;

    // swap realization
    swap_tri->DeRegistration();
    neighbor_tri->DeRegistration();
    swap_tri->SetVerticeS(swap_vertex, neighbor_vertex, swap_edge_u1);
    neighbor_tri->SetVerticeS(neighbor_vertex, swap_vertex, swap_edge_u0);
    swap_tri->Registration();
    neighbor_tri->Registration();

    // swap is realized
    return true;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

