//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    LoadSTLModule.cpp                   \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 * - Sample module.
 */

#include "LoadSTLModule.h"

#include <VectorEntity/mctris.h>

// MDSTk
#include <MDSTk/Math/mdsBase.h>

// STL
//#include <sstream>


//==============================================================================
/*
 * Global constants.
 */

//! Module description
const std::string MODULE_DESCRIPTION    = "Module for loading STL tri mesh into MDSTk::VectorEntity library native TRI format.";

//==============================================================================
/*
 * Implementation of the class CLoadSTLModule.
 */
CLoadSTLModule::CLoadSTLModule(const std::string& sDescription)
    : mds::mod::CModule(sDescription)
{
}

//==============================================================================

CLoadSTLModule::~CLoadSTLModule()
{
}

//==============================================================================

bool CLoadSTLModule::startup()
{
    // Note
    MDS_LOG_NOTE("Module startup");

    // Test existence of input and output channel
    if( getNumOfInputs() != 1 || getNumOfOutputs() != 1 )
    {
        MDS_CERR('<' << m_sFilename << "> Wrong number of input and output channels" << std::endl);
        return false;
    }

    // O.K.
    return true;
}

//==============================================================================

bool CLoadSTLModule::main()
{
    // Note
    MDS_LOG_NOTE("Module main function");

    // I/O channels
    mds::mod::CChannel *pIChannel = getInput(0);
    mds::mod::CChannel *pOChannel = getOutput(0);

    // Is any input?
    if( !pIChannel->isConnected() )
    {
        return false;
    }

    // Create a new triangle mesh
    vctl::MCTriS                tri_mesh;

    // Wait for data
    if( pIChannel->wait(1000) )
    {
        // Read STL triangle mesh from the input channel
        //if( readInput(pIChannel, &tri_mesh) )
        if ( tri_mesh.LoadSTL(*pIChannel) )
        {
            // Write input triangle mesh to the output channel in STL format
            // if ( !tri_mesh.SaveSTL(*pOChannel) )
            if( !writeOutput(pOChannel, &tri_mesh) )
            {
                MDS_CERR('<' << m_sFilename << "> Failed to write the output TRI mesh" << std::endl);
            }

        }
        else
        {
            MDS_CERR('<' << m_sFilename << "> Failed to read input STL mesh!" << std::endl);
            return false;
        }
    }
    else
    {
        MDS_LOG_NOTE("Wait timeout");
    }

    // Returning true means to continue processing the input channel
    return true;
}

//==============================================================================

void CLoadSTLModule::shutdown()
{
    // Note
    MDS_LOG_NOTE("Module shutdown");
}

//==============================================================================

void CLoadSTLModule::writeExtendedUsage(std::ostream& Stream)
{
}


//==============================================================================
/*
 * Function main() which creates and executes the console application.
 */
int main(int argc, char *argv[])
{
    // Creation of the module using smart pointer
    CLoadSTLModulePtr spModule(new CLoadSTLModule(MODULE_DESCRIPTION));

    // Initialize and execute the module
    if( spModule->init(argc, argv) )
    {
        spModule->run();
    }

    // Console application finished
    return 0;
}

