//==============================================================================
/*! \file
 *
 * Author:  Premysl Krsek, krsek@fit.vutbr.cz   \n
 * File:    Tri2STL.cpp                         \n
 * Date:    2008/10                             \n
 *
 * $Id:$
 * - Sample module.
 */

#include "Tri2STLModule.h"

#include <VectorEntity/mctris.h>

// MDSTk
#include <MDSTk/Math/mdsBase.h>
#include <MDSTk/Image/mdsDensityVolume.h>

//#include <MDSTk/Image/mdsPixelTraits.h>
//#include <MDSTk/Image/mdsImageFunctions.h>

// STL
//#include <sstream>


//==============================================================================
/*
 * Global constants.
 */

//! Module description
const std::string MODULE_DESCRIPTION    = "Module for translation from MDSTk::VectorEntity library native TRI format into STL format.";

//==============================================================================
/*
 * Implementation of the class CTri2STLModule.
 */
CTri2STLModule::CTri2STLModule(const std::string& sDescription)
    : mds::mod::CModule(sDescription)
{
}

//==============================================================================

CTri2STLModule::~CTri2STLModule()
{
}

//==============================================================================

bool CTri2STLModule::startup()
{
    // Note
    MDS_LOG_NOTE("Module startup");

    // Test existence of input and output channel
    if( getNumOfInputs() != 1 || getNumOfOutputs() != 1 )
    {
        MDS_CERR('<' << m_sFilename << "> Wrong number of input and output channels" << std::endl);
        return false;
    }

    // O.K.
    return true;
}

//==============================================================================

bool CTri2STLModule::main()
{
    // Note
    MDS_LOG_NOTE("Module main function");

    // I/O channels
    mds::mod::CChannel *pIChannel = getInput(0);
    mds::mod::CChannel *pOChannel = getOutput(0);

    // Is any input?
    if( !pIChannel->isConnected() )
    {
        return false;
    }

    // Create a new triangle mesh
    vctl::MCTriS                tri_mesh;

    // Wait for data
    if( pIChannel->wait(1000) )
    {
        // Read triangle mesh from the input channel
        if( readInput(pIChannel, &tri_mesh) )
        {
            // Write input triangle mesh to the output channel in STL format
            if ( !tri_mesh.SaveSTL(*pOChannel) )
            {
                MDS_CERR('<' << m_sFilename << "> Failed to write the output STL triangle mesh" << std::endl);
            }

        }
        else
        {
            MDS_CERR('<' << m_sFilename << "> Failed to read input MDSTk::VectorEntity Triangle mesh!" << std::endl);
            return false;
        }
    }
    else
    {
        MDS_LOG_NOTE("Wait timeout");
    }

    // Returning true means to continue processing the input channel
    return true;
}

//==============================================================================

void CTri2STLModule::shutdown()
{
    // Note
    MDS_LOG_NOTE("Module shutdown");
}

//==============================================================================

void CTri2STLModule::writeExtendedUsage(std::ostream& Stream)
{
}


//==============================================================================
/*
 * Function main() which creates and executes the console application.
 */
int main(int argc, char *argv[])
{
    // Creation of the module using smart pointer
    CTri2STLModulePtr spModule(new CTri2STLModule(MODULE_DESCRIPTION));

    // Initialize and execute the module
    if( spModule->init(argc, argv) )
    {
        spModule->run();
    }

    // Console application finished
    return 0;
}

