/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Model.cpp - UMDA statistical model implementation 		    */
/*           - implementation file                                  */
/*------------------------------------------------------------------*/


#pragma hdrstop

#include "Model.h"
//---------------------------------------------------------------------------
#include <map>
#include <iterator>
#include "Random.h"
#include "GeneticCore.h"

using namespace std;

extern Random RandomGenerator;

/**
 *  UMDAModel - constructor
*/
UMDAModel::UMDAModel(int AParentCount, int AChromozomeSize)
  : FParentCount(AParentCount), FChromozomeSize (AChromozomeSize){


  FParentPopulation.clear();
  FModel.clear();

} // end of UMDAModel::UMDAModel
//--------------------------------------------------------------------------------


/**
 *  UMDAModel::~UMDAModel - destructor
*/
UMDAModel::~UMDAModel(){
 FParentPopulation.clear();
 FModel.clear();
} // end of UMDAModel::~UMDAModel
//--------------------------------------------------------------------------------


/**
 *  UMDAModel::CreateModel - model creation
*/
void UMDAModel::CreateModel(){
  FModel.clear();

  for (int GeneIndex = 0; GeneIndex < FChromozomeSize; GeneIndex ++){

    TMapaAllel MapaAllel;
    for (int ChromozomeIndex = 0; ChromozomeIndex < FParentCount; ChromozomeIndex ++){

        /* create map of keys */
       MapaAllel[FParentPopulation[ChromozomeIndex][GeneIndex]] += 1;
    }

     /* probability calculation */
     TMapaAllel::iterator p;
     double SumaPst = 0;

     for (p=MapaAllel.begin(); p != MapaAllel.end(); p++) {

       double Pst = p->second / FParentCount;
       Pst += SumaPst;
       SumaPst = Pst;
       p->second = Pst;
     }

    FModel.push_back(MapaAllel);
  }
}// end of UMDAModel::CreateModel
//--------------------------------------------------------------------------------


/**
 * UMDAModel::SampleChromozome - sample model
*/
void UMDAModel::SampleChromozome(Chromozome &chr){

  for (int GeneIndex = 0 ; GeneIndex < FChromozomeSize; GeneIndex ++){
    double RndNumber = RandomGenerator.DoubleRandom();

    TMapaAllel::iterator p;
    for (p=FModel[GeneIndex].begin(); p!= FModel[GeneIndex].end(); p++){
      if (p->second >RndNumber) {
        chr[GeneIndex] = p->first;
        break;
      }
    }

  }
  chr.SetNoEvaluated();
}// end of UMDAModel::SampleChromozome
//--------------------------------------------------------------------------------


/**
 * UMDAModel::ClearParentPopulation 
*/
void UMDAModel::ClearParentPopulation(){

  FParentPopulation.clear();
}// end of UMDAModel::ClearParentPopulation
//--------------------------------------------------------------------------------


/**
 * UMDAModel::AddParent
*/
void UMDAModel::AddParent(Chromozome &chr){

 FParentPopulation.push_back(chr);
}// end of UMDAModel::AddParent
//--------------------------------------------------------------------------------


#pragma package(smart_init)
