/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Model.h - UMDA statistical model implementation 		    */
/*         - header file	                                    */
/*------------------------------------------------------------------*/


#ifndef ModelH
#define ModelH
//---------------------------------------------------------------------------
#include <vector>
#include <map>
#include "Random.h"
#include "Chromozome.h"

typedef map<int, double, less<int> > TMapaAllel;

/**
 *  UMDAModel - class of UMDA model
*/
class UMDAModel{
  private:
    int FParentCount;
    int FChromozomeSize;

    vector<Chromozome> FParentPopulation;

    vector < TMapaAllel > FModel;

  protected:

  public:
     UMDAModel(int AParentCount, int AChromozomeSize);
     ~UMDAModel();
     void CreateModel();
     void ClearParentPopulation();
     void AddParent(Chromozome &chr);
     void SampleChromozome(Chromozome &chr);
};// end of UMDAModel
//--------------------------------------------------------------------------------





#endif
