/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Statistics.h - UMDA statistics implementation 		    */
/*              - header file                           	    */
/*------------------------------------------------------------------*/

#ifndef _Statistics_h_
#define _Statistics_h_

#include "Chromozome.h"
#include "Population.h"

using namespace std;

/**
 *  Statistics - class
*/
class Statistics{
  private :
    double  FMax;
    double  FMin;
    double  FAvg;
    double  FDiv;
    Chromozome* FBestChromozome;
    Population* FPopulation;
  public :
    Statistics(Population* Pop);
    double Max() { return FMax; };
    double Min() { return FMin; };
    double Avg() { return FAvg; };
    double Diver() {return FDiv;};
    Chromozome& BestChromozome() {return (*FBestChromozome);};

    void Compute();
 };// end of Statistics
//--------------------------------------------------------------------------------


#endif
