/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* UMDA.cpp - main file 			 		    */
/*------------------------------------------------------------------*/


#include <iostream>
#include <vector>
#include <algorithm>
#include <math.h>
#include <limits.h>

#include "Chromozome.h"
#include "Population.h"
#include "Statistics.h"
#include "GeneticCore.h"
#include "Random.h"

#include "GeneticOperators.h"
#include "MNB.h"
#include <omp.h>

using namespace std;

/**
 *  main - main function 
*/
int main(int argc, char** argv)
{
  double StartTime = (clock()*1.0/CLOCKS_PER_SEC);


  if (argc < 8){
    cout << "-- Bad parameters count --" << endl;
    cout << "   Correct parameters are: "<< endl;
    cout << "   1) Input file name " << endl;
    cout << "   2) Number of communication step " << endl;
    cout << "   3) Population size " << endl;
    cout << "   4) Max generation  " << endl;
    cout << "   5) Mutation rate " << endl;
    cout << "   6) Max. number of extra links in paths " << endl;
    cout << "   7) Number of threads " << endl;
    cout << "   8) Surround size - optional" << endl;

    return 0;
  }


  extern unsigned int MaxExtraSteps;
  extern unsigned int SurroundSize;
  SurroundSize = INT_MAX;

    //-- inicialization of surround size --//
  if (argc == 9) { SurroundSize = atoi(argv[8]);}
  MaxExtraSteps   = atoi(argv[6]);
  omp_set_num_threads(atoi(argv[7]));


  GeneticCore GA;



  //___________________  function pointer set ____________________//
  GA.SetOnInitAlgorithm(OABOnInitAlgorithm);
  GA.SetChromozomeInitFunction(MNBInitChromozome);

  GA.SetFitnessFunction(MNBFitnessFunction);
  GA.SetMutationFunction(MNBMutation);

  GA.SetOnFinishGeneration(OABOnFinishGeneration);
  GA.SetOnFinish(OABOnFinish);


  int PopulationSize  = atoi(argv[3]);
  int GenerationCount = atoi(argv[4]);
  double MutationRate = atof(argv[5]);

  GA.SetPopulationSize(PopulationSize);
  GA.SetMutationPst(MutationRate);

  GA.SetMaxGeneration(GenerationCount);
  GA.SetSelectionPercentage(50);
  GA.SetOffspringPercentage(66);


  cout << "_______________EvoCCs_broadcast_________________" << endl;
  cerr << "_______________EvoCCs_broadcast_________________" << endl;
  cout << "Topology name = " <<  argv[1] << endl;
  cerr << "Topology name = " <<  argv[1] << endl;
  cout << "Population Size = " << PopulationSize << endl;
  cout << "Mutation Pst = " << MutationRate << endl;
  cerr << "Population Size = " << PopulationSize << endl;
  cerr << "Mutation Pst = " << MutationRate << endl;
  cerr << "Max. number of extra links in paths= " <<  MaxExtraSteps << endl;
  cout << "Max. number of extra links in paths= " <<  MaxExtraSteps << endl;

  GA.Start(argc, argv);

  cout << endl << "End of algorithm, ComputationTime = " << (clock()*1.0/CLOCKS_PER_SEC) - StartTime << endl;

}// main
//--------------------------------------------------------------------------------




