/*------------------------------------------------------------------*/
/* EvoCCs_scatter						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Population.ch - UMDA population implementation 		    */
/*               - header fil		                            */
/*------------------------------------------------------------------*/

#ifndef _Population_h_
#define _Population_h_

#include "Chromozome.h"
#include <vector>


using namespace std;

typedef void TInitChromozome(Chromozome& chr);

/**
 *  Population - class
*/
class Population{
  private :
    vector<Chromozome> FPopulation;
    int FChromozomeSize;
    TInitChromozome* FInitChromozome;
    TComputeFitness* FComputeFunction;
  public:
    Population(int ChromozomeSize ,
               TInitChromozome* InitChromozomeFunction, TComputeFitness* FitnessFunction)
      {
        FInitChromozome = InitChromozomeFunction;
        FComputeFunction = FitnessFunction;
        FChromozomeSize = ChromozomeSize;
        };

     Population(const Population &pop);
     Population & operator = (const Population &pop);

     void InitPopulation(int PopulationSize);

     int PopulationSize() { return FPopulation.size();};
     int ChromozomeSize() {return FChromozomeSize;};

     void Add(Chromozome& chr);
     void Delete(int index);
     void Clear() { FPopulation.clear();};
     void Resize(int new_size);

     void Sort();

     Chromozome& operator[] (int index){ return FPopulation[index]; };
};// end of Population
//--------------------------------------------------------------------------------


#endif
