/*------------------------------------------------------------------*/
/* EvoCCs_scatter						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Statistics.cpp - UMDA statistics implementation 		    */
/*                - implementation file                             */
/*------------------------------------------------------------------*/

#include "Statistics.h"
#include "Chromozome.h"
#include "Population.h"
#include <stdio.h>
#include <math.h>

using namespace std;

/**
 *  Statistics::Statistics - constructor
*/
Statistics::Statistics(Population* Pop){
 FMin = 0;
 FMax = 0;
 FAvg = 0;
 FDiv = 0;
 FBestChromozome = new Chromozome(Pop->ChromozomeSize(), NULL);
 FPopulation = Pop;
}// end of Population::InitPopulation
//--------------------------------------------------------------------------------


/**
 *  Statistics::Compute - Compute basic statistics
*/
void Statistics::Compute(){
  int i;
  double Sum = 0;
  double Sum2 = 0;
  FMin = (*FPopulation)[0].Fitness();
  FMax = (*FPopulation)[0].Fitness();
  *FBestChromozome = (*FPopulation)[0];

  for (int i=0; i<FPopulation->PopulationSize();i++){
    if (FMax < (*FPopulation)[i].Fitness()) {
      FMax = (*FPopulation)[i].Fitness();
      *FBestChromozome = (*FPopulation)[i];
    }
    if (FMin > (*FPopulation)[i].Fitness())
      FMin = (*FPopulation)[i].Fitness();

    Sum += (*FPopulation)[i].Fitness();
    Sum2 += (*FPopulation)[i].Fitness() * (*FPopulation)[i].Fitness();
  }

  FAvg = Sum / FPopulation->PopulationSize();
  FDiv = sqrt(fabs((Sum2 / FPopulation->PopulationSize()) - (FAvg * FAvg)));
}// end of Statistics::Compute
//-------------------------------------------------------------------------------

